/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.CidsLayerFactory;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.featureservice.JDBCFeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroup;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.raster.wms.featuresupportlayer.SimpleFeatureSupportingRasterLayer;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class LayerCollection
extends ArrayList<Object>
implements ServiceLayer {
    private static final Logger LOG = Logger.getLogger(LayerCollection.class);
    public static final String XML_ELEMENT_NAME = "LayerCollection";
    private String name = "unbenannt";
    private ActiveLayerModel model = null;
    private int layerPosition;
    private float translucency;
    private Element initElement = null;

    public LayerCollection() {
    }

    public LayerCollection(Element e, HashMap<String, WMSCapabilities> capabilities, ActiveLayerModel model) {
        this.model = model;
        try {
            LOG.info((Object)("creating new FeatureService instance from xml element '" + e.getName() + "'"));
            if (!e.getName().equals(XML_ELEMENT_NAME)) {
                LOG.error((Object)("LayerCollection could not be initailised from xml: unsupported element '" + e.getName() + "'"));
                throw new ClassNotFoundException("LayerCollection could not be initailised from xml: unsupported element '" + e.getName() + "'");
            }
            this.initFromElement(e, capabilities);
        }
        catch (Exception ex) {
            LOG.error((Object)"Exception while creating LayerCollection", (Throwable)ex);
        }
    }

    private void initFromElement(Element element, HashMap<String, WMSCapabilities> capabilities) throws Exception {
        if (element == null) {
            element = this.getInitElement();
        } else {
            this.setInitElement((Element)element.clone());
        }
        if (element.getAttributeValue("name") != null) {
            this.setName(element.getAttributeValue("name"));
        }
        if (element.getAttributeValue("enabled") != null) {
            this.setEnabled(Boolean.valueOf(element.getAttributeValue("enabled")));
        }
        if (element.getAttributeValue("translucency") != null) {
            this.setTranslucency(element.getAttribute("translucency").getFloatValue());
        }
        if (element.getAttributeValue("layerPosition") != null) {
            this.setLayerPosition(element.getAttribute("layerPosition").getIntValue());
        }
        this.createLayers(element, capabilities);
    }

    private void createLayers(Element conf, HashMap<String, WMSCapabilities> capabilities) {
        Element[] orderedLayers;
        Element layerElement = conf.getChild("Layers");
        if (layerElement == null) {
            LOG.error((Object)"no valid layers element found");
            return;
        }
        LOG.info((Object)("restoring " + layerElement.getChildren().size() + " layers from xml configuration"));
        for (Element element : orderedLayers = CidsLayerFactory.orderLayers(layerElement)) {
            this.createLayer(element, capabilities);
        }
    }

    private void createLayer(Element element, HashMap<String, WMSCapabilities> capabilities) {
        try {
            ServiceLayer layer = CidsLayerFactory.createLayer(element, capabilities, this.model);
            if (layer != null) {
                this.add(layer);
                if (layer instanceof RetrievalServiceLayer) {
                    this.model.registerRetrievalServiceLayer((RetrievalServiceLayer)layer);
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Layer layer '" + element.getName() + "' could not be created: \n" + t.getMessage()), t);
        }
    }

    public void setCrs(Crs srs) {
        for (Object layer : this) {
            if (layer instanceof WMSServiceLayer) {
                ((WMSServiceLayer)layer).setSrs(srs.getCode());
                continue;
            }
            if (layer instanceof SlidableWMSServiceLayerGroup) {
                ((SlidableWMSServiceLayerGroup)layer).setSrs(srs.getCode());
                continue;
            }
            if (layer instanceof WebFeatureService) {
                ((WebFeatureService)layer).setCrs(srs);
                continue;
            }
            if (layer instanceof ShapeFileFeatureService) {
                ((ShapeFileFeatureService)layer).setCrs(srs);
                continue;
            }
            if (layer instanceof JDBCFeatureService) {
                ((JDBCFeatureService)layer).setCrs(srs);
                continue;
            }
            if (layer instanceof LayerCollection) {
                ((LayerCollection)layer).setCrs(srs);
                continue;
            }
            LOG.error((Object)("The SRS of a layer cannot be changed. Layer is of type  " + layer.getClass().getName()));
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Element toElement() {
        Element element = new Element(XML_ELEMENT_NAME);
        element.setAttribute("name", this.getName());
        element.setAttribute("enabled", Boolean.valueOf(this.isEnabled()).toString());
        element.setAttribute("translucency", new Float(this.getTranslucency()).toString());
        element.setAttribute("layerPosition", new Integer(this.getLayerPosition()).toString());
        Iterator it = this.iterator();
        Element allLayerConf = new Element("Layers");
        int counter = 0;
        while (it.hasNext()) {
            Object service = it.next();
            if (service instanceof ServiceLayer) {
                ((ServiceLayer)service).setLayerPosition(counter);
            }
            if (service instanceof SimpleFeatureSupportingRasterLayer) continue;
            Element layerConf = CidsLayerFactory.getElement(service);
            allLayerConf.addContent((Content)layerConf);
            ++counter;
        }
        if (counter == 0) {
            // empty if block
        }
        element.addContent((Content)allLayerConf);
        return element;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Object tmp : this) {
            if (tmp instanceof LayerCollection) {
                ((LayerCollection)tmp).setEnabled(enabled);
                continue;
            }
            if (!(tmp instanceof ServiceLayer)) continue;
            ((ServiceLayer)tmp).setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        boolean enabled = false;
        for (Object tmp : this) {
            RetrievalServiceLayer rl;
            TreePath tp;
            if (tmp instanceof LayerCollection) {
                if (!((LayerCollection)tmp).isEnabled()) continue;
                enabled = true;
                continue;
            }
            if (!(tmp instanceof ServiceLayer)) continue;
            if (((ServiceLayer)tmp).isEnabled()) {
                enabled = true;
            }
            if (this.model == null || !((tp = new TreePath(new Object[]{this, tmp})).getLastPathComponent() instanceof RetrievalServiceLayer) || (rl = (RetrievalServiceLayer)tp.getLastPathComponent()).getPNode() != null) continue;
            this.model.registerRetrievalServiceLayer(rl);
        }
        return enabled;
    }

    @Override
    public boolean add(Object e) {
        if (e instanceof LayerCollection) {
            ((LayerCollection)e).setModel(this.model);
        }
        return super.add(e);
    }

    @Override
    public void add(int index, Object element) {
        if (element instanceof LayerCollection) {
            ((LayerCollection)element).setModel(this.model);
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Object> c) {
        for (Object object : c) {
            if (!(object instanceof LayerCollection)) continue;
            ((LayerCollection)object).setModel(this.model);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Object> c) {
        for (Object object : c) {
            if (!(object instanceof LayerCollection)) continue;
            ((LayerCollection)object).setModel(this.model);
        }
        return super.addAll(index, c);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public ActiveLayerModel getModel() {
        return this.model;
    }

    public void setModel(ActiveLayerModel model) {
        this.model = model;
        for (Object tmp : this) {
            if (!(tmp instanceof LayerCollection)) continue;
            ((LayerCollection)tmp).setModel(model);
        }
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @Override
    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    @Override
    public float getTranslucency() {
        return this.translucency;
    }

    @Override
    public void setTranslucency(float t) {
        this.translucency = this.translucency;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Element getInitElement() {
        return this.initElement;
    }

    public void setInitElement(Element initElement) {
        this.initElement = initElement;
    }
}

