/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.PNodeProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.ShapeFileFeatureService;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.featureservice.style.StyleDialogClosedEvent;
import de.cismet.cismap.commons.featureservice.style.StyleDialogClosedListener;
import de.cismet.cismap.commons.featureservice.style.StyleDialogStarter;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModelWrapperWithoutProgress;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerTreeCellRenderer;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerEvent;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerListener;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerMenuItem;
import de.cismet.cismap.commons.gui.layerwidget.TreeTransferHandler;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToFeaturesWorker;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.raster.wms.WMSLayer;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.ImageRasterService;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import de.cismet.cismap.commons.retrieval.RepaintEvent;
import de.cismet.cismap.commons.retrieval.RepaintListener;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.veto.VetoException;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ThemeLayerWidget
extends JPanel
implements TreeSelectionListener,
SelectionChangedListener,
GUIWindow {
    private Logger log = Logger.getLogger(ThemeLayerWidget.class);
    private JPopupMenu popupMenu = new JPopupMenu();
    private List<ThemeLayerMenuItem> menuItems = new ArrayList<ThemeLayerMenuItem>();
    private ActiveLayerModel layerModel;
    private DefaultPopupMenuListener popupMenuListener = new DefaultPopupMenuListener(this.popupMenu);
    private TreeTransferHandler transferHandler;
    private List<ThemeLayerListener> themeLayerListener = new ArrayList<ThemeLayerListener>();
    private AddThemeMenuItem addThemeMenuItem;
    private final List<TreePath> expendedPaths = new ArrayList<TreePath>();
    private Timer refreshTimer = new Timer("ThemeTree refresh thread");
    private JScrollPane jScrollPane1;
    private JTree tree;

    public ThemeLayerWidget() {
        this.initComponents();
        SelectionManager manager = SelectionManager.getInstance();
        manager.addSelectionChangedListener(this);
        this.tree.setCellRenderer(new CheckBoxNodeRenderer());
        this.tree.setCellEditor(new CheckBoxNodeEditor());
        this.tree.setEditable(true);
        this.tree.setDragEnabled(true);
        this.tree.setDropMode(DropMode.ON_OR_INSERT);
        this.transferHandler = new TreeTransferHandler();
        this.tree.setTransferHandler(this.transferHandler);
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Object object = ThemeLayerWidget.this.popupMenu.getTreeLock();
                synchronized (object) {
                    for (int i = 0; i < ThemeLayerWidget.this.popupMenu.getComponentCount(); ++i) {
                        TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
                        Component component = ThemeLayerWidget.this.popupMenu.getComponent(i);
                        if (!(component instanceof ThemeLayerMenuItem)) continue;
                        ThemeLayerMenuItem menuItem = (ThemeLayerMenuItem)component;
                        menuItem.refreshText(paths);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (event.getPath().getLastPathComponent().equals(ThemeLayerWidget.this.tree.getModel().getRoot())) {
                    throw new ExpandVetoException(event);
                }
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.saveExpandedPaths();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.saveExpandedPaths();
            }

            private void saveExpandedPaths() {
                ThemeLayerWidget.this.expendedPaths.clear();
                TreePath root = new TreePath(new Object[]{ThemeLayerWidget.this.layerModel.getRoot()});
                Enumeration<TreePath> en = ThemeLayerWidget.this.tree.getExpandedDescendants(root);
                while (en.hasMoreElements()) {
                    ThemeLayerWidget.this.expendedPaths.add(en.nextElement());
                }
            }
        });
        CismapBroker.getInstance().addStatusListener(new StatusListener(){

            @Override
            public void statusValueChanged(StatusEvent e) {
                if (e.getName().equals("scale")) {
                    ThemeLayerWidget.this.repaint();
                }
            }
        });
    }

    public void updateTree() {
        if (this.tree != null) {
            this.tree.repaint();
            this.tree.revalidate();
        }
    }

    public void setMappingModel(ActiveLayerModel mappingModel) {
        this.layerModel = mappingModel;
        ActiveLayerModelWrapperWithoutProgress model = new ActiveLayerModelWrapperWithoutProgress(this.layerModel);
        this.tree.setModel(model);
        model.addTreeToUpdate(this.tree);
        CismapBroker.getInstance().getMappingComponent().addRepaintListener(new RepaintListener(){

            @Override
            public void repaintStart(RepaintEvent e) {
            }

            @Override
            public void repaintComplete(RepaintEvent e) {
                if (e != null && e.getRetrievalEvent() != null && e.getRetrievalEvent().isInitialisationEvent()) {
                    ThemeLayerWidget.this.updateTree();
                }
            }

            @Override
            public void repaintError(RepaintEvent e) {
                if (e != null && e.getRetrievalEvent() != null && e.getRetrievalEvent().isInitialisationEvent()) {
                    ThemeLayerWidget.this.updateTree();
                }
            }
        });
        SelectionManager.getInstance().addSelectionChangedListener(new SelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                ThemeLayerWidget.this.updateTree();
            }
        });
        this.menuItems.add(new AddFolderMenuItem());
        this.menuItems.add(new RemoveGroupMenuItem());
        this.addThemeMenuItem = new AddThemeMenuItem();
        this.menuItems.add(this.addThemeMenuItem);
        this.menuItems.add(new VisibilityMenuItem());
        this.menuItems.add(new InvisibilityMenuItem());
        this.menuItems.add(new AllSelectableMenuItem());
        this.menuItems.add(new AllUnselectableMenuItem());
        this.menuItems.add(new ExpandMenuItem());
        this.menuItems.add(new CollapseMenuItem());
        this.menuItems.add(new RemoveThemeMenuItem());
        this.menuItems.add(new OpenAttributeTableMenuItem());
        this.menuItems.add(new SelectAllMenuItem());
        this.menuItems.add(new InvertSelectionTableMenuItem());
        this.menuItems.add(new ClearSelectionMenuItem());
        this.menuItems.add(new SelectableMenuItem());
        this.menuItems.add(new ZoomToThemeMenuItem());
        this.menuItems.add(new ZoomToSelectedItemsMenuItem());
        this.menuItems.add(new EditModeMenuItem());
        this.menuItems.add(new OptionsMenuItem());
        this.tree.getSelectionModel().addTreeSelectionListener(this);
        this.createPopupMenu();
        this.tree.addMouseListener((MouseListener)this.popupMenuListener);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isPopupTrigger() && e.getClickCount() == 1) {
                    int x = e.getX();
                    int y = e.getY();
                    TreePath tp = ThemeLayerWidget.this.tree.getPathForLocation(x, y);
                    if (tp != null) {
                        int pathCount = tp.getPathCount() - 1;
                        int minX = pathCount * 20;
                        int maxX = minX + 15;
                        if (x >= minX && x <= maxX) {
                            ThemeLayerWidget.this.changeVisibility(tp.getLastPathComponent());
                            ThemeLayerWidget.this.tree.cancelEditing();
                        }
                    }
                }
            }
        });
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                ThemeLayerWidget.this.resetExpansion();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                ThemeLayerWidget.this.resetExpansion();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                ThemeLayerWidget.this.resetExpansion();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                ThemeLayerWidget.this.resetExpansion();
            }
        });
    }

    public List<ThemeLayerMenuItem> getContextMenuItems() {
        return this.menuItems;
    }

    public void addAddThemeMenuItemListener(ActionListener l) {
        this.addThemeMenuItem.addActionListener(l);
    }

    private void createPopupMenu() {
        ArrayList<ServiceLayer> serviceLayerList = new ArrayList<ServiceLayer>();
        boolean node = false;
        boolean folder = false;
        boolean multi = false;
        boolean root = false;
        boolean feature = false;
        boolean rasterService = false;
        boolean geometry = false;
        boolean featureSelected = false;
        int mask = 0;
        TreePath[] paths = this.tree.getSelectionPaths();
        this.popupMenu.removeAll();
        if (paths == null) {
            return;
        }
        if (paths.length > 1) {
            multi = true;
        }
        for (TreePath p : paths) {
            Object o = p.getLastPathComponent();
            if (o instanceof LayerCollection) {
                folder = true;
            } else if (o.equals(this.layerModel.getRoot())) {
                root = true;
            } else {
                node = true;
            }
            if (o instanceof ServiceLayer) {
                serviceLayerList.add((ServiceLayer)o);
            }
            if (o instanceof AbstractFeatureService) {
                List<Feature> featuresForService;
                feature = true;
                if (!featureSelected && (featuresForService = SelectionManager.getInstance().getSelectedFeatures((AbstractFeatureService)o)) != null && !featuresForService.isEmpty()) {
                    featureSelected = true;
                }
            }
            if (o instanceof RetrievalServiceLayer && !geometry) {
                RetrievalServiceLayer rsl = (RetrievalServiceLayer)o;
                Geometry bounds = null;
                try {
                    bounds = ZoomToLayerWorker.getServiceBounds(rsl);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (bounds != null && !bounds.isEmpty()) {
                    geometry = true;
                }
            }
            if (!(o instanceof RasterMapService)) continue;
            rasterService = true;
        }
        mask += root ? 1 : 0;
        mask += folder ? 4 : 0;
        mask += node ? 2 : 0;
        mask += multi ? 8 : 0;
        mask += feature ? 16 : 0;
        mask += rasterService ? 512 : 0;
        mask += geometry ? 32 : 0;
        mask += featureSelected ? 64 : 0;
        mask += !geometry ? 128 : 0;
        mask += !featureSelected ? 256 : 0;
        for (ThemeLayerMenuItem item : this.menuItems) {
            if (!item.isVisible(mask) || !item.isVisible(serviceLayerList)) continue;
            if (item.isNewSection()) {
                this.popupMenu.addSeparator();
            }
            this.popupMenu.add(item);
            item.setEnabled(item.isSelectable(mask) && item.isSelectable(serviceLayerList));
            item.refreshText(paths);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.createPopupMenu();
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.tree.getSelectionModel().addTreeSelectionListener(l);
    }

    public void removeTreeSelectionListener(TreeSelectionListener l) {
        this.tree.getSelectionModel().removeTreeSelectionListener(l);
    }

    public TreePath[] getSelectionPath() {
        return this.tree.getSelectionPaths();
    }

    public TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    public void insertMenuItemIntoContextMenu(int index, ThemeLayerMenuItem menuItem) {
        this.menuItems.add(index, menuItem);
    }

    private void changeVisibility(Object objectToChange) {
        if (objectToChange.equals(this.layerModel.getRoot())) {
            for (int i = 0; i < this.layerModel.getChildCount(this.layerModel.getRoot()); ++i) {
                this.changeVisibility(this.layerModel.getChild(this.layerModel.getRoot(), i));
            }
        } else if (objectToChange instanceof LayerCollection) {
            LayerCollection lc = (LayerCollection)objectToChange;
            boolean visibility = !lc.isEnabled();
            this.changeVisibility(lc, visibility);
        } else if (objectToChange instanceof ServiceLayer) {
            ServiceLayer sl = (ServiceLayer)objectToChange;
            boolean visibility = !sl.isEnabled();
            this.changeVisibility(sl, visibility);
        }
        this.updateUI();
    }

    private void changeVisibility(Object objectToChange, boolean visible) {
        if (objectToChange instanceof LayerCollection) {
            LayerCollection lc = (LayerCollection)objectToChange;
            for (int i = 0; i < lc.size(); ++i) {
                this.changeVisibility(lc.get(i), visible);
            }
        } else if (objectToChange instanceof ServiceLayer) {
            PNodeProvider pr;
            boolean changeVisibility = false;
            boolean statusChanged = false;
            ServiceLayer sl = (ServiceLayer)objectToChange;
            if (sl.isEnabled() != visible) {
                sl.setEnabled(visible);
                statusChanged = true;
            }
            if (objectToChange instanceof PNodeProvider && (pr = (PNodeProvider)objectToChange).getPNode() != null && pr.getPNode().getVisible() != visible) {
                if (!visible) {
                    for (int i = 0; i < pr.getPNode().getChildrenCount(); ++i) {
                        PNode node = pr.getPNode().getChild(i);
                        if (!(node instanceof PFeature)) continue;
                        ((PFeature)node).releaseResources();
                    }
                    pr.getPNode().removeAllChildren();
                }
                changeVisibility = true;
            }
            if (changeVisibility) {
                TreePath tp = new TreePath(new Object[]{this.layerModel.getRoot(), objectToChange});
                this.layerModel.handleVisibility(tp);
                statusChanged = true;
            }
            if (visible && statusChanged && objectToChange instanceof MapService) {
                ((MapService)objectToChange).setBoundingBox(CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera());
                ((RetrievalServiceLayer)objectToChange).retrieve(true);
                if (((RetrievalServiceLayer)objectToChange).isEnabled() != visible) {
                    ((RetrievalServiceLayer)objectToChange).setEnabled(visible);
                    if (objectToChange instanceof AbstractWMS) {
                        ((AbstractWMS)objectToChange).setVisible(visible);
                    }
                }
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new TreeWithoutNPEAfterDrop();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.tree);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        this.refreshTimer.cancel();
        this.refreshTimer = new Timer();
        this.refreshTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeLayerWidget.this.createPopupMenu();
                        ThemeLayerWidget.this.tree.updateUI();
                    }
                });
            }
        }, 100L);
    }

    private void resetExpansion() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<TreePath> pathCopy = new ArrayList<TreePath>(ThemeLayerWidget.this.expendedPaths);
                if (pathCopy.isEmpty()) {
                    TreePath root = new TreePath(new Object[]{ThemeLayerWidget.this.layerModel.getRoot()});
                    pathCopy.add(root);
                }
                for (TreePath tp : pathCopy) {
                    ThemeLayerWidget.this.tree.expandPath(tp);
                }
            }
        });
    }

    public void addThemeLayerListener(ThemeLayerListener l) {
        this.themeLayerListener.add(l);
    }

    public void removeThemeLayerListener(ThemeLayerListener l) {
        this.themeLayerListener.remove(l);
    }

    private void fireRemoveLayerEvent(ThemeLayerEvent e) throws VetoException {
        for (ThemeLayerListener l : this.themeLayerListener) {
            l.removeLayer(e);
        }
    }

    private void removePath(TreePath path) throws VetoException {
        try {
            if (path.getLastPathComponent() instanceof MapService) {
                ThemeLayerEvent event = new ThemeLayerEvent((MapService)path.getLastPathComponent(), this);
                this.fireRemoveLayerEvent(event);
            }
            this.layerModel.removeLayer(path);
            for (TreePath tp : new ArrayList<TreePath>(this.expendedPaths)) {
                this.tree.expandPath(tp);
            }
        }
        catch (VetoException vetoException) {
            // empty catch block
        }
    }

    public String getViewTitle() {
        return NbBundle.getMessage(ThemeLayerWidget.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vThemeLayer.title");
    }

    public Icon getViewIcon() {
        return Static2DTools.borderIcon((Icon)new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/map.png")), (int)0, (int)3, (int)0, (int)1);
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    private class TreeWithoutNPEAfterDrop
    extends JTree {
        private TreeWithoutNPEAfterDrop() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (newValue != null || !propertyName.equals("dropLocation")) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }
    }

    class CheckBoxNodeEditor
    extends CheckBoxNodeRenderer
    implements TreeCellEditor {
        private Object value;
        private MouseAdapter lastAdapter;
        private JTextField treeEditorTextField;
        private List<CellEditorListener> listener;

        public CheckBoxNodeEditor() {
            this.lastAdapter = null;
            this.listener = new ArrayList<CellEditorListener>();
        }

        @Override
        public Component getTreeCellRendererComponent(final JTree tree, final Object value, boolean selected, boolean expanded, boolean leaf, final int row, boolean hasFocus) {
            final JPanel pan = (JPanel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!(pan.getComponent(0) instanceof JCheckBox)) {
                return pan;
            }
            final JCheckBox leafRenderer = (JCheckBox)pan.getComponent(0);
            final Component ret = pan.getComponent(1);
            if (this.lastAdapter != null) {
                ret.removeMouseListener(this.lastAdapter);
            }
            this.treeEditorTextField = null;
            this.lastAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ThemeLayerWidget.this.createPopupMenu();
                    ThemeLayerWidget.this.popupMenuListener.mousePressed(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ThemeLayerWidget.this.createPopupMenu();
                    ThemeLayerWidget.this.popupMenuListener.mouseReleased(e);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.isPopupTrigger() || e.getButton() != 1) {
                        ThemeLayerWidget.this.createPopupMenu();
                        ThemeLayerWidget.this.popupMenuListener.mouseClicked(e);
                        return;
                    }
                    if (ret instanceof JLabel) {
                        String text = value.toString();
                        ((JLabel)ret).setText("");
                        CheckBoxNodeEditor.this.treeEditorTextField = new JTextField(text);
                        CheckBoxNodeEditor.this.treeEditorTextField.addKeyListener(new KeyAdapter(){

                            @Override
                            public void keyTyped(KeyEvent e) {
                                if (e.getKeyChar() == '\n') {
                                    tree.stopEditing();
                                    tree.startEditingAtPath(tree.getPathForRow(row));
                                    tree.stopEditing();
                                }
                            }
                        });
                        CheckBoxNodeEditor.this.treeEditorTextField.setPreferredSize(((JLabel)ret).getPreferredSize());
                        CheckBoxNodeEditor.this.treeEditorTextField.setMinimumSize(((JLabel)ret).getMinimumSize());
                        CheckBoxNodeEditor.this.treeEditorTextField.setMaximumSize(((JLabel)ret).getMaximumSize());
                        CheckBoxNodeEditor.this.treeEditorTextField.setEditable(true);
                        ((JLabel)ret).setMinimumSize(null);
                        ((JLabel)ret).setMaximumSize(null);
                        ((JLabel)ret).setPreferredSize(null);
                        pan.add((Component)CheckBoxNodeEditor.this.treeEditorTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
                        CheckBoxNodeEditor.this.treeEditorTextField.setSelectionStart(0);
                        CheckBoxNodeEditor.this.treeEditorTextField.setSelectionEnd(CheckBoxNodeEditor.this.treeEditorTextField.getText().length());
                        CheckBoxNodeEditor.this.treeEditorTextField.setFocusable(true);
                        CheckBoxNodeEditor.this.treeEditorTextField.requestFocusInWindow();
                        pan.repaint();
                        pan.updateUI();
                    }
                }
            };
            ret.addMouseListener(this.lastAdapter);
            leafRenderer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThemeLayerWidget.this.changeVisibility(value);
                }
            });
            leafRenderer.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!leafRenderer.isEnabled()) {
                        leafRenderer.setSelected(!leafRenderer.isSelected());
                        ThemeLayerWidget.this.changeVisibility(value);
                    }
                }
            });
            return pan;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.value = value;
            return this.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.treeEditorTextField != null) {
                return this.treeEditorTextField.getText();
            }
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            this.setNewName(this.getCellEditorValue().toString());
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listener.add(l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listener.remove(l);
        }

        private void setNewName(String name) {
            if (this.value instanceof ServiceLayer) {
                ServiceLayer layer = (ServiceLayer)this.value;
                layer.setName(name);
            } else if (this.value instanceof LayerCollection) {
                LayerCollection layer = (LayerCollection)this.value;
                layer.setName(name);
            }
        }
    }

    class CheckBoxNodeRenderer
    extends ActiveLayerTreeCellRenderer {
        protected Color selectionBorderColor;
        protected Color selectionForeground;
        protected Color selectionBackground;
        protected Color textForeground;
        protected Color textBackground;
        protected Boolean drawsFocusBorderAroundIcon;
        protected Font fontValue = UIManager.getFont("Tree.font");

        public CheckBoxNodeRenderer() {
            this.drawsFocusBorderAroundIcon = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
            this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel lab = null;
            Object object = ThemeLayerWidget.this.getTreeLock();
            synchronized (object) {
                AbstractFeatureService service;
                String label = "<html>";
                boolean modifiable = false;
                if (value instanceof AbstractFeatureService && SelectionManager.getInstance().getEditableServices().contains((AbstractFeatureService)value)) {
                    modifiable = true;
                }
                label = modifiable ? label + "<span color=\"#FF0000\">" + value.toString() + "</span>" : (value.equals(ThemeLayerWidget.this.layerModel.getRoot()) ? label + NbBundle.getMessage(CheckBoxNodeRenderer.class, (String)"ThemeLayerWidget.CheckBoxNodeRenderer.getTreeCellRendererComponent.root") : label + value.toString());
                AbstractFeatureService abstractFeatureService = service = value instanceof AbstractFeatureService ? (AbstractFeatureService)value : null;
                if (service != null) {
                    Integer modifiableFeatureCount;
                    Integer selectedFeatureCount = SelectionManager.getInstance().getSelectedFeaturesCount(service);
                    if (ThemeLayerWidget.this.log.isDebugEnabled()) {
                        ThemeLayerWidget.this.log.debug((Object)("selection " + String.valueOf(service) + " Anzahl: " + selectedFeatureCount));
                    }
                    if (selectedFeatureCount != null && selectedFeatureCount != 0) {
                        label = label + " | " + selectedFeatureCount;
                    }
                    if ((modifiableFeatureCount = SelectionManager.getInstance().getModifiableFeaturesCount(service)) != null) {
                        label = label + " | <span color=\"#FF0000\">" + modifiableFeatureCount + "</span>";
                    }
                }
                label = label + "</html>";
                Component ret = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                JLabel retLab = (JLabel)ret;
                lab = new JLabel(label, retLab.getIcon(), retLab.getHorizontalAlignment());
                if (value instanceof LayerCollection) {
                    if (expanded) {
                        lab.setIcon(this.openIcon);
                    } else {
                        lab.setIcon(this.closedIcon);
                    }
                }
            }
            JPanel pan = new JPanel();
            JCheckBox leafRenderer = new JCheckBox();
            pan.setLayout(new GridBagLayout());
            if (value instanceof AbstractFeatureService && ((AbstractFeatureService)value).isSelectable()) {
                Font boldFont = lab.getFont().deriveFont(1);
                lab.setFont(boldFont);
            }
            if (this.fontValue != null) {
                leafRenderer.setFont(this.fontValue);
            }
            leafRenderer.setFocusPainted(this.drawsFocusBorderAroundIcon != null && this.drawsFocusBorderAroundIcon != false);
            leafRenderer.setEnabled(tree.isEnabled());
            if (selected) {
                leafRenderer.setForeground(this.selectionForeground);
                leafRenderer.setBackground(this.selectionBackground);
                pan.setForeground(this.selectionForeground);
                pan.setBackground(this.selectionBackground);
            } else {
                leafRenderer.setForeground(this.textForeground);
                leafRenderer.setBackground(this.textBackground);
                pan.setForeground(this.textForeground);
                pan.setBackground(this.textBackground);
            }
            if (value instanceof AbstractFeatureService) {
                XBoundingBox currentBBox;
                BoundingBox box = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
                if (box instanceof XBoundingBox && !((AbstractFeatureService)value).isVisibleInBoundingBox(currentBBox = (XBoundingBox)box)) {
                    leafRenderer.setEnabled(false);
                }
            } else if (value instanceof WMSServiceLayer) {
                double scale;
                WMSServiceLayer serviceLayer = (WMSServiceLayer)value;
                double min = Double.MIN_VALUE;
                double max = Double.MAX_VALUE;
                Layer tmpLayer = null;
                if (((WMSServiceLayer)value).getWMSLayers().size() == 1 && (tmpLayer = ((WMSLayer)((WMSServiceLayer)value).getWMSLayers().get(0)).getOgcCapabilitiesLayer()) != null) {
                    min = tmpLayer.getScaleDenominationMin();
                    max = tmpLayer.getScaleDenominationMax();
                }
                if (tmpLayer == null && serviceLayer.getWmsCapabilities() != null && serviceLayer.getWmsCapabilities().getLayer() != null) {
                    min = serviceLayer.getWmsCapabilities().getLayer().getScaleDenominationMin();
                    max = serviceLayer.getWmsCapabilities().getLayer().getScaleDenominationMax();
                }
                if ((scale = CismapBroker.getInstance().getMappingComponent().getCurrentOGCScale()) < min || scale > max) {
                    leafRenderer.setEnabled(false);
                }
            }
            if (value instanceof ShapeFileFeatureService && ((ShapeFileFeatureService)value).isFileNotFound()) {
                lab.setForeground(Color.GRAY);
            } else if (value instanceof H2FeatureService && ((H2FeatureService)value).isTableNotFound()) {
                lab.setForeground(Color.GRAY);
            } else if (value instanceof ImageRasterService && ((ImageRasterService)value).getImageFile() != null && !((ImageRasterService)value).getImageFile().exists()) {
                lab.setForeground(Color.GRAY);
            }
            leafRenderer.setSelected(this.isValueSelected(value));
            if (!(value instanceof WMSLayer) && !value.equals(ThemeLayerWidget.this.layerModel.getRoot())) {
                pan.add(leafRenderer);
            }
            pan.add(lab);
            pan.doLayout();
            pan.repaint();
            return pan;
        }

        protected boolean isValueSelected(Object value) {
            if (value instanceof ServiceLayer) {
                ServiceLayer layer = (ServiceLayer)value;
                return layer.isEnabled();
            }
            if (value instanceof LayerCollection) {
                LayerCollection layer = (LayerCollection)value;
                return layer.isEnabled();
            }
            if (value.equals(ThemeLayerWidget.this.layerModel.getRoot())) {
                boolean enabled = true;
                for (int i = 0; i < ThemeLayerWidget.this.layerModel.getChildCount(ThemeLayerWidget.this.layerModel.getRoot()); ++i) {
                    Object tmpLayer = ThemeLayerWidget.this.layerModel.getChild(ThemeLayerWidget.this.layerModel.getRoot(), i);
                    if (tmpLayer instanceof LayerCollection) {
                        if (((LayerCollection)tmpLayer).isEnabled()) continue;
                        enabled = false;
                        continue;
                    }
                    if (!(tmpLayer instanceof ServiceLayer) || ((ServiceLayer)tmpLayer).isEnabled()) continue;
                    enabled = false;
                }
                return enabled;
            }
            return false;
        }
    }

    private class SelectableMenuItem
    extends ThemeLayerMenuItem {
        public SelectableMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.SelectionMenuItem.pmenuItem.text"), 506);
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths;
            for (TreePath path : paths = ThemeLayerWidget.this.tree.getSelectionPaths()) {
                AbstractFeatureService service;
                if (!(path.getLastPathComponent() instanceof AbstractFeatureService)) continue;
                service.setSelectable(!(service = (AbstractFeatureService)path.getLastPathComponent()).isSelectable());
                ThemeLayerWidget.this.tree.updateUI();
            }
            this.refreshText(paths);
        }

        @Override
        public void refreshText(TreePath[] paths) {
            boolean isSelected = true;
            for (TreePath tp : paths) {
                if (!(tp.getLastPathComponent() instanceof AbstractFeatureService) || ((AbstractFeatureService)tp.getLastPathComponent()).isSelectable()) continue;
                isSelected = false;
            }
            if (!isSelected) {
                this.setText(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.SelectionMenuItem.pmenuItem.text"));
            } else {
                this.setText(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.NotSelectionMenuItem.pmenuItem.text"));
            }
        }
    }

    private class OptionsMenuItem
    extends ThemeLayerMenuItem {
        public OptionsMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.OptionsMenuItem.pmenuItem.text"), 498);
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = ThemeLayerWidget.this.tree.getSelectionPath();
            AbstractFeatureService selectedService = (AbstractFeatureService)path.getLastPathComponent();
            Frame parentFrame = StaticSwingTools.getParentFrame((Component)ThemeLayerWidget.this);
            ArrayList<String> args = new ArrayList<String>();
            args.add("Allgemein");
            args.add("Darstellung");
            args.add("Massstab");
            args.add("Thematische Farbgebung");
            args.add("Beschriftung");
            args.add("TextEditor");
            args.add("QueryPanel");
            StyleDialogStarter starter = new StyleDialogStarter(parentFrame, selectedService, args, 500);
            starter.addStyleDialogClosedListener(new StyleDialogClosedListener(){

                @Override
                public void StyleDialogClosed(StyleDialogClosedEvent evt) {
                    ThemeLayerWidget.this.tree.updateUI();
                }
            });
            starter.start();
        }
    }

    private class ClearSelectionMenuItem
    extends ThemeLayerMenuItem {
        public ClearSelectionMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.ClearSelectionMenuItem.pmenuItem.text"), 506, 250);
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths;
            for (TreePath path : paths = ThemeLayerWidget.this.tree.getSelectionPaths()) {
                if (!(path.getLastPathComponent() instanceof AbstractFeatureService)) continue;
                AbstractFeatureService service = (AbstractFeatureService)path.getLastPathComponent();
                List<Feature> toBeUnselected = SelectionManager.getInstance().getSelectedFeatures(service);
                SelectionManager.getInstance().removeSelectedFeatures(toBeUnselected);
            }
        }
    }

    private class InvertSelectionTableMenuItem
    extends ThemeLayerMenuItem {
        public InvertSelectionTableMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.InvertSelectionTableMenuItem.pmenuItem.text"), 506);
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            WaitingDialogThread<List[]> wdt = new WaitingDialogThread<List[]>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(SelectAllMenuItem.class, (String)"ThemeLayerWidget.InvertSelectionTableMenuItem.actionPerformed.text"), null, 500, true){

                protected List[] doInBackground() throws Exception {
                    Thread.currentThread().setName("ThemeLayerWidget_invert_selection");
                    ArrayList toBeSelected = new ArrayList();
                    ArrayList<Feature> toBeUnselected = new ArrayList<Feature>();
                    List[] featureLists = new List[2];
                    for (TreePath path : paths) {
                        if (path.getLastPathComponent() instanceof AbstractFeatureService) {
                            AbstractFeatureService service = (AbstractFeatureService)path.getLastPathComponent();
                            BoundingBox bb = null;
                            service.initAndWait();
                            FeatureFactory factory = service.getFeatureFactory();
                            int pageSize = service.getMaxFeaturesPerPage();
                            List featureList = pageSize != -1 ? factory.createFeatures(service.getQuery(), bb, null, 0, pageSize, null) : factory.createFeatures(service.getQuery(), bb, null, 0, 0, null);
                            toBeSelected.addAll(featureList);
                            List<Feature> selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(service);
                            toBeSelected.removeAll(selectedFeatures);
                            toBeUnselected.addAll(selectedFeatures);
                        }
                        if (!Thread.interrupted() && !this.canceled) continue;
                        return null;
                    }
                    featureLists[0] = toBeUnselected;
                    featureLists[1] = toBeSelected;
                    return featureLists;
                }

                protected void done() {
                    try {
                        List[] features = (List[])this.get();
                        SelectionManager.getInstance().removeSelectedFeatures(features[0]);
                        SelectionManager.getInstance().addSelectedFeatures(features[1]);
                    }
                    catch (Exception e) {
                        ThemeLayerWidget.this.log.error((Object)"Error while selecting all features", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }

    private class SelectAllMenuItem
    extends ThemeLayerMenuItem {
        public SelectAllMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.SelectAllMenuItem.pmenuItem.text"), 506);
            this.newSection = true;
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            WaitingDialogThread<List<FeatureServiceFeature>> wdt = new WaitingDialogThread<List<FeatureServiceFeature>>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(SelectAllMenuItem.class, (String)"ThemeLayerWidget.SelectAllMenuItem.actionPerformed.text"), null, 500, true){

                /*
                 * Enabled aggressive block sorting
                 */
                protected List<FeatureServiceFeature> doInBackground() throws Exception {
                    Thread.currentThread().setName("ThemeLayerWidget_select_all");
                    ArrayList<FeatureServiceFeature> toBeSelected = new ArrayList<FeatureServiceFeature>();
                    TreePath[] treePathArray = paths;
                    int n = treePathArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath path = treePathArray[n2];
                        if (path.getLastPathComponent() instanceof AbstractFeatureService) {
                            List featureList;
                            AbstractFeatureService service = (AbstractFeatureService)path.getLastPathComponent();
                            BoundingBox bb = null;
                            service.initAndWait();
                            FeatureFactory factory = service.getFeatureFactory();
                            int pageSize = service.getMaxFeaturesPerPage();
                            if (pageSize != -1) {
                                final AttributeTable table = SelectionManager.getInstance().getAttributeTableForService(service);
                                if (table != null) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            table.selectAll();
                                        }
                                    });
                                    return null;
                                }
                                featureList = factory.createFeatures(service.getQuery(), bb, null, 0, pageSize, null);
                            } else {
                                featureList = factory.createFeatures(service.getQuery(), bb, null, 0, 0, null);
                            }
                            toBeSelected.addAll(featureList);
                        }
                        if (Thread.interrupted() || this.canceled) {
                            return null;
                        }
                        ++n2;
                    }
                    return toBeSelected;
                }

                protected void done() {
                    try {
                        List features = (List)this.get();
                        if (features != null) {
                            SelectionManager.getInstance().addSelectedFeatures(features);
                        }
                    }
                    catch (Exception e) {
                        ThemeLayerWidget.this.log.error((Object)"Error while selecting all features", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }

    private class EditModeMenuItem
    extends ThemeLayerMenuItem {
        public EditModeMenuItem() {
            super(NbBundle.getMessage(EditModeMenuItem.class, (String)"ThemeLayerWidget.EditModeMenuItem.pmenuItem.text"), 506);
            this.newSection = true;
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public boolean isSelectable(int mask) {
            TreePath[] paths;
            for (TreePath path : paths = ThemeLayerWidget.this.tree.getSelectionPaths()) {
                if (!(path.getLastPathComponent() instanceof AbstractFeatureService) || ((AbstractFeatureService)path.getLastPathComponent()).isEditable()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths;
            for (TreePath path : paths = ThemeLayerWidget.this.tree.getSelectionPaths()) {
                if (!(path.getLastPathComponent() instanceof AbstractFeatureService)) continue;
                AbstractFeatureService service = (AbstractFeatureService)path.getLastPathComponent();
                AttributeTableFactory.getInstance().switchProcessingMode(service);
            }
            this.refreshText(paths);
        }

        @Override
        public void refreshText(TreePath[] paths) {
            boolean isInProcessingMode = true;
            for (TreePath tp : paths) {
                if (!(tp.getLastPathComponent() instanceof AbstractFeatureService)) continue;
                AbstractFeatureService service = (AbstractFeatureService)tp.getLastPathComponent();
                if (SelectionManager.getInstance().getEditableServices().contains(service)) continue;
                isInProcessingMode = false;
            }
            if (!isInProcessingMode) {
                this.setText(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.EditModeMenuItem.pmenuItem.text"));
            } else {
                this.setText(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.NoEditModeMenuItem.pmenuItem.text"));
            }
        }
    }

    private class OpenAttributeTableMenuItem
    extends ThemeLayerMenuItem {
        public OpenAttributeTableMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.OpenAttributeTableMenuItem.pmenuItem.text"), 506);
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths;
            for (TreePath path : paths = ThemeLayerWidget.this.tree.getSelectionPaths()) {
                if (!(path.getLastPathComponent() instanceof AbstractFeatureService)) continue;
                AbstractFeatureService service = (AbstractFeatureService)path.getLastPathComponent();
                AttributeTableFactory.getInstance().showAttributeTable(service);
            }
        }
    }

    private class ZoomToThemeMenuItem
    extends ThemeLayerMenuItem {
        public ZoomToThemeMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.ZoomToThemeMenuItem.pmenuItem.text"), 890);
            this.newSection = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] tps = ThemeLayerWidget.this.tree.getSelectionPaths();
            ZoomToLayerWorker worker = new ZoomToLayerWorker(tps, 10);
            worker.execute();
        }
    }

    private class ZoomToSelectedItemsMenuItem
    extends ThemeLayerMenuItem {
        public ZoomToSelectedItemsMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.ZoomToSelectedItemsMenuItem.pmenuItem.text"), 378, 122);
        }

        @Override
        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            ArrayList<Feature> features = new ArrayList<Feature>();
            for (TreePath o : paths) {
                AbstractFeatureService afs = (AbstractFeatureService)o.getLastPathComponent();
                List<Feature> featuresForService = SelectionManager.getInstance().getSelectedFeatures(afs);
                if (featuresForService == null) continue;
                features.addAll(featuresForService);
            }
            ZoomToFeaturesWorker worker = new ZoomToFeaturesWorker(features.toArray(new Feature[features.size()]), 10);
            worker.execute();
        }
    }

    private class RemoveThemeMenuItem
    extends ThemeLayerMenuItem {
        public RemoveThemeMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.RemoveThemeMenuItem.pmenuItem.text"), 1018);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            ThemeLayerWidget.this.tree.setSelectionPath(null);
            WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(SelectAllMenuItem.class, (String)"ThemeLayerWidget.RemoveThemeMenuItem.actionPerformed.text"), null, 500, true){

                protected Void doInBackground() throws Exception {
                    Thread.currentThread().setName("ThemeLayerWidget_remove_theme");
                    int progress = 0;
                    this.wd.setMax(paths.length);
                    for (final TreePath tmpPath : paths) {
                        this.wd.setProgress(++progress);
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ThemeLayerWidget.this.removePath(tmpPath);
                                }
                                catch (VetoException vetoException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    return null;
                }

                protected void done() {
                    try {
                        this.get();
                    }
                    catch (Exception e) {
                        ThemeLayerWidget.this.log.error((Object)"Error while removing layer from tree", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }

    private class RemoveGroupMenuItem
    extends ThemeLayerMenuItem {
        public RemoveGroupMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.RemoveGroupMenuItem.pmenuItem.text"), 484);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            if (paths.length == 1) {
                ThemeLayerWidget.this.tree.setSelectionPath(null);
                try {
                    this.removeGroupLayerContent(paths[0]);
                    ThemeLayerWidget.this.layerModel.removeLayer(paths[0]);
                }
                catch (VetoException vetoException) {
                    // empty catch block
                }
            }
        }

        private void removeGroupLayerContent(TreePath path) throws VetoException {
            if (path.getLastPathComponent() instanceof LayerCollection) {
                LayerCollection lc = (LayerCollection)path.getLastPathComponent();
                ArrayList<Object> children = new ArrayList<Object>(lc);
                for (Object e : children) {
                    if (e instanceof LayerCollection) {
                        this.removeGroupLayerContent(path.pathByAddingChild(e));
                        continue;
                    }
                    ThemeLayerWidget.this.removePath(path.pathByAddingChild(e));
                }
            }
        }
    }

    private class CollapseMenuItem
    extends ThemeLayerMenuItem {
        public CollapseMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.CollapseMenuItem.pmenuItem.text"), 485);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = ThemeLayerWidget.this.tree.getRowCount() - 1;
            while (row > 0) {
                ThemeLayerWidget.this.tree.collapseRow(row--);
            }
        }
    }

    private class AddThemeMenuItem
    extends ThemeLayerMenuItem {
        public AddThemeMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.AddThemeMenuItem.pmenuItem.text"), 485);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ExpandMenuItem
    extends ThemeLayerMenuItem {
        public ExpandMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.EntensionMenuItem.pmenuItem.text"), 485);
            this.newSection = true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.expandAll(new TreePath(ThemeLayerWidget.this.layerModel.getRoot()));
        }

        private void expandAll(TreePath parent) {
            Object lastComponent = parent.getLastPathComponent();
            ThemeLayerWidget.this.tree.expandPath(parent);
            for (int i = 0; i < ThemeLayerWidget.this.layerModel.getChildCount(lastComponent); ++i) {
                TreePath newPath = parent.pathByAddingChild(ThemeLayerWidget.this.layerModel.getChild(lastComponent, i));
                this.expandAll(newPath);
            }
        }
    }

    private class AllUnselectableMenuItem
    extends AllSelectableMenuItem {
        public AllUnselectableMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.AllUnselectableMenuItem.pmenuItem.text"), 485, false);
        }
    }

    private class AllSelectableMenuItem
    extends ThemeLayerMenuItem {
        protected boolean shouldBeEnabled;

        public AllSelectableMenuItem() {
            this(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.AllSelectableMenuItem.pmenuItem.text"), 485, true);
            this.newSection = true;
        }

        protected AllSelectableMenuItem(String title, int visibility, boolean shouldBeEnabled) {
            super(title, visibility);
            this.shouldBeEnabled = true;
            this.shouldBeEnabled = shouldBeEnabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            this.changeSelectability(paths);
        }

        private void changeSelectability(TreePath[] paths) {
            for (TreePath path : paths) {
                ServiceLayer layer;
                Object selectedComponent = path.getLastPathComponent();
                if (selectedComponent instanceof AbstractFeatureService) {
                    layer = (AbstractFeatureService)selectedComponent;
                    layer.setSelectable(this.shouldBeEnabled);
                    continue;
                }
                if (selectedComponent instanceof LayerCollection) {
                    layer = (LayerCollection)selectedComponent;
                    this.makeSelectable((LayerCollection)layer);
                    continue;
                }
                if (!selectedComponent.equals(ThemeLayerWidget.this.layerModel.getRoot())) continue;
                ArrayList<TreePath> tp = new ArrayList<TreePath>();
                TreePath rootPath = new TreePath(ThemeLayerWidget.this.layerModel.getRoot());
                for (int i = 0; i < ThemeLayerWidget.this.layerModel.getChildCount(ThemeLayerWidget.this.layerModel.getRoot()); ++i) {
                    tp.add(rootPath.pathByAddingChild(ThemeLayerWidget.this.layerModel.getChild(ThemeLayerWidget.this.layerModel.getRoot(), i)));
                }
                this.changeSelectability(tp.toArray(new TreePath[tp.size()]));
            }
            ThemeLayerWidget.this.tree.updateUI();
        }

        private void makeSelectable(LayerCollection lc) {
            for (Object layer : lc) {
                if (layer instanceof AbstractFeatureService) {
                    ((AbstractFeatureService)layer).setSelectable(this.shouldBeEnabled);
                    continue;
                }
                if (!(layer instanceof LayerCollection)) continue;
                this.makeSelectable((LayerCollection)layer);
            }
        }
    }

    private class InvisibilityMenuItem
    extends VisibilityMenuItem {
        public InvisibilityMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.InvisibilityMenuItem.pmenuItem.text"), 485, false);
        }
    }

    private class VisibilityMenuItem
    extends ThemeLayerMenuItem {
        protected boolean shouldBeEnabled;

        public VisibilityMenuItem() {
            this(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.VisibilityMenuItem.pmenuItem.text"), 485, true);
            this.newSection = true;
        }

        protected VisibilityMenuItem(String title, int visibility, boolean shouldBeEnabled) {
            super(title, visibility);
            this.shouldBeEnabled = true;
            this.shouldBeEnabled = shouldBeEnabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            this.changeVisibilityForPath(paths);
        }

        private void changeVisibilityForPath(TreePath[] paths) {
            for (TreePath path : paths) {
                ServiceLayer layer;
                Object selectedComponent = path.getLastPathComponent();
                if (selectedComponent instanceof ServiceLayer) {
                    layer = (ServiceLayer)selectedComponent;
                    if (layer.isEnabled() != this.shouldBeEnabled) {
                        layer.setEnabled(this.shouldBeEnabled);
                    }
                    if (ThemeLayerWidget.this.layerModel.isVisible(path) == this.shouldBeEnabled) continue;
                    ThemeLayerWidget.this.changeVisibility(selectedComponent, this.shouldBeEnabled);
                    continue;
                }
                if (selectedComponent instanceof LayerCollection) {
                    layer = (LayerCollection)selectedComponent;
                    if (((LayerCollection)layer).isEnabled() == this.shouldBeEnabled) continue;
                    ThemeLayerWidget.this.changeVisibility(selectedComponent, this.shouldBeEnabled);
                    continue;
                }
                if (!selectedComponent.equals(ThemeLayerWidget.this.layerModel.getRoot())) continue;
                ArrayList<TreePath> tp = new ArrayList<TreePath>();
                TreePath rootPath = new TreePath(ThemeLayerWidget.this.layerModel.getRoot());
                for (int i = 0; i < ThemeLayerWidget.this.layerModel.getChildCount(ThemeLayerWidget.this.layerModel.getRoot()); ++i) {
                    tp.add(rootPath.pathByAddingChild(ThemeLayerWidget.this.layerModel.getChild(ThemeLayerWidget.this.layerModel.getRoot(), i)));
                }
                this.changeVisibilityForPath(tp.toArray(new TreePath[tp.size()]));
            }
        }
    }

    private class AddFolderMenuItem
    extends ThemeLayerMenuItem {
        public AddFolderMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.addPopupMenu().pmenuItem.text"), 485);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = ThemeLayerWidget.this.tree.getSelectionPaths();
            if (paths.length == 1) {
                Object selectedComponent = paths[0].getLastPathComponent();
                if (selectedComponent instanceof LayerCollection) {
                    LayerCollection newLayer = new LayerCollection();
                    ThemeLayerWidget.this.layerModel.addEmptyLayerCollection(paths[0], newLayer);
                } else if (selectedComponent.equals(ThemeLayerWidget.this.layerModel.getRoot())) {
                    ThemeLayerWidget.this.layerModel.addEmptyLayerCollection(new LayerCollection());
                }
            }
        }
    }
}

