/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.layerwidget;

import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModelWrapperWithoutProgress;
import de.cismet.cismap.commons.gui.layerwidget.LayerCollection;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.rasterservice.MapService;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TreeTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(TreeTransferHandler.class);
    private DataFlavor nodesFlavor;
    private DataFlavor[] flavors = new DataFlavor[1];
    private List<TreePath> nodesToRemove;

    public TreeTransferHandler() {
        try {
            String mimeType = "application/x-java-jvm-local-objectref;class=\"" + TreePath[].class.getName() + "\"";
            this.flavors[0] = this.nodesFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException e) {
            System.out.println("ClassNotFound: " + e.getMessage());
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        Object targetNode;
        if (!support.isDrop()) {
            return false;
        }
        support.setShowDropLocation(true);
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        JTree tree = (JTree)support.getComponent();
        int dropRow = tree.getRowForPath(dl.getPath());
        Object object = targetNode = dl.getPath() != null ? dl.getPath().getLastPathComponent() : null;
        if (targetNode != null && !(targetNode instanceof LayerCollection) && !targetNode.equals("Layer")) {
            return false;
        }
        if (!support.isDataFlavorSupported(this.nodesFlavor)) {
            return true;
        }
        int[] selRows = tree.getSelectionRows();
        for (int i = 0; i < selRows.length; ++i) {
            if (selRows[i] == dropRow) {
                return false;
            }
            if (selRows[i] != 0) continue;
            return false;
        }
        return !(targetNode instanceof LayerCollection) || !this.containsDescendantPath(dl.getPath(), tree.getSelectionPaths());
    }

    private boolean containsDescendantPath(TreePath target, TreePath[] sourcePath) {
        for (TreePath path : sourcePath) {
            if (!path.isDescendant(target)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            ArrayList<TreePath> toTransfer = new ArrayList<TreePath>();
            ArrayList<TreePath> toRemove = new ArrayList<TreePath>();
            TreePath path = paths[0];
            toTransfer.add(this.copy(path));
            toRemove.add(path);
            for (int i = 1; i < paths.length; ++i) {
                TreePath next = paths[i];
                toTransfer.add(this.copy(next));
                toRemove.add(next);
            }
            TreePath[] nodes = toTransfer.toArray(new TreePath[toTransfer.size()]);
            this.nodesToRemove = toRemove;
            return new NodesTransferable(nodes);
        }
        return null;
    }

    private TreePath copy(TreePath path) {
        return new TreePath(path.getPath());
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) == 2) {
            // empty if block
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
        int childIndex = dl.getChildIndex();
        TreePath dest = dl.getPath();
        Object parent = dest != null ? dest.getLastPathComponent() : null;
        JTree tree = (JTree)support.getComponent();
        ActiveLayerModel model = ((ActiveLayerModelWrapperWithoutProgress)tree.getModel()).getModel();
        int index = childIndex;
        if (childIndex == -1 && parent != null) {
            index = model.getChildCount(parent);
        }
        if (support.isDataFlavorSupported(this.nodesFlavor)) {
            TreePath[] nodes = null;
            try {
                Transferable t = support.getTransferable();
                nodes = (TreePath[])t.getTransferData(this.nodesFlavor);
            }
            catch (UnsupportedFlavorException ufe) {
                System.out.println("UnsupportedFlavor: " + ufe.getMessage());
            }
            catch (IOException ioe) {
                System.out.println("I/O error: " + ioe.getMessage());
            }
            for (int i = nodes.length - 1; i >= 0; --i) {
                LayerCollection parentCollection;
                TreePath parentPath = nodes[i].getParentPath();
                Object layer = nodes[i].getLastPathComponent();
                if (parentPath.getLastPathComponent().equals(model.getRoot())) {
                    if (model.getIndexOfChild(model.getRoot(), layer) > -1 && model.getIndexOfChild(model.getRoot(), layer) < index) {
                        --index;
                    }
                } else if (parentPath.getLastPathComponent() instanceof LayerCollection && (parentCollection = (LayerCollection)parentPath.getLastPathComponent()).indexOf(layer) > -1 && parentCollection.indexOf(layer) < index) {
                    --index;
                }
                model.moveLayer(parentPath, dest, index, layer);
            }
            return true;
        }
        TreeMap<Integer, MapService> services = model.getMapServices();
        boolean dropped = this.dropPerformed(support, model, index, tree);
        if (dropped && dest != null && !dest.equals(tree.getPathForRow(0))) {
            int modelIndex = index;
            TreeMap<Integer, MapService> newServices = model.getMapServices();
            ArrayList<MapService> addedServices = new ArrayList<MapService>();
            Integer oldKey = null;
            for (Integer key : newServices.keySet()) {
                oldKey = oldKey == null ? key : Integer.valueOf(oldKey + 1);
                MapService mapService = newServices.get(key);
                if (mapService.equals(services.get(oldKey))) continue;
                addedServices.add(mapService);
                oldKey = oldKey - 1;
            }
            for (MapService mapService : addedServices) {
                model.moveLayer(tree.getPathForRow(0), dest, modelIndex, mapService);
            }
        }
        return dropped;
    }

    private boolean dropPerformed(TransferHandler.TransferSupport support, ActiveLayerModel activeLayerModel, int index, JComponent parent) {
        return LayerDropUtils.drop(support, activeLayerModel, index, parent);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public class NodesTransferable
    implements Transferable {
        TreePath[] nodes;

        public NodesTransferable(TreePath[] nodes) {
            this.nodes = nodes;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.nodes;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return TreeTransferHandler.this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return TreeTransferHandler.this.nodesFlavor.equals(flavor);
        }
    }
}

