/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.measuring;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DefaultRasterDocumentFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.RasterDocumentFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MessenGeometryListener;
import de.cismet.tools.collections.TypeSafeCollections;
import edu.umd.cs.piccolo.event.PInputEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MeasuringComponent
extends JPanel {
    private static final String MY_MESSEN_MODE = "MY_MESSEN_MODE";
    private final Logger log = Logger.getLogger(this.getClass());
    private final XBoundingBox initialBoundingBox;
    private RasterDocumentFeature mainRasterDocumentFeature;
    private final MessenGeometryListener mapListener;
    private MappingComponent map;
    private JPanel panCenter;

    public MeasuringComponent() {
        this(new XBoundingBox(2583621.251964098, 5682507.032498134, 2584022.9413952776, 5682742.852810634, "EPSG:31466", false), new Crs("EPSG:31466", "EPSG:31466", "EPSG:31466", false, true));
    }

    public MeasuringComponent(XBoundingBox initialBBox, Crs srs) {
        this.initComponents();
        this.mapListener = new MessenGeometryListener(this.map);
        this.initialBoundingBox = initialBBox;
        this.mainRasterDocumentFeature = null;
        ActiveLayerModel mappingModel = new ActiveLayerModel();
        mappingModel.addHome(initialBBox);
        mappingModel.setSrs(srs);
        mappingModel.setDefaultHomeSrs(srs);
        this.map.setAnimationDuration(0);
        this.map.setReadOnly(false);
        this.map.setMappingModel(mappingModel);
        this.map.gotoInitialBoundingBox();
        this.map.setInteractionMode("PAN");
        this.map.addInputListener(MY_MESSEN_MODE, this.mapListener);
        this.map.unlock();
    }

    public MessenGeometryListener getMessenInputListener() {
        return this.mapListener;
    }

    public void dispose() {
        this.panCenter.remove((Component)((Object)this.map));
        this.map.removeInputEventListener((PInputEventListener)this.mapListener);
        this.map.dispose();
        this.map = null;
    }

    public void reset() {
        this.removeAllFeatures();
        this.map.setInteractionMode("PAN");
    }

    public void removeAllFeatures() {
        if (this.map != null) {
            FeatureCollection fc = this.map.getFeatureCollection();
            if (fc instanceof DefaultFeatureCollection) {
                ((DefaultFeatureCollection)fc).clear();
            } else {
                fc.removeAllFeatures();
            }
        }
    }

    public void gotoInitialBoundingBox() {
        this.map.gotoInitialBoundingBox();
    }

    public void addFeature(Feature feature) {
        if (feature != null) {
            if (feature instanceof RasterDocumentFeature) {
                this.mainRasterDocumentFeature = (RasterDocumentFeature)feature;
            }
            this.getFeatureCollection().addFeature(feature);
        } else {
            this.log.warn((Object)"Feature is null!");
        }
    }

    public void addImage(BufferedImage bi) {
        this.addImage(bi, null);
    }

    public void addImage(BufferedImage bi, Geometry geometry) {
        DefaultRasterDocumentFeature drdf = geometry != null ? new DefaultRasterDocumentFeature(bi, geometry) : new DefaultRasterDocumentFeature(bi, this.initialBoundingBox.getX1(), this.initialBoundingBox.getY1());
        this.addFeature(drdf);
    }

    public void addImage(BufferedImage bi, Geometry geometry, int srid) {
        DefaultRasterDocumentFeature drdf = geometry != null ? new DefaultRasterDocumentFeature(bi, geometry) : new DefaultRasterDocumentFeature(bi, this.initialBoundingBox.getX1(), this.initialBoundingBox.getY1(), srid);
        this.addFeature(drdf);
    }

    public MappingComponent getMap() {
        return this.map;
    }

    public FeatureCollection getFeatureCollection() {
        return this.map.getFeatureCollection();
    }

    public void zoomToFeatureCollection() {
        if (this.map.getWidth() > 0 && this.map.getHeight() > 0) {
            this.map.zoomToFeatureCollection();
        } else {
            this.map.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (MeasuringComponent.this.map.getWidth() > 0 && MeasuringComponent.this.map.getHeight() > 0) {
                        MeasuringComponent.this.map.zoomToFeatureCollection();
                        MeasuringComponent.this.map.removeComponentListener(this);
                    }
                }
            });
        }
    }

    private void initComponents() {
        this.panCenter = new JPanel();
        this.map = new MappingComponent();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.panCenter.setOpaque(false);
        this.panCenter.setLayout(new BorderLayout());
        this.map.setBorder(BorderFactory.createEtchedBorder());
        this.panCenter.add((Component)((Object)this.map), "Center");
        this.add((Component)this.panCenter, "Center");
    }

    private double calculateScaleFactor(double realDistance) {
        for (Feature f : this.map.getFeatureCollection().getAllFeatures()) {
            double virtualDistance;
            if (!(f instanceof PureNewFeature) || (virtualDistance = f.getGeometry().getLength()) == 0.0) continue;
            return realDistance / virtualDistance;
        }
        return 0.0;
    }

    private void applyScaling(double scalefactor) {
        BoundingBox oldViewBounds = this.map.getCurrentBoundingBoxFromCamera();
        double vX1 = oldViewBounds.getX1();
        double vY1 = oldViewBounds.getY1();
        double vX2 = oldViewBounds.getX2();
        double vY2 = oldViewBounds.getY2();
        this.getFeatureCollection().setHoldAll(false);
        ArrayList backup = TypeSafeCollections.newArrayList();
        for (Feature f : this.map.getFeatureCollection().getAllFeatures()) {
            backup.add(f);
        }
        this.map.getFeatureCollection().removeAllFeatures();
        AffineTransformation trafo = new AffineTransformation();
        trafo = trafo.scale(scalefactor, scalefactor);
        Point centroid = this.mainRasterDocumentFeature.getGeometry().getCentroid();
        double oldX = centroid.getX();
        double oldY = centroid.getY();
        for (Feature f : backup) {
            f.getGeometry().apply((CoordinateSequenceFilter)trafo);
        }
        centroid = this.mainRasterDocumentFeature.getGeometry().getCentroid();
        double transX = oldX - centroid.getX();
        double transY = oldY - centroid.getY();
        AffineTransformation backTranslation = AffineTransformation.translationInstance((double)transX, (double)transY);
        for (Feature f : backup) {
            f.getGeometry().apply((CoordinateSequenceFilter)backTranslation);
        }
        this.map.getFeatureCollection().addFeatures(backup);
        vX1 *= scalefactor;
        vY1 *= scalefactor;
        vX2 *= scalefactor;
        vY2 *= scalefactor;
        BoundingBox newBB = new BoundingBox(vX1 += transX, vY1 += transY, vX2 += transX, vY2 += transY);
        this.map.gotoBoundingBox(newBB, false, true, 0);
    }

    public void actionOverview() {
        this.map.zoomToFeatureCollection();
    }

    public void actionCalibrate(double measuredDistance) {
        if (measuredDistance != 0.0 && this.mainRasterDocumentFeature != null) {
            double scalefactor = this.calculateScaleFactor(measuredDistance);
            this.applyScaling(scalefactor);
        }
        this.map.setInteractionMode("PAN");
    }

    public Geometry getMainDocumentGeometry() {
        if (this.mainRasterDocumentFeature != null) {
            return this.mainRasterDocumentFeature.getGeometry();
        }
        return null;
    }

    public void actionMeasurePolygon() {
        this.mapListener.setMode("POLYGON");
        this.map.setInteractionMode(MY_MESSEN_MODE);
        this.map.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void actionMeasureLine() {
        this.mapListener.setMode("LINESTRING");
        this.map.setInteractionMode(MY_MESSEN_MODE);
        this.map.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void actionPan() {
        this.map.setInteractionMode("PAN");
    }

    public void actionZoom() {
        this.map.setInteractionMode("ZOOM");
    }
}

