/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.options;

import de.cismet.cismap.commons.gui.options.CismapOptionsCategory;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GPSDirectionOptions
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final String OPTION_NAME = NbBundle.getMessage(GPSDirectionOptions.class, (String)"GPSDirectionOptions.OPTION_NAME");
    private static Logger LOG = Logger.getLogger(GPSDirectionOptions.class);
    private static final String CONFIGURATION = "GPSDirectionOptions";
    private static final String GPS_ANGLE_DIRECTION_CONFIG = "GpsAngleDirection";
    private GPSDirection direction = GPSDirection.AUTO;
    private boolean stillConfigured = false;
    private ButtonGroup bgDirection;
    private JRadioButton rbAuto;
    private JRadioButton rbClockwise;
    private JRadioButton rbCounterClockwise;

    public GPSDirectionOptions() {
        super(OPTION_NAME, CismapOptionsCategory.class);
        this.initComponents();
    }

    private void initComponents() {
        this.bgDirection = new ButtonGroup();
        this.rbAuto = new JRadioButton();
        this.rbClockwise = new JRadioButton();
        this.rbCounterClockwise = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.bgDirection.add(this.rbAuto);
        Mnemonics.setLocalizedText((AbstractButton)this.rbAuto, (String)NbBundle.getMessage(GPSDirectionOptions.class, (String)"GPSDirectionOptions.rbAuto.text", (Object[])new Object[0]));
        this.rbAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GPSDirectionOptions.this.rbAutoActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.add(this.rbAuto, gridBagConstraints);
        this.bgDirection.add(this.rbClockwise);
        Mnemonics.setLocalizedText((AbstractButton)this.rbClockwise, (String)NbBundle.getMessage(GPSDirectionOptions.class, (String)"GPSDirectionOptions.rbClockwise.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add(this.rbClockwise, gridBagConstraints);
        this.bgDirection.add(this.rbCounterClockwise);
        Mnemonics.setLocalizedText((AbstractButton)this.rbCounterClockwise, (String)NbBundle.getMessage(GPSDirectionOptions.class, (String)"GPSDirectionOptions.rbCounterClockwise.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add(this.rbCounterClockwise, gridBagConstraints);
    }

    private void rbAutoActionPerformed(ActionEvent evt) {
    }

    public int getOrder() {
        return 4;
    }

    public String getTooltip() {
        return NbBundle.getMessage(GPSDirectionOptions.class, (String)"GPSDirectionOptions.tooltip");
    }

    public void applyChanges() {
        this.direction = this.getSelectedValue();
        CismapBroker.getInstance().setGpsAngleDirection(this.direction);
    }

    private GPSDirection getSelectedValue() {
        if (this.rbAuto.isSelected()) {
            return GPSDirection.AUTO;
        }
        if (this.rbClockwise.isSelected()) {
            return GPSDirection.CW;
        }
        if (this.rbCounterClockwise.isSelected()) {
            return GPSDirection.CCW;
        }
        return GPSDirection.AUTO;
    }

    public void update() {
        this.direction = CismapBroker.getInstance().getGpsAngleDirection();
        if (this.direction == null) {
            this.rbAuto.setSelected(true);
        } else if (this.direction.equals((Object)GPSDirection.AUTO)) {
            this.rbAuto.setSelected(true);
        } else if (this.direction.equals((Object)GPSDirection.CW)) {
            this.rbClockwise.setSelected(true);
        } else if (this.direction.equals((Object)GPSDirection.CCW)) {
            this.rbCounterClockwise.setSelected(true);
        }
    }

    public boolean isChanged() {
        GPSDirection selected = this.getSelectedValue();
        return this.direction == null || !this.direction.equals((Object)selected);
    }

    public void configure(Element elmnt) {
        if (!this.stillConfigured) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Configure GPSDirectionOptions");
            }
            int gpsAngleDirection = 0;
            try {
                Element conf;
                String gpsDirection = "";
                if (elmnt != null && (conf = elmnt.getChild(CONFIGURATION)) != null) {
                    gpsDirection = conf.getChildText(GPS_ANGLE_DIRECTION_CONFIG);
                }
                try {
                    gpsAngleDirection = Integer.valueOf(gpsDirection);
                }
                catch (NumberFormatException ex) {
                    gpsAngleDirection = 0;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Konfigurieren des SearchOptionsPanel", (Throwable)ex);
            }
            if (gpsAngleDirection >= 0 && gpsAngleDirection < GPSDirection.values().length) {
                if (GPSDirection.values()[gpsAngleDirection].equals((Object)GPSDirection.AUTO)) {
                    this.rbAuto.setSelected(true);
                } else if (GPSDirection.values()[gpsAngleDirection].equals((Object)GPSDirection.CW)) {
                    this.rbClockwise.setSelected(true);
                } else if (GPSDirection.values()[gpsAngleDirection].equals((Object)GPSDirection.CCW)) {
                    this.rbCounterClockwise.setSelected(true);
                }
            } else {
                this.rbAuto.setSelected(true);
            }
            this.stillConfigured = true;
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"skip Configure SearchOptionsPanel - still configured");
        }
        this.applyChanges();
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        Element GpsAngleElement = new Element(GPS_ANGLE_DIRECTION_CONFIG);
        GpsAngleElement.addContent(String.valueOf(this.direction.ordinal()));
        conf.addContent((Content)GpsAngleElement);
        return conf;
    }

    public static enum GPSDirection {
        AUTO,
        CW,
        CCW;

    }
}

