/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.options;

import de.cismet.cismap.commons.gui.options.CismapOptionsCategory;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListenerInterface;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class GeometryOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final String OPTION_NAME = NbBundle.getMessage(GeometryOptionsPanel.class, (String)"GeometryOptionsPanel.OPTION_NAME");
    private static final String CONFIGURATION = "GeometryOptionsPanel";
    private static final String CONF_HOLD_GEOMETRIES = "EllipseEgdes";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private boolean stillConfigured = false;
    private int numOfEllipseEdges;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jTextField1;

    public GeometryOptionsPanel() {
        super(OPTION_NAME, CismapOptionsCategory.class);
        this.initComponents();
    }

    public int getOrder() {
        return 1;
    }

    public void update() {
        CreateGeometryListenerInterface listener = this.getListener();
        if (listener != null) {
            this.numOfEllipseEdges = listener.getNumOfEllipseEdges();
        }
        this.jTextField1.setText(String.valueOf(this.numOfEllipseEdges));
    }

    public void applyChanges() {
        this.numOfEllipseEdges = Integer.valueOf(this.jTextField1.getText());
        CreateGeometryListenerInterface listener = this.getListener();
        if (listener != null) {
            listener.setNumOfEllipseEdges(this.numOfEllipseEdges);
        }
    }

    public boolean isChanged() {
        int intEdges;
        try {
            intEdges = Integer.valueOf(this.jTextField1.getText());
        }
        catch (NumberFormatException ex) {
            intEdges = 0;
        }
        return this.numOfEllipseEdges != intEdges;
    }

    public String getTooltip() {
        return NbBundle.getMessage(GeometryOptionsPanel.class, (String)"GeometryOptionsPanel.tooltip");
    }

    private CreateGeometryListenerInterface getListener() {
        CreateGeometryListenerInterface result = null;
        if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null && CismapBroker.getInstance().getMappingComponent().getInputListener("SEARCH_POLYGON") != null) {
            result = (CreateGeometryListenerInterface)CismapBroker.getInstance().getMappingComponent().getInputListener("SEARCH_POLYGON");
        }
        return result;
    }

    public void configure(Element parent) {
        if (!this.stillConfigured) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Configure GeometryOptionsPanel");
            }
            try {
                Element conf;
                String elementNumOfEllipseEdges = "";
                if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
                    elementNumOfEllipseEdges = conf.getChildText(CONF_HOLD_GEOMETRIES);
                }
                this.numOfEllipseEdges = new Integer(elementNumOfEllipseEdges);
            }
            catch (Exception ex) {
                this.log.error((Object)"Fehler beim Konfigurieren des GeometryOptionsPanel", (Throwable)ex);
            }
            this.jTextField1.setText(String.valueOf(this.numOfEllipseEdges));
            this.stillConfigured = true;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"skip Configure GeometryOptionsPanel - still configured");
        }
        this.applyChanges();
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        Element holdSearchGeometriesElement = new Element(CONF_HOLD_GEOMETRIES);
        holdSearchGeometriesElement.addContent(Integer.toString(this.numOfEllipseEdges));
        conf.addContent((Content)holdSearchGeometriesElement);
        return conf;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabel1.setText(NbBundle.getMessage(GeometryOptionsPanel.class, (String)"GeometryOptionsPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(GeometryOptionsPanel.class, (String)"GeometryOptionsPanel.jLabel2.text"));
        this.jTextField1.setText(NbBundle.getMessage(GeometryOptionsPanel.class, (String)"GeometryOptionsPanel.jTextField1.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -2, 49, -2)).addComponent(this.jLabel1)).addContainerGap(40, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addContainerGap(36, Short.MAX_VALUE)));
    }
}

