/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.options;

import de.cismet.cismap.commons.gui.options.CismapOptionsCategory;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchCreateSearchGeometryListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.configuration.NoWriteError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class SearchOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final String OPTION_NAME = NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.OPTION_NAME");
    private static final String CONFIGURATION = "SearchOptionsPanel";
    private static final String CONF_HOLD_GEOMETRIES = "HoldGeometries";
    private static final String CONF_GEOMETRY_COLOR = "GeometryColor";
    private static final String CONF_GEOMETRY_TRANSPARENCY = "GeometryTransparency";
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private boolean stillConfigured = false;
    private boolean holdGeometries;
    private float geometryTransparency;
    private Color geometryColor;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JSlider jSlider1;
    private BindingGroup bindingGroup;

    public SearchOptionsPanel() {
        super(OPTION_NAME, CismapOptionsCategory.class);
        this.initComponents();
    }

    public int getOrder() {
        return 1;
    }

    public void update() {
        MetaSearchCreateSearchGeometryListener listener = this.getListener();
        if (listener != null) {
            this.holdGeometries = listener.isHoldingGeometries();
            this.geometryColor = listener.getSearchColor();
            this.geometryTransparency = listener.getSearchTransparency();
        }
        this.jCheckBox1.setSelected(this.holdGeometries);
        this.jPanel1.setBackground(this.geometryColor);
        this.jSlider1.setValue((int)(this.geometryTransparency * 100.0f));
    }

    public void applyChanges() {
        this.holdGeometries = this.jCheckBox1.isSelected();
        this.geometryColor = this.jPanel1.getBackground();
        this.geometryTransparency = (float)this.jSlider1.getValue() / 100.0f;
        MetaSearchCreateSearchGeometryListener listener = this.getListener();
        if (listener != null) {
            listener.setHoldGeometries(this.holdGeometries);
            listener.setSearchColor(this.geometryColor);
            listener.setSearchTransparency(this.geometryTransparency);
        }
    }

    public boolean isChanged() {
        return this.holdGeometries != this.jCheckBox1.isSelected() || (this.geometryColor != null ? Integer.valueOf(this.geometryColor.getRGB()) : null) != (this.jPanel1.getBackground() != null ? Integer.valueOf(this.jPanel1.getBackground().getRGB()) : null) || this.geometryTransparency != (float)this.jSlider1.getValue() / 100.0f;
    }

    private MetaSearchCreateSearchGeometryListener getListener() {
        MetaSearchCreateSearchGeometryListener result = null;
        if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null && CismapBroker.getInstance().getMappingComponent().getInputListener("SEARCH_POLYGON") != null) {
            result = (MetaSearchCreateSearchGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener("SEARCH_POLYGON");
        }
        return result;
    }

    public void configure(Element parent) {
        if (!this.stillConfigured) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Configure SearchOptionsPanel");
            }
            try {
                Element conf;
                String elementHoldGeometries = "";
                String elementGeometryColor = "";
                String elementGeometryTransparency = "";
                if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
                    elementHoldGeometries = conf.getChildText(CONF_HOLD_GEOMETRIES);
                    elementGeometryColor = conf.getChildText(CONF_GEOMETRY_COLOR);
                    elementGeometryTransparency = conf.getChildText(CONF_GEOMETRY_TRANSPARENCY);
                }
                this.holdGeometries = new Boolean(elementHoldGeometries);
                try {
                    this.geometryColor = new Color(Integer.valueOf(elementGeometryColor));
                }
                catch (NumberFormatException ex) {
                    this.geometryColor = Color.GREEN;
                }
                try {
                    this.geometryTransparency = Float.valueOf(elementGeometryTransparency).floatValue();
                }
                catch (NumberFormatException ex) {
                    this.geometryTransparency = 0.5f;
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Fehler beim Konfigurieren des SearchOptionsPanel", (Throwable)ex);
            }
            this.jCheckBox1.setSelected(this.holdGeometries);
            this.jPanel1.setBackground(this.geometryColor);
            this.jSlider1.setValue((int)(this.geometryTransparency * 100.0f));
            this.stillConfigured = true;
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"skip Configure SearchOptionsPanel - still configured");
        }
        this.applyChanges();
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        Element holdSearchGeometriesElement = new Element(CONF_HOLD_GEOMETRIES);
        Element searchGeometryColorElement = new Element(CONF_GEOMETRY_COLOR);
        Element searchGeometryTransparencyElement = new Element(CONF_GEOMETRY_TRANSPARENCY);
        holdSearchGeometriesElement.addContent(Boolean.toString(this.holdGeometries));
        searchGeometryColorElement.addContent(String.valueOf(this.geometryColor != null ? Integer.valueOf(this.geometryColor.getRGB()) : null));
        searchGeometryTransparencyElement.addContent(String.valueOf(this.geometryTransparency));
        conf.addContent((Content)holdSearchGeometriesElement);
        conf.addContent((Content)searchGeometryColorElement);
        conf.addContent((Content)searchGeometryTransparencyElement);
        return conf;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jCheckBox1 = new JCheckBox();
        this.jButton1 = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.setAlignmentY(0.0f);
        this.setLayout(new GridBagLayout());
        this.jCheckBox1.setText(NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.jCheckBox1.text"));
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchOptionsPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 5, 3, 5);
        this.add(this.jCheckBox1, gridBagConstraints);
        this.jButton1.setText(NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchOptionsPanel.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.add(this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.jSeparator1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add(this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 5);
        this.add(this.jSlider1, gridBagConstraints);
        this.jPanel1.setPreferredSize(new Dimension(58, 29));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 58, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 29, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add(this.jPanel1, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add(this.jLabel1, gridBagConstraints);
        this.jLabel3.setPreferredSize(new Dimension(50, 17));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jSlider1, (Property)ELProperty.create((String)"${value}%"), (Object)this.jLabel3, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.add(this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add(this.jLabel4, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Color color = JColorChooser.showDialog((Component)((Object)this), "Farbe der Such-Geometrien w\u00e4hlen.", this.getColor());
        if (color != null) {
            this.setColor(color);
        }
    }

    private Color getColor() {
        return this.jPanel1.getBackground();
    }

    private void setColor(Color newColor) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("newColor: " + newColor));
        }
        this.jPanel1.setBackground(newColor);
    }

    public String getTooltip() {
        return NbBundle.getMessage(SearchOptionsPanel.class, (String)"SearchOptionsPanel.tooltip");
    }
}

