/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.overviewwidget;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CidsLayerFactory;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.GUIWindow;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class OverviewComponent
extends JPanel
implements Configurable,
GUIWindow {
    MappingComponent overviewMap = null;
    MappingComponent masterMap = null;
    ActiveLayerModel model = new ActiveLayerModel();
    Crs srs = new Crs("EPSG:31466", "EPSG:31466", "EPSG:31466", true, true);
    XBoundingBox home = new XBoundingBox(2567799.0, 5670041.0, 2594650.0, 5688258.0, this.srs.getCode(), this.srs.isMetric());
    private final Logger log = Logger.getLogger(this.getClass());
    private String url = "http://geoportal.wuppertal.de/deegree/wms?&VERSION=1.1.1&REQUEST=GetMap&WIDTH=<cismap:width>&HEIGHT=<cismap:height>&BBOX=<cismap:boundingBox>&SRS=EPSG:31466&FORMAT=image/png&TRANSPARENT=true&BGCOLOR=0xF0F0F0&EXCEPTIONS=application/vnd.ogc.se_xml&LAYERS=R102:stadtplan2007&STYLES=default";
    private HashMap<String, ServiceLayer> layerMap = new HashMap();

    public OverviewComponent() {
        this.initComponents();
        this.overviewMap = new MappingComponent();
        this.add((Component)((Object)this.overviewMap), "Center");
        this.overviewMap.setInteractionMode("OVERVIEW");
        this.overviewMap.setReadOnly(true);
        this.overviewMap.setFixedBoundingBox(this.home);
        this.model.setSrs(this.srs);
        this.model.addHome(this.home);
        this.overviewMap.setMappingModel(this.model);
        this.revalidate();
    }

    public void initBackgroundService() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"initBackgroundService");
        }
        this.model = new ActiveLayerModel();
        this.overviewMap.setFixedBoundingBox(this.home);
        this.model.setSrs(this.srs);
        this.model.setDefaultHomeSrs(this.srs);
        this.model.addHome(this.home);
        this.overviewMap.setMappingModel(this.model);
        this.overviewMap.resetWtst();
        this.model.removeAllLayers();
        for (String layerKey : this.layerMap.keySet()) {
            ServiceLayer layer = this.layerMap.get(layerKey);
            this.model.addLayer((RetrievalServiceLayer)layer);
            ((RetrievalServiceLayer)layer).addRetrievalListener(new RetrievalListener(){

                @Override
                public void retrievalStarted(RetrievalEvent e) {
                }

                @Override
                public void retrievalProgress(RetrievalEvent e) {
                }

                @Override
                public void retrievalComplete(RetrievalEvent e) {
                }

                @Override
                public void retrievalAborted(RetrievalEvent e) {
                }

                @Override
                public void retrievalError(RetrievalEvent e) {
                }
            });
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static void main(String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        JFrame f = new JFrame();
        f.setSize(500, 500);
        f.setDefaultCloseOperation(3);
        OverviewComponent ov = new OverviewComponent();
        f.getContentPane().add(ov);
        f.setVisible(true);
        ov.overviewMap.unlock();
    }

    public MappingComponent getOverviewMap() {
        return this.overviewMap;
    }

    public void setOverviewMap(MappingComponent overviewMap) {
        this.overviewMap = overviewMap;
    }

    public MappingComponent getMasterMap() {
        return this.masterMap;
    }

    public void setMasterMap(final MappingComponent masterMap) {
        this.masterMap = masterMap;
        final Color fill = new Color(255, 0, 0, 100);
        masterMap.getCamera().addPropertyChangeListener("viewTransform", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                try {
                    BoundingBox bb = masterMap.getCurrentBoundingBoxFromCamera();
                    if (!CismapBroker.getInstance().getSrs().getCode().equals(OverviewComponent.this.srs.getCode())) {
                        CrsTransformer transformer = new CrsTransformer(OverviewComponent.this.srs.getCode());
                        bb = transformer.transformBoundingBox(bb, CismapBroker.getInstance().getSrs().getCode());
                    }
                    double x = bb.getX1() + bb.getWidth() / 2.0;
                    double y = bb.getY2() - bb.getHeight() / 2.0;
                    OverviewComponent.this.overviewMap.getWtst();
                    OverviewComponent.this.overviewMap.outlineArea(bb, (Paint)fill);
                    OverviewComponent.this.overviewMap.crossHairPoint(new Coordinate(x, y));
                }
                catch (Exception e) {
                    OverviewComponent.this.log.error((Object)("Cannot transform the current boundingbox from " + CismapBroker.getInstance().getSrs().getCode() + " to " + OverviewComponent.this.srs.getCode()), (Throwable)e);
                }
            }
        });
    }

    public void configure(Element parent) {
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    public void masterConfigure(Element parent) {
        try {
            Element prefs = parent.getChild("cismapOverviewComponentPreferences");
            try {
                Crs tmp = new Crs();
                tmp.setCode(prefs.getAttributeValue("srs"));
                this.srs = tmp;
            }
            catch (Exception tmp) {
                // empty catch block
            }
            try {
                this.home = new XBoundingBox(prefs.getChild("overviewExtent"), this.srs.getCode(), true);
            }
            catch (Exception tmp) {
                // empty catch block
            }
            try {
                Element e = prefs.getChild("background").getChild("simpleWms");
                if (e != null) {
                    SimpleWMS simpleWMS = new SimpleWMS(prefs.getChild("background").getChild("simpleWms"));
                    this.layerMap.put("SimpleWms", simpleWMS);
                } else {
                    Element[] orderedLayers;
                    Element layersElement = prefs.getChild("background");
                    if (layersElement == null) {
                        this.log.error((Object)"Kein valides Layerelement gefunden.");
                        return;
                    }
                    for (Element curLayerElement : orderedLayers = CidsLayerFactory.orderLayers(layersElement)) {
                        String curKeyString = CidsLayerFactory.getKeyforLayerElement(curLayerElement);
                        if (curKeyString != null) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Adding element: " + curLayerElement + " with key: " + curKeyString));
                            }
                            ServiceLayer layer = CidsLayerFactory.createLayer(curLayerElement, new HashMap<String, WMSCapabilities>(), null);
                            this.layerMap.put(curKeyString, layer);
                            continue;
                        }
                        this.log.warn((Object)("Es war nicht m\u00f6glich einen Keystring f\u00fcr das Element: " + curLayerElement + " zu erzeugen"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initBackgroundService();
        }
        catch (Exception e) {
            this.log.warn((Object)"Fehler beim Konfigurieren der OverviewComponent. Fallback=Stadtplan", (Throwable)e);
            this.initBackgroundService();
        }
    }

    public JComponent getGuiComponent() {
        return this;
    }

    public String getPermissionString() {
        return "NoPermissionRequired";
    }

    public String getViewTitle() {
        return NbBundle.getMessage(OverviewComponent.class, (String)"OverviewWidget.getViewTitle");
    }

    public Icon getViewIcon() {
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/map.png"));
        return Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
    }
}

