/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.collections.HashArrayList;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class AngleMeasurementDialog
extends JDialog {
    private static final transient Logger LOG = Logger.getLogger(AngleMeasurementDialog.class);
    private static AngleMeasurementDialog INSTANCE = null;
    private static DecimalFormat FORMAT = new DecimalFormat("#0.00");
    private boolean mirrorAAllowed = false;
    private boolean mirrorBAllowed = false;
    private boolean mirrorA = false;
    private boolean mirrorB = false;
    private boolean showFeature = true;
    private boolean listSelectionListenerEnabled = true;
    private boolean featureCollectionListenerEnabled = true;
    private boolean initied = false;
    private final FeatureCollectionListModel featureCollectionListModel = new FeatureCollectionListModel();
    private final ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && AngleMeasurementDialog.this.isListSelectionListenerEnabled()) {
                AngleMeasurementDialog.this.applyListSelectionToMap();
                AngleMeasurementDialog.this.doCalculateAngle();
            }
        }
    };
    private PPath tempFeature = null;
    private boolean initialMcReadonly = false;
    private JButton btnCancel;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;
    private JPanel panButtons;
    private JPanel panParams;
    private JPanel panSide;

    private AngleMeasurementDialog() {
        super(StaticSwingTools.getParentFrame((Component)((Object)CismapBroker.getInstance().getMappingComponent())), false);
        this.initComponents();
    }

    public boolean isListSelectionListenerEnabled() {
        return this.listSelectionListenerEnabled;
    }

    public void setListSelectionListenerEnabled(boolean listSelectionListenerEnabled) {
        this.listSelectionListenerEnabled = listSelectionListenerEnabled;
    }

    public MappingComponent getMappingComponent() {
        return CismapBroker.getInstance().getMappingComponent();
    }

    public boolean isFeatureCollectionListenerEnabled() {
        return this.featureCollectionListenerEnabled;
    }

    public void setFeatureCollectionListenerEnabled(boolean featureCollectionListenerEnabled) {
        this.featureCollectionListenerEnabled = featureCollectionListenerEnabled;
    }

    public static AngleMeasurementDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AngleMeasurementDialog();
        }
        return INSTANCE;
    }

    public boolean isMirrorAAllowed() {
        return this.mirrorAAllowed;
    }

    public void setMirrorAAllowed(boolean mirrorAAllowed) {
        this.mirrorAAllowed = mirrorAAllowed;
        if (!mirrorAAllowed) {
            this.setMirrorA(false);
        }
    }

    public boolean isMirrorBAllowed() {
        return this.mirrorBAllowed;
    }

    public void setMirrorBAllowed(boolean mirrorBAllowed) {
        this.mirrorBAllowed = mirrorBAllowed;
        if (!mirrorBAllowed) {
            this.setMirrorB(false);
        }
    }

    public boolean isShowFeature() {
        return this.showFeature;
    }

    public void setShowFeature(boolean showFeature) {
        this.showFeature = showFeature;
    }

    public boolean isMirrorA() {
        return this.isMirrorAAllowed() && this.mirrorA;
    }

    public void setMirrorA(boolean mirrorA) {
        this.mirrorA = mirrorA;
    }

    public boolean isMirrorB() {
        return this.isMirrorBAllowed() && this.mirrorB;
    }

    public void setMirrorB(boolean mirrorB) {
        this.mirrorB = mirrorB;
    }

    private void initComponents() {
        this.panParams = new JPanel();
        this.panSide = new JPanel();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jPanel2 = new JPanel();
        this.jToggleButton2 = new JToggleButton();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton3 = new JToggleButton();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton2 = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.panButtons = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.title"));
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(450, 250));
        this.setPreferredSize(new Dimension(450, 250));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panParams.setLayout(new GridBagLayout());
        this.panSide.setLayout(new FlowLayout(1, 25, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.panSide, gridBagConstraints);
        this.jLabel4.setFont(new Font("Ubuntu", 1, 15));
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jLabel4.text"));
        this.jLabel4.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jLabel4, gridBagConstraints);
        this.jList1.setModel(this.featureCollectionListModel);
        this.jList1.setSelectionMode(0);
        this.jList1.setCellRenderer(new FeatureCollectionListCellRenderer());
        this.jScrollPane1.setViewportView(this.jList1);
        this.jList1.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jList2.setModel(this.featureCollectionListModel);
        this.jList2.setSelectionMode(0);
        this.jList2.setCellRenderer(new FeatureCollectionListCellRenderer());
        this.jScrollPane2.setViewportView(this.jList2);
        this.jList2.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jToggleButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/Angle-Thingy-icon.png")));
        this.jToggleButton2.setSelected(true);
        this.jToggleButton2.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jToggleButton2.text"));
        this.jToggleButton2.setFocusPainted(false);
        this.jToggleButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AngleMeasurementDialog.this.jToggleButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel2.add((Component)this.jToggleButton2, gridBagConstraints);
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/layer-flip.png")));
        this.jToggleButton1.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jToggleButton1.text"));
        this.jToggleButton1.setToolTipText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jToggleButton1.toolTipText"));
        this.jToggleButton1.setDisabledIcon(null);
        this.jToggleButton1.setFocusPainted(false);
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AngleMeasurementDialog.this.jToggleButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel2.add((Component)this.jToggleButton1, gridBagConstraints);
        this.jToggleButton3.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/layer-flip-vertical.png")));
        this.jToggleButton3.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jToggleButton3.text"));
        this.jToggleButton3.setToolTipText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jToggleButton3.toolTipText"));
        this.jToggleButton3.setDisabledIcon(null);
        this.jToggleButton3.setFocusPainted(false);
        this.jToggleButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AngleMeasurementDialog.this.jToggleButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel2.add((Component)this.jToggleButton3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panParams.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/layer-shape-line-crossed.png")));
        this.jButton2.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jButton2.text"));
        this.jButton2.setToolTipText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jButton2.toolTipText"));
        this.jButton2.setBorderPainted(false);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setDisabledIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/layer-shape-line.png")));
        this.jButton2.setEnabled(false);
        this.jButton2.setFocusPainted(false);
        this.jButton2.setFocusable(false);
        this.jButton2.setRequestFocusEnabled(false);
        this.jButton2.setRolloverEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AngleMeasurementDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.jPanel3.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panParams.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/layer-shape-line-crossed.png")));
        this.jButton1.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.jButton1.toolTipText"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setDisabledIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/layer-shape-line.png")));
        this.jButton1.setEnabled(false);
        this.jButton1.setFocusPainted(false);
        this.jButton1.setFocusable(false);
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.setRolloverEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AngleMeasurementDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.jPanel4.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.panParams.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panParams, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 0, 5, 0));
        this.btnCancel.setText(NbBundle.getMessage(AngleMeasurementDialog.class, (String)"AngleMeasurementDialog.btnCancel.text_2"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AngleMeasurementDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnCancel);
        this.panButtons.add(this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.panButtons, gridBagConstraints);
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        this.setShowFeature(this.jToggleButton2.isSelected());
        if (this.tempFeature != null) {
            if (this.isShowFeature()) {
                this.getMappingComponent().getTmpFeatureLayer().addChild((PNode)this.tempFeature);
            } else {
                try {
                    this.getMappingComponent().getTmpFeatureLayer().removeChild((PNode)this.tempFeature);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.refreshButtons();
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.setMirrorA(this.jToggleButton1.isSelected());
        this.doCalculateAngle();
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.setMirrorB(this.jToggleButton3.isSelected());
        this.doCalculateAngle();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Feature feature = (Feature)this.jList1.getSelectedValue();
        if (feature != null) {
            this.getMappingComponent().getFeatureCollection().removeFeature(feature);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Feature feature = (Feature)this.jList2.getSelectedValue();
        if (feature != null) {
            this.getMappingComponent().getFeatureCollection().removeFeature(feature);
        }
    }

    @Override
    public void dispose() {
        this.setFeatureCollectionListenerEnabled(false);
        try {
            if (this.tempFeature != null) {
                this.getMappingComponent().getTmpFeatureLayer().removeChild((PNode)this.tempFeature);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.featureCollectionListModel.clear();
        this.getMappingComponent().setReadOnly(this.initialMcReadonly);
        this.tempFeature = null;
        super.dispose();
    }

    private void refreshButtons() {
        this.jToggleButton2.setSelected(this.isShowFeature());
        this.jToggleButton1.setSelected(this.isShowFeature() && this.isMirrorA());
        this.jToggleButton1.setEnabled(this.isMirrorAAllowed() && this.isShowFeature() && this.tempFeature != null);
        this.jToggleButton3.setSelected(this.isShowFeature() && this.isMirrorB());
        this.jToggleButton3.setEnabled(this.isMirrorBAllowed() && this.isShowFeature() && this.tempFeature != null);
        this.jButton1.setEnabled(this.jList1.getSelectedValue() instanceof PureNewFeature);
        this.jButton2.setEnabled(this.jList2.getSelectedValue() instanceof PureNewFeature);
    }

    @Override
    public void setVisible(boolean b) {
        this.initialMcReadonly = this.getMappingComponent().isReadOnly();
        this.getMappingComponent().setReadOnly(false);
        super.setVisible(b);
        if (b) {
            this.setFeatureCollectionListenerEnabled(true);
            this.featureCollectionListModel.refresh();
        }
        if (this.isShowFeature() && this.tempFeature != null) {
            this.getMappingComponent().getTmpFeatureLayer().addChild((PNode)this.tempFeature);
        }
        this.refreshButtons();
    }

    private void doCalculateAngle() {
        Coordinate coordB2;
        Coordinate coordB1;
        LineSegment segB;
        Coordinate coordA2;
        Feature featureA = (Feature)this.jList1.getSelectedValue();
        Feature featureB = (Feature)this.jList2.getSelectedValue();
        try {
            this.getMappingComponent().getTmpFeatureLayer().removeChild((PNode)this.tempFeature);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (featureA == null || !AngleMeasurementDialog.checkForSegment(featureA.getGeometry()) || featureB == null || !AngleMeasurementDialog.checkForSegment(featureB.getGeometry())) {
            this.setMirrorAAllowed(false);
            this.setMirrorBAllowed(false);
            this.jLabel4.setText("");
            return;
        }
        LineString geomA = (LineString)featureA.getGeometry();
        LineString geomB = (LineString)featureB.getGeometry();
        Coordinate coordA1 = geomA.getCoordinateN(0);
        LineSegment segA = new LineSegment(coordA1, coordA2 = geomA.getCoordinateN(1));
        Coordinate intersection = segA.lineIntersection(segB = new LineSegment(coordB1 = geomB.getCoordinateN(0), coordB2 = geomB.getCoordinateN(1)));
        if (intersection != null) {
            boolean intersectsA = coordA1.distance(intersection) > 0.01 && coordA2.distance(intersection) > 0.01 && segA.distance(intersection) < 0.01;
            boolean intersectsB = coordB1.distance(intersection) > 0.01 && coordB2.distance(intersection) > 0.01 && segB.distance(intersection) < 0.01;
            this.setMirrorAAllowed(intersectsA);
            this.setMirrorBAllowed(intersectsB);
            Coordinate cA0 = intersection.distance(coordA1) > intersection.distance(coordA2) ? coordA1 : coordA2;
            Coordinate cA1 = intersection.distance(coordA1) > intersection.distance(coordA2) ? coordA2 : coordA1;
            Coordinate cB0 = intersection.distance(coordB1) > intersection.distance(coordB2) ? coordB1 : coordB2;
            Coordinate cB1 = intersection.distance(coordB1) > intersection.distance(coordB2) ? coordB2 : coordB1;
            Coordinate cA = !this.isMirrorA() ? cA0 : cA1;
            Coordinate cB = !this.isMirrorB() ? cB0 : cB1;
            LineSegment interSegA = new LineSegment(intersection, cA);
            LineSegment interSegB = new LineSegment(intersection, cB);
            double angle = interSegA.angle() > interSegB.angle() ? Math.toDegrees(interSegA.angle()) - Math.toDegrees(interSegB.angle()) : Math.toDegrees(interSegB.angle()) - Math.toDegrees(interSegA.angle());
            if (angle > 180.0) {
                angle = 360.0 - angle;
            }
            this.tempFeature = this.createNewTempFeature();
            this.tempFeature.setPathToPolyline(new Point2D[]{new Point2D.Double(this.getMappingComponent().getWtst().getScreenX(cA.x), this.getMappingComponent().getWtst().getScreenY(cA.y)), new Point2D.Double(this.getMappingComponent().getWtst().getScreenX(intersection.x), this.getMappingComponent().getWtst().getScreenY(intersection.y)), new Point2D.Double(this.getMappingComponent().getWtst().getScreenX(cB.x), this.getMappingComponent().getWtst().getScreenY(cB.y))});
            if (this.isShowFeature()) {
                this.getMappingComponent().getTmpFeatureLayer().addChild((PNode)this.tempFeature);
            }
            this.jLabel4.setText(FORMAT.format(angle) + " \u00b0");
        } else {
            this.setMirrorAAllowed(false);
            this.setMirrorBAllowed(false);
            this.tempFeature = null;
            this.jLabel4.setText("\u221e \u00b0");
        }
        this.refreshButtons();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AngleMeasurementDialog dialog = new AngleMeasurementDialog();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public static boolean checkForSegment(Geometry geom) {
        return geom instanceof LineString && geom.getNumPoints() == 2;
    }

    protected PPath createNewTempFeature() {
        PPath newTempFeaturePath = new PPath();
        newTempFeaturePath.setStroke((Stroke)new FixedWidthStroke());
        Color fillingColor = Color.BLUE;
        newTempFeaturePath.setStrokePaint((Paint)fillingColor);
        newTempFeaturePath.setPaint((Paint)fillingColor);
        newTempFeaturePath.setTransparency(0.2f);
        return newTempFeaturePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyListSelectionToMap() {
        Feature feature1 = (Feature)this.jList1.getSelectedValue();
        Feature feature2 = (Feature)this.jList2.getSelectedValue();
        ArrayList<Feature> featuresToSelect = new ArrayList<Feature>();
        if (feature1 != null && this.getMappingComponent().getFeatureCollection().contains(feature1)) {
            featuresToSelect.add(feature1);
        }
        if (feature2 != null && this.getMappingComponent().getFeatureCollection().contains(feature2)) {
            featuresToSelect.add(feature2);
        }
        this.setFeatureCollectionListenerEnabled(false);
        try {
            this.getMappingComponent().getFeatureCollection().select(featuresToSelect);
        }
        finally {
            this.setFeatureCollectionListenerEnabled(true);
        }
    }

    class FeatureCollectionListCellRenderer
    extends DefaultListCellRenderer {
        FeatureCollectionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component superComp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof XStyledFeature && superComp instanceof JLabel) {
                ((JLabel)superComp).setText(((XStyledFeature)value).getName());
            }
            return superComp;
        }
    }

    class FeatureCollectionListModel
    extends DefaultListModel<Feature> {
        private final List<Feature> segmentFeatures = new HashArrayList();
        private final FeatureCollectionListener featureCollectionListener = new FeatureCollectionListener(){

            @Override
            public void featuresAdded(FeatureCollectionEvent fce) {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && AngleMeasurementDialog.this.isVisible()) {
                        boolean changed = false;
                        for (Feature feature : FeatureCollectionListModel.this.filterSegments(fce.getEventFeatures())) {
                            if (FeatureCollectionListModel.this.segmentFeatures.contains(feature)) continue;
                            FeatureCollectionListModel.this.segmentFeatures.add(feature);
                            changed = true;
                        }
                        if (changed) {
                            FeatureCollectionListModel.this.fireContentChanged();
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while featuresAdded", (Throwable)ex);
                }
            }

            @Override
            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && AngleMeasurementDialog.this.isVisible() && !FeatureCollectionListModel.this.segmentFeatures.isEmpty()) {
                        AngleMeasurementDialog.this.jList1.clearSelection();
                        AngleMeasurementDialog.this.jList2.clearSelection();
                        FeatureCollectionListModel.this.segmentFeatures.clear();
                        FeatureCollectionListModel.this.fireContentChanged();
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while allFeaturesRemoved", (Throwable)ex);
                }
            }

            @Override
            public void featuresRemoved(FeatureCollectionEvent fce) {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && AngleMeasurementDialog.this.isVisible()) {
                        boolean changed = false;
                        for (Feature segment : FeatureCollectionListModel.this.filterSegments(fce.getEventFeatures())) {
                            if (!FeatureCollectionListModel.this.segmentFeatures.contains(segment)) continue;
                            if (segment.equals(AngleMeasurementDialog.this.jList1.getSelectedValue())) {
                                AngleMeasurementDialog.this.jList1.clearSelection();
                            }
                            if (segment.equals(AngleMeasurementDialog.this.jList2.getSelectedValue())) {
                                AngleMeasurementDialog.this.jList2.clearSelection();
                            }
                            FeatureCollectionListModel.this.segmentFeatures.remove(segment);
                            changed = true;
                        }
                        if (changed) {
                            FeatureCollectionListModel.this.fireContentChanged();
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while featuresRemoved", (Throwable)ex);
                }
            }

            @Override
            public void featuresChanged(FeatureCollectionEvent fce) {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && AngleMeasurementDialog.this.isVisible()) {
                        boolean changed = false;
                        for (Feature feature : fce.getEventFeatures()) {
                            if (!fce.getFeatureCollection().contains(feature) || !fce.getEventFeatures().contains(feature)) continue;
                            if (FeatureCollectionListModel.this.segmentFeatures.contains(feature) && !AngleMeasurementDialog.checkForSegment(feature.getGeometry())) {
                                if (feature.equals(AngleMeasurementDialog.this.jList1.getSelectedValue())) {
                                    AngleMeasurementDialog.this.jList1.clearSelection();
                                }
                                if (feature.equals(AngleMeasurementDialog.this.jList2.getSelectedValue())) {
                                    AngleMeasurementDialog.this.jList2.clearSelection();
                                }
                                FeatureCollectionListModel.this.segmentFeatures.remove(feature);
                                changed = true;
                                continue;
                            }
                            if (!FeatureCollectionListModel.this.segmentFeatures.contains(feature) && AngleMeasurementDialog.checkForSegment(feature.getGeometry())) {
                                FeatureCollectionListModel.this.segmentFeatures.add(feature);
                                changed = true;
                                continue;
                            }
                            if (!feature.equals(AngleMeasurementDialog.this.jList1.getSelectedValue()) && !feature.equals(AngleMeasurementDialog.this.jList2.getSelectedValue())) continue;
                            AngleMeasurementDialog.this.doCalculateAngle();
                        }
                        if (changed) {
                            SwingUtilities.invokeLater(new Thread("AngleMeasurementDialog featuresChanged()"){

                                @Override
                                public void run() {
                                    FeatureCollectionListModel.this.fireContentChanged();
                                }
                            });
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while featuresChanged", (Throwable)ex);
                }
            }

            @Override
            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && AngleMeasurementDialog.this.isVisible()) {
                        FeatureCollectionListModel.this.selectListFromFeatureCollection(AngleMeasurementDialog.this.getMappingComponent().getFeatureCollection());
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while featureSelectionChanged", (Throwable)ex);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && !AngleMeasurementDialog.this.isVisible()) return;
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while featureReconsiderationRequested", (Throwable)ex);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void featureCollectionChanged() {
                try {
                    if (AngleMeasurementDialog.this.isFeatureCollectionListenerEnabled() && !AngleMeasurementDialog.this.isVisible()) return;
                }
                catch (Exception ex) {
                    LOG.warn((Object)"error while featureCollectionChanged", (Throwable)ex);
                }
            }
        };

        public FeatureCollectionListModel() {
            AngleMeasurementDialog.this.getMappingComponent().getFeatureCollection().addFeatureCollectionListener(this.featureCollectionListener);
        }

        public void refresh() {
            this.segmentFeatures.clear();
            this.segmentFeatures.addAll(this.filterSegments(AngleMeasurementDialog.this.getMappingComponent().getFeatureCollection().getAllFeatures()));
            this.fireContentChanged();
            this.selectListFromFeatureCollection(AngleMeasurementDialog.this.getMappingComponent().getFeatureCollection());
        }

        public final Collection<Feature> filterSegments(Collection<Feature> allFeatures) {
            ArrayList<Feature> filtredFeatures = new ArrayList<Feature>();
            for (Feature potentialSegment : allFeatures) {
                Geometry geom = potentialSegment.getGeometry();
                if (!AngleMeasurementDialog.checkForSegment(geom)) continue;
                filtredFeatures.add(potentialSegment);
            }
            return filtredFeatures;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void selectListFromFeatureCollection(FeatureCollection featureCollection) {
            Collection features = featureCollection.getSelectedFeatures();
            ArrayList<Feature> selectedSegmentFeatures = new ArrayList<Feature>();
            for (Feature feature : features) {
                if (!this.segmentFeatures.contains(feature)) continue;
                selectedSegmentFeatures.add(feature);
            }
            if (selectedSegmentFeatures.size() == 1) {
                AngleMeasurementDialog.this.setListSelectionListenerEnabled(false);
                try {
                    AngleMeasurementDialog.this.jList1.setSelectedValue(selectedSegmentFeatures.get(0), true);
                    AngleMeasurementDialog.this.jList2.clearSelection();
                }
                finally {
                    AngleMeasurementDialog.this.setListSelectionListenerEnabled(true);
                }
            }
            if (selectedSegmentFeatures.size() == 2) {
                Feature featureA = (Feature)selectedSegmentFeatures.get(0);
                Feature featureB = (Feature)selectedSegmentFeatures.get(1);
                AngleMeasurementDialog.this.setListSelectionListenerEnabled(false);
                try {
                    AngleMeasurementDialog.this.jList1.setSelectedValue(featureA, true);
                    AngleMeasurementDialog.this.jList2.setSelectedValue(featureB, true);
                }
                finally {
                    AngleMeasurementDialog.this.setListSelectionListenerEnabled(true);
                }
            }
            AngleMeasurementDialog.this.setListSelectionListenerEnabled(false);
            try {
                AngleMeasurementDialog.this.jList1.clearSelection();
                AngleMeasurementDialog.this.jList2.clearSelection();
            }
            finally {
                AngleMeasurementDialog.this.setListSelectionListenerEnabled(true);
            }
            AngleMeasurementDialog.this.doCalculateAngle();
        }

        private void fireContentChanged() {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            if (this.getSize() == 2) {
                AngleMeasurementDialog.this.setListSelectionListenerEnabled(false);
                try {
                    AngleMeasurementDialog.this.jList1.setSelectedIndex(0);
                    AngleMeasurementDialog.this.jList2.setSelectedIndex(1);
                }
                finally {
                    AngleMeasurementDialog.this.setListSelectionListenerEnabled(true);
                }
                AngleMeasurementDialog.this.applyListSelectionToMap();
                AngleMeasurementDialog.this.doCalculateAngle();
            }
        }

        @Override
        public Feature getElementAt(int index) {
            if (index < 0 || index >= this.getSize()) {
                return null;
            }
            return this.segmentFeatures.get(index);
        }

        @Override
        public int getSize() {
            return this.segmentFeatures.size();
        }
    }
}

