/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class EllipsePHandle
extends PHandle {
    private static final Logger LOG = Logger.getLogger(EllipsePHandle.class);
    private final PFeature pfeature;
    private Point2D startPoint;

    public EllipsePHandle(final PFeature pfeature) {
        super(new PLocator(){

            public double locateX() {
                return pfeature.getBounds().getMaxX();
            }

            public double locateY() {
                return pfeature.getBounds().getMaxY();
            }
        }, pfeature.getViewer());
        this.pfeature = pfeature;
        this.startPoint = pfeature.getBounds().getOrigin();
    }

    @Override
    public void dragHandle(PDimension aLocalDimension, PInputEvent pInputEvent) {
        int n = this.pfeature.getCoordArr(0, 0).length - 1;
        Point2D dragPoint = pInputEvent.getPosition();
        double a = this.startPoint.getX() - dragPoint.getX();
        double b = this.startPoint.getY() - dragPoint.getY();
        double startX = this.startPoint.getX();
        double startY = this.startPoint.getY();
        Coordinate[] coordArr = EllipsePHandle.createEllipseCoordinates(n, a, b, pInputEvent.isControlDown(), pInputEvent.isShiftDown());
        for (int i = 0; i < coordArr.length; ++i) {
            this.pfeature.moveCoordinateToNewPiccoloPosition(0, 0, i, (float)(startX - coordArr[i].x), (float)(startY - coordArr[i].y));
        }
        this.relocateHandle();
    }

    public static Coordinate[] createEllipseCoordinates(int numOfEdges, double a, double b, boolean isCentered, boolean isCircle) {
        Coordinate[] coordArr = new Coordinate[numOfEdges + 1];
        if (isCircle) {
            boolean aNeg = a < 0.0;
            boolean bNeg = b < 0.0;
            if ((a = Math.abs(a)) > (b = Math.abs(b))) {
                b = a;
            } else {
                a = b;
            }
            a = aNeg ? -a : a;
            b = bNeg ? -b : b;
        }
        for (int i = 0; i <= numOfEdges; ++i) {
            double y;
            double x;
            float degrees = (float)i * (360.0f / (float)numOfEdges);
            if (isCentered) {
                x = a * Math.cos(Math.toRadians(degrees));
                y = b * Math.sin(Math.toRadians(degrees));
            } else {
                x = a / 2.0 + a / 2.0 * Math.cos(Math.toRadians(degrees));
                y = b / 2.0 + b / 2.0 * Math.sin(Math.toRadians(degrees));
            }
            coordArr[i] = new Coordinate(x, y);
        }
        return coordArr;
    }
}

