/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import pswing.PSwing;

public class InfoPanel
extends JPanel {
    private final Logger log = Logger.getLogger(this.getClass());
    private ImageIcon icoMore = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/more.png"));
    private ImageIcon icoShrink = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/shrink.png"));
    private PFeature pfeature;
    private PNode pNodeParent;
    private PSwing pSwing;
    private JComponent more;
    private JButton cmdMore;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblTitle;

    public InfoPanel(JComponent more) {
        try {
            this.initComponents();
            this.cmdMore.setIcon(this.icoMore);
            this.cmdMore.setText("");
            this.cmdMore.setOpaque(false);
            this.more = more;
            if (more == null) {
                this.cmdMore.setVisible(false);
            } else {
                this.add((Component)more, "Center");
                more.setVisible(false);
                more.addComponentListener(new ComponentListener(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                    }

                    @Override
                    public void componentMoved(ComponentEvent e) {
                    }

                    @Override
                    public void componentResized(ComponentEvent e) {
                        Thread t = new Thread("InfoPanel componentResized()"){

                            @Override
                            public void run() {
                                InfoPanel.this.revalidate();
                            }
                        };
                        CismetThreadPool.execute((Runnable)t);
                        InfoPanel.this.pSwing.reshape();
                    }

                    @Override
                    public void componentShown(ComponentEvent e) {
                    }
                });
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in InfoPanel");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblTitle = new JLabel();
        this.jPanel2 = new JPanel();
        this.cmdMore = new JButton();
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(83, 42));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.lblTitle.setBackground(UIManager.getDefaults().getColor("Nb.Desktop.background"));
        this.lblTitle.setFont(new Font("Tahoma", 0, 12));
        this.lblTitle.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.jLabel1.text"));
        this.lblTitle.setBorder(BorderFactory.createEmptyBorder(8, 3, 8, 3));
        this.lblTitle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                InfoPanel.this.lblTitleMouseClicked(evt);
            }
        });
        this.jPanel1.add((Component)this.lblTitle, "Center");
        this.jPanel2.setOpaque(false);
        this.cmdMore.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.cmdMore.text"));
        this.cmdMore.setBorderPainted(false);
        this.cmdMore.setFocusPainted(false);
        this.cmdMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPanel.this.cmdMoreActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmdMore);
        this.jPanel1.add((Component)this.jPanel2, "After");
        this.add((Component)this.jPanel1, "North");
    }

    private void lblTitleMouseClicked(MouseEvent evt) {
        this.cmdMoreActionPerformed(null);
    }

    private void cmdMoreActionPerformed(ActionEvent evt) {
        if (CismapBroker.getInstance().getMappingComponent().isInfoNodesVisible()) {
            this.setExpanded(!this.isExpanded());
        }
    }

    public boolean isExpanded() {
        return this.more != null && this.more.isVisible();
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, true);
    }

    public void setExpanded(boolean expanded, boolean rescale) {
        if (this.more != null && this.more.getComponentCount() > 0) {
            this.more.setVisible(expanded);
            this.revalidate();
            if (this.more.isVisible()) {
                this.cmdMore.setIcon(this.icoShrink);
            } else {
                this.cmdMore.setIcon(this.icoMore);
            }
            this.pSwing.reshape();
            if (rescale) {
                this.pfeature.ensureFullVisibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.paintComponent(g);
            Color myGrey = new Color(210, 210, 210);
            g.setColor(myGrey);
            g.fillRoundRect(2, 1, this.getWidth() - 4, this.getHeight() - 2, 10, 10);
            if (this.pNodeParent != null) {
                this.pNodeParent.setWidth((double)this.getWidth());
                this.pNodeParent.setHeight((double)this.getHeight());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.doLayout();
            Graphics gr = g.create();
            this.printComponent(gr);
            this.printBorder(gr);
            this.adjustSize(this);
            for (int c = 0; c < this.getComponentCount(); ++c) {
                Component comp = this.getComponent(c);
                if (!comp.isVisible()) continue;
                Rectangle cr = comp.getBounds();
                Graphics cg = gr.create(cr.x, cr.y, cr.width, cr.height);
                comp.printAll(cg);
            }
        }
    }

    private void adjustSize(JComponent comp) {
        for (int i = 0; i < comp.getComponentCount(); ++i) {
            comp.getComponent(i).setSize(comp.getComponent(i).getPreferredSize());
            comp.getComponent(i).doLayout();
            if (!(comp.getComponent(i) instanceof JComponent)) continue;
            this.adjustSize((JComponent)comp.getComponent(i));
        }
    }

    public void setTitleText(String text) {
        this.lblTitle.setText(text);
    }

    public void setTitleIcon(Icon icon) {
        this.lblTitle.setIcon(icon);
    }

    public PFeature getPfeature() {
        return this.pfeature;
    }

    public void setPfeature(PFeature pfeature) {
        this.pfeature = pfeature;
    }

    public PNode getPNodeParent() {
        return this.pNodeParent;
    }

    public void setPNodeParent(PNode pNodeParent) {
        this.pNodeParent = pNodeParent;
    }

    public PSwing getPSwing() {
        return this.pSwing;
    }

    public void setPSwing(PSwing pSwing) {
        this.pSwing = pSwing;
    }
}

