/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.SublinePanel;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateLinearReferencedMarksListener;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import pswing.PSwing;

public class LinearReferencedLineMarkPHandle
extends PPath {
    public static final double DEFAULT_HANDLE_SIZE = 8.0;
    public static final Shape DEFAULT_HANDLE_SHAPE = new Ellipse2D.Double(0.0, 0.0, 8.0, 8.0);
    public static final Color DEFAULT_COLOR = Color.GREEN;
    private static final Logger LOG = Logger.getLogger(LinearReferencedLineMarkPHandle.class);
    private PLocator locator;
    private MappingComponent mc = null;
    private SublinePanel panel;
    private CreateLinearReferencedMarksListener measurementListener;
    private PSwing pswingComp;

    public LinearReferencedLineMarkPHandle(PLocator locator, CreateLinearReferencedMarksListener measurementListener, MappingComponent mc) {
        super(DEFAULT_HANDLE_SHAPE);
        this.mc = mc;
        this.locator = locator;
        this.measurementListener = measurementListener;
        this.installEventListener();
        this.setPaint(DEFAULT_COLOR);
        this.installHandleEventHandlers();
        this.startResizeBounds();
        this.initPanel();
        this.relocateHandle();
    }

    private void installEventListener() {
        PBasicInputEventHandler moveAndClickListener = new PBasicInputEventHandler(){

            public void mouseClicked(PInputEvent pInputEvent) {
                LinearReferencedLineMarkPHandle.this.handleClicked(pInputEvent);
            }

            public void mouseEntered(PInputEvent pInputEvent) {
                LinearReferencedLineMarkPHandle.this.measurementListener.getPLayer().removeChild((PNode)LinearReferencedLineMarkPHandle.this);
                LinearReferencedLineMarkPHandle.this.measurementListener.getPLayer().addChild((PNode)LinearReferencedLineMarkPHandle.this);
            }
        };
        this.addInputEventListener((PInputEventListener)moveAndClickListener);
    }

    private void handleClicked(PInputEvent pInputEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"handle selected");
        }
        if (pInputEvent.isRightMouseButton()) {
            MouseEvent swingEvent = (MouseEvent)pInputEvent.getSourceSwingEvent();
            this.measurementListener.getContextMenu().show(this.pswingComp.getComponent(), swingEvent.getX(), swingEvent.getY());
        }
    }

    private void initPanel() {
        this.panel = new SublinePanel();
        this.pswingComp = new PSwing(this.mc, this.panel);
        this.panel.setPNodeParent(this.pswingComp);
        this.addChild(this.pswingComp);
    }

    public void setPositions(double start, double end) {
        this.panel.setPositionStart(new DecimalFormat("0.00").format(start));
        this.panel.setPositionEnd(new DecimalFormat("0.00").format(end));
        this.relocateHandle();
        this.repaint();
    }

    protected void installHandleEventHandlers() {
        this.addPropertyChangeListener("transform", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LinearReferencedLineMarkPHandle.this.relocateHandle();
            }
        });
    }

    public PLocator getLocator() {
        return this.locator;
    }

    public void setLocator(PLocator locator) {
        this.locator = locator;
        this.invalidatePaint();
        this.relocateHandle();
    }

    public void setParent(PNode newParent) {
        super.setParent(newParent);
        this.relocateHandle();
    }

    public void parentBoundsChanged() {
        this.relocateHandle();
    }

    public void relocateHandle() {
        if (this.locator != null) {
            PBounds b = this.getBoundsReference();
            Point2D aPoint = this.locator.locatePoint(null);
            this.mc.getCamera().viewToLocal(aPoint);
            double newCenterX = aPoint.getX();
            double newCenterY = aPoint.getY();
            this.pswingComp.setOffset(newCenterX + 8.0, newCenterY - this.pswingComp.getHeight() / 2.0);
            if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
                this.setBounds(0.0, 0.0, 8.0, 8.0);
                this.centerBoundsOnPoint(newCenterX, newCenterY);
            }
        }
    }
}

