/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.LinearReferencedPointInfoPanel;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeatureListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.text.Format;
import org.apache.log4j.Logger;
import pswing.PSwing;

public class LinearReferencedPointPHandle
extends PHandle {
    private static final Logger LOG = Logger.getLogger(LinearReferencedPointPHandle.class);
    private PFeature pfeature;
    private LinearReferencedPointInfoPanel infoPanel;
    private PSwing pswingComp;

    public LinearReferencedPointPHandle(final PFeature pfeature) {
        super(new PLocator(){

            public double locateX() {
                try {
                    return pfeature.getXp(0, 0)[0];
                }
                catch (Exception ex) {
                    return -1.0;
                }
            }

            public double locateY() {
                try {
                    return pfeature.getYp(0, 0)[0];
                }
                catch (Exception ex) {
                    return -1.0;
                }
            }
        }, pfeature.getViewer());
        this.pfeature = pfeature;
        this.initPanel();
        ((LinearReferencedPointFeature)pfeature.getFeature()).addListener(new LinearReferencedPointFeatureListener(){

            @Override
            public void featureMoved(LinearReferencedPointFeature pointFeature) {
                LinearReferencedPointPHandle.this.relocateHandle();
            }

            @Override
            public void featureMerged(LinearReferencedPointFeature withPoint, LinearReferencedPointFeature mergePoint) {
            }
        });
    }

    public PFeature getPFeature() {
        return this.pfeature;
    }

    private void initPanel() {
        this.infoPanel = new LinearReferencedPointInfoPanel();
        this.pswingComp = new PSwing(this.pfeature.getViewer(), this.infoPanel);
        this.infoPanel.setPNodeParent(this.pswingComp);
        this.addChild(this.pswingComp);
    }

    @Override
    public void dragHandle(PDimension aLocalDimension, PInputEvent pInputEvent) {
        block8: {
            try {
                if (this.pfeature.getViewer().getHandleInteractionMode().equals("MOVE_HANDLE")) {
                    this.pfeature.getViewer().getCamera().localToView((Dimension2D)aLocalDimension);
                    WorldToScreenTransform wtst = this.pfeature.getViewer().getWtst();
                    LinearReferencedPointFeature linref = (LinearReferencedPointFeature)this.pfeature.getFeature();
                    Point2D dragPoint = pInputEvent.getPosition();
                    Coordinate coord = new Coordinate(wtst.getSourceX(dragPoint.getX()), wtst.getSourceY(dragPoint.getY()));
                    Coordinate snapPoint = null;
                    if (CismapBroker.getInstance().getMappingComponent().isSnappingEnabled() && MappingComponent.SnappingMode.POINT.equals((Object)CismapBroker.getInstance().getMappingComponent().getSnappingMode())) {
                        snapPoint = PFeatureTools.getNearestCoordinateInArea(CismapBroker.getInstance().getMappingComponent(), CismapBroker.getInstance().getMappingComponent().getCamera().viewToLocal((Point2D)dragPoint.clone()), false, null);
                    } else if (CismapBroker.getInstance().getMappingComponent().isSnappingEnabled() && MappingComponent.SnappingMode.BOTH.equals((Object)CismapBroker.getInstance().getMappingComponent().getSnappingMode())) {
                        snapPoint = PFeatureTools.getNearestCoordinateInArea(CismapBroker.getInstance().getMappingComponent(), CismapBroker.getInstance().getMappingComponent().getCamera().viewToLocal((Point2D)dragPoint.clone()), false, null);
                    }
                    if (snapPoint != null) {
                        linref.moveTo(snapPoint, null);
                    } else {
                        linref.moveTo(coord, null);
                    }
                    this.relocateHandle();
                }
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)"Error in dragHandle.", t);
            }
        }
    }

    private Feature getFeatureFromGeom(Geometry g) {
        for (Feature f : CismapBroker.getInstance().getMappingComponent().getFeatureCollection().getAllFeatures()) {
            if (!f.getGeometry().equals(g)) continue;
            return f;
        }
        return null;
    }

    @Override
    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        super.endHandleDrag(aLocalPoint, aEvent);
        LinearReferencedPointFeature linref = (LinearReferencedPointFeature)this.pfeature.getFeature();
        linref.moveFinished();
    }

    @Override
    public void relocateHandle() {
        super.relocateHandle();
        if (this.pfeature != null) {
            LinearReferencedPointFeature linref = (LinearReferencedPointFeature)this.pfeature.getFeature();
            String info = "";
            Format infoFormat = ((LinearReferencedPointFeature)this.pfeature.getFeature()).getInfoFormat();
            info = infoFormat != null ? infoFormat.format(linref.getCurrentPosition()) : String.valueOf(linref.getCurrentPosition());
            this.infoPanel.setLengthInfo(info);
            PBounds b = this.getBoundsReference();
            Point2D aPoint = this.getLocator().locatePoint(null);
            this.pfeature.getViewer().getCamera().viewToLocal(aPoint);
            double newCenterX = aPoint.getX();
            double newCenterY = aPoint.getY();
            this.pswingComp.setOffset(newCenterX + 8.0, newCenterY - this.pswingComp.getHeight() / 2.0);
            if (newCenterX != b.getCenterX() || newCenterY != b.getCenterY()) {
                this.setBounds(0.0, 0.0, 8.0, 8.0);
                this.centerBoundsOnPoint(newCenterX, newCenterY);
            }
        }
    }
}

