/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.RequestForRotatingPivotLock;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.apache.log4j.Logger;

public class PivotPHandle
extends PHandle {
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private PFeature pfeature;
    private Point2D mid;

    public PivotPHandle(final PFeature pfeature, final Point2D mid) {
        super(new PLocator(){

            public double locateX() {
                if (mid == null) {
                    return pfeature.getBounds().getCenter2D().getX();
                }
                return mid.getX();
            }

            public double locateY() {
                if (mid == null) {
                    return pfeature.getBounds().getCenter2D().getY();
                }
                return mid.getY();
            }
        }, pfeature.getViewer());
        this.pfeature = pfeature;
        this.mid = mid;
    }

    @Override
    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        if (this.pfeature == null || !(this.pfeature.getFeature() instanceof RequestForRotatingPivotLock)) {
            double scale = this.pfeature.getViewer().getCamera().getViewScale();
            this.mid.setLocation(this.mid.getX() + aLocalDimension.width / scale, this.mid.getY() + aLocalDimension.height / scale);
            this.relocateHandle();
        }
    }

    @Override
    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        if (this.pfeature == null || !(this.pfeature.getFeature() instanceof RequestForRotatingPivotLock)) {
            if (this.pfeature.getViewer().getFeatureCollection() instanceof DefaultFeatureCollection) {
                Collection selArr = this.pfeature.getViewer().getFeatureCollection().getSelectedFeatures();
                for (Object o : selArr) {
                    PFeature pf = this.pfeature.getViewer().getPFeatureHM().get(o);
                    pf.setPivotPoint(this.mid);
                }
            }
            if (this.pfeature.getViewer().isFeatureDebugging() && this.log.isDebugEnabled()) {
                this.log.debug((Object)("neuer PivotPunkt=(" + this.mid.getX() + ", " + this.mid.getY() + ")"));
            }
            super.endHandleDrag(aLocalPoint, aEvent);
        }
    }

    public Point2D getMid() {
        return this.mid;
    }
}

