/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.Attachable;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RectangleRubberBandListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class AttachFeatureListener
extends RectangleRubberBandListener {
    public static final String ATTACH_FEATURE_NOTIFICATION = "ATTACH_FEATURE_NOTIFICATION";
    private static final transient Logger log = Logger.getLogger(AttachFeatureListener.class);
    private PFeature featureToAttach = null;

    public void mouseClicked(PInputEvent pInputEvent) {
        PNode o = PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, 30.5, true);
        if (o instanceof PFeature) {
            super.mouseClicked(pInputEvent);
            this.featureToAttach = (PFeature)o;
            this.postFeatureAttachRequest();
        } else {
            this.featureToAttach = null;
        }
    }

    private Geometry createGeometryFromRectangle() {
        WorldToScreenTransform wtst = CismapBroker.getInstance().getMappingComponent().getWtst();
        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
        if (this.rectangle.getBounds().isEmpty()) {
            double x = wtst.getWorldX(this.rectangle.getBounds().getX());
            double y = wtst.getWorldY(this.rectangle.getBounds().getY());
            Coordinate coord = new Coordinate(x, y);
            return geomFactory.createPoint(coord);
        }
        double x1 = wtst.getWorldX(this.rectangle.getBounds().getMinX());
        double x2 = wtst.getWorldX(this.rectangle.getBounds().getMaxX());
        double y1 = wtst.getWorldY(this.rectangle.getBounds().getMinY());
        double y2 = wtst.getWorldY(this.rectangle.getBounds().getMaxY());
        Coordinate[] polyCords = new Coordinate[]{new Coordinate(x1, y1), new Coordinate(x2, y1), new Coordinate(x2, y2), new Coordinate(x1, y2), new Coordinate(x1, y1)};
        return geomFactory.createPolygon(geomFactory.createLinearRing(polyCords), null);
    }

    @Override
    public void mouseReleased(PInputEvent event) {
        super.mouseReleased(event);
        if (event.getButton() == 1 && event.getComponent() instanceof MappingComponent) {
            MappingComponent mc = (MappingComponent)event.getComponent();
            mc.getHandleLayer().removeAllChildren();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Markierviereck = " + this.rectangle.getBounds() + event));
            }
            Geometry geom = this.createGeometryFromRectangle();
            ArrayList<Feature> markedFeatures = new ArrayList<Feature>();
            for (Feature feature : mc.getFeatureCollection().getAllFeatures()) {
                if (!(feature instanceof Attachable) || !feature.getGeometry().intersects(geom)) continue;
                markedFeatures.add(feature);
            }
            if (!markedFeatures.isEmpty()) {
                if (markedFeatures.size() == 1) {
                    this.featureToAttach = mc.getPFeatureHM().get(markedFeatures.get(0));
                    this.postFeatureAttachRequest();
                } else {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)mc)), "Bitte nur ein Objekt zum Zuordnen ausw\u00e4hlen.", "Mehr als ein Objekt markiert.", 1);
                }
            }
        }
    }

    private void postFeatureAttachRequest() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(ATTACH_FEATURE_NOTIFICATION, (Object)this);
    }

    public PFeature getFeatureToAttach() {
        return this.featureToAttach;
    }
}

