/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.EllipsePHandle;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.RectangleFromLineDialog;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListenerInterface;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureDeleteAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.NewTextDialog;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CreateGeometryListener
extends PBasicInputEventHandler
implements CreateGeometryListenerInterface {
    private static final Logger LOG = Logger.getLogger(CreateGeometryListener.class);
    public static final String GEOMETRY_CREATED_NOTIFICATION = "GEOMETRY_CREATED_NOTIFICATION";
    protected static final int DEFAULT_NUMOF_ELLIPSE_EDGES = 36;
    protected MappingComponent mappingComponent;
    protected PInputEvent finishingEvent = null;
    protected String mode = "POLYGON";
    protected ArrayList<Point2D> points;
    protected Map<Point2D, Coordinate> snappedCoordinates = new HashMap<Point2D, Coordinate>();
    private boolean showCurrentLength = false;
    private PText currentLength;
    private Point2D startPoint;
    private PPath tempFeature;
    private boolean inProgress;
    private int numOfEllipseEdges = 36;
    private Stack<Point2D> undoPoints;
    private Class<? extends AbstractNewFeature> geometryFeatureClass = null;
    private AbstractNewFeature currentFeature = null;

    public CreateGeometryListener() {
        this(null, Feature.class);
    }

    public CreateGeometryListener(MappingComponent mc) {
        this(mc, Feature.class);
    }

    protected CreateGeometryListener(MappingComponent mc, Class geometryFeatureClass) {
        this.setGeometryFeatureClass(geometryFeatureClass);
        this.mappingComponent = mc;
        this.undoPoints = new Stack();
    }

    public boolean isShowCurrentLength() {
        return this.showCurrentLength;
    }

    public void setShowCurrentLength(boolean showCurrentLength) {
        this.showCurrentLength = showCurrentLength;
    }

    protected MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    protected boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public void setMode(String mode) throws IllegalArgumentException {
        if (this.modeEquals("LINESTRING") || this.modeEquals("POINT") || this.modeEquals("POLYGON") || this.modeEquals("ELLIPSE") || this.modeEquals("BOUNDING_BOX") || this.modeEquals("RECTANGLE_FROM_LINE") || this.modeEquals("TEXT")) {
            if (!this.modeEquals(mode)) {
                this.reset();
                this.mode = mode;
            }
        } else {
            throw new IllegalArgumentException("Mode:" + mode + " is not a valid Mode in this Listener.");
        }
    }

    public boolean modeEquals(String mode) {
        return mode == null ? this.mode == null : mode.equals(this.mode);
    }

    protected void reset() {
        if (this.mappingComponent != null) {
            this.mappingComponent.getTmpFeatureLayer().removeAllChildren();
        }
        this.currentFeature = null;
        this.inProgress = false;
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        super.mouseMoved(pInputEvent);
        if (this.inProgress) {
            Point2D point = PFeatureTools.getNearestPointInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null).getPoint();
            this.updatePolygon(point);
            if (this.showCurrentLength && this.isInMode("LINESTRING")) {
                if (this.currentLength == null) {
                    this.currentLength = new PText();
                    this.currentLength.setVisible(true);
                    if (this.currentLength != null) {
                        this.mappingComponent.getTmpFeatureLayer().addChild((PNode)this.currentLength);
                    }
                }
                Point2D leftInfoPoint = pInputEvent.getPosition();
                int fontSize = (int)(this.mappingComponent.getScaleDenominator() / 3700.0 * 12.0);
                if (fontSize < 1) {
                    fontSize = 1;
                }
                Font f = new Font("sansserif", 0, fontSize);
                this.currentLength.setFont(f);
                this.currentLength.setTextPaint((Paint)new Color(100, 100, 0));
                this.currentLength.setPaint((Paint)new Color(255, 255, 255));
                this.currentLength.setX(leftInfoPoint.getX() + 12.0 / this.mappingComponent.getCamera().getViewScale());
                this.currentLength.setY(leftInfoPoint.getY() - 12.0 / this.mappingComponent.getCamera().getViewScale());
                if (this.currentFeature != null && this.currentFeature.getGeometry() != null) {
                    this.currentLength.setText(StaticDecimalTools.round((double)this.currentFeature.getGeometry().getLength()));
                }
            }
        }
    }

    public void mousePressed(PInputEvent pInputEvent) {
        super.mouseClicked(pInputEvent);
        if (this.mappingComponent.isReadOnly()) {
            ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).removeFeaturesByInstance(PureNewFeature.class);
        }
        if (this.isInMode("TEXT")) {
            if (pInputEvent.isLeftMouseButton()) {
                Point2D point = null;
                if (point == null) {
                    point = pInputEvent.getPosition();
                }
                this.points = new ArrayList();
                this.snappedCoordinates.clear();
                this.points.add(point);
                this.readyForFinishing(pInputEvent);
            }
        } else if (this.isInMode("POINT")) {
            if (pInputEvent.isLeftMouseButton()) {
                Coordinate coord;
                this.snappedCoordinates.clear();
                PFeatureTools.SnappedPoint snappedPoint = PFeatureTools.getNearestPointInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null);
                if ((MappingComponent.SnappingMode.POINT.equals((Object)this.mappingComponent.getSnappingMode()) || MappingComponent.SnappingMode.BOTH.equals((Object)this.mappingComponent.getSnappingMode())) && !PFeatureTools.SnappedPoint.SnappedOn.NOTHING.equals((Object)snappedPoint.getSnappedOn()) && (coord = PFeatureTools.getNearestCoordinateInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null)) != null) {
                    this.snappedCoordinates.put(snappedPoint.getPoint(), coord);
                }
                this.points = new ArrayList();
                this.points.add(snappedPoint.getPoint());
                this.readyForFinishing(pInputEvent);
            }
        } else if (this.isInMode("BOUNDING_BOX")) {
            if (!this.inProgress) {
                this.initTempFeature();
                this.startPoint = pInputEvent.getPosition();
            }
        } else if (this.isInMode("ELLIPSE")) {
            if (!this.inProgress) {
                this.initTempFeature();
                this.startPoint = pInputEvent.getPosition();
            }
        } else if (this.isInMode("RECTANGLE_FROM_LINE")) {
            Point2D point;
            PFeatureTools.SnappedPoint snappedPoint = PFeatureTools.getNearestPointInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null);
            Point2D point2D = point = snappedPoint != null ? snappedPoint.getPoint() : pInputEvent.getPosition();
            if (pInputEvent.isLeftMouseButton()) {
                if (!this.inProgress) {
                    this.inProgress = true;
                    this.initTempFeature();
                    this.startPoint = point;
                    this.points = new ArrayList(5);
                    this.snappedCoordinates.clear();
                    this.points.add(this.startPoint);
                } else {
                    Point2D stopPoint = point;
                    this.points.add(stopPoint);
                    this.points.add(stopPoint);
                    this.points.add(this.startPoint);
                    this.points.add(this.startPoint);
                    double length = this.startPoint.distance(stopPoint);
                    Frame parentFrame = StaticSwingTools.getParentFrame((Component)((Object)this.mappingComponent));
                    final RectangleFromLineDialog dialog = new RectangleFromLineDialog(parentFrame, true, length);
                    dialog.addWidthChangedListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent ce) {
                            double height = dialog.getRectangleWidth();
                            boolean isLefty = dialog.isLefty();
                            Point2D startPoint = CreateGeometryListener.this.points.get(0);
                            Point2D stopPoint = CreateGeometryListener.this.points.get(1);
                            double deltaX = stopPoint.getX() - startPoint.getX();
                            double deltaY = stopPoint.getY() - startPoint.getY();
                            double alpha = Math.atan2(deltaY, deltaX);
                            double alpha90 = alpha + Math.toRadians(isLefty ? -90.0 : 90.0);
                            double x = Math.cos(alpha90) * height;
                            double y = Math.sin(alpha90) * height;
                            CreateGeometryListener.this.points.set(2, new Point2D.Double(x + stopPoint.getX(), y + stopPoint.getY()));
                            CreateGeometryListener.this.points.set(3, new Point2D.Double(x + startPoint.getX(), y + startPoint.getY()));
                            CreateGeometryListener.this.updatePolygon(null);
                        }
                    });
                    StaticSwingTools.showDialog((JDialog)dialog);
                    if (dialog.getReturnStatus() == 0) {
                        this.readyForFinishing(pInputEvent);
                    } else {
                        this.mappingComponent.getTmpFeatureLayer().removeChild((PNode)this.tempFeature);
                        this.inProgress = false;
                    }
                }
            } else if (pInputEvent.isRightMouseButton()) {
                if (this.tempFeature != null) {
                    this.mappingComponent.getTmpFeatureLayer().removeChild((PNode)this.tempFeature);
                }
                this.inProgress = false;
            }
        } else if (this.isInMode("POLYGON") || this.isInMode("LINESTRING")) {
            if (pInputEvent.isLeftMouseButton()) {
                if (pInputEvent.getClickCount() == 1) {
                    Coordinate coord;
                    Point2D point = null;
                    this.undoPoints.clear();
                    if (!this.inProgress) {
                        this.snappedCoordinates.clear();
                    }
                    if (this.mappingComponent.isSnappingEnabled() && (point = PFeatureTools.getNearestPointInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null).getPoint()) != null && (MappingComponent.SnappingMode.POINT.equals((Object)this.mappingComponent.getSnappingMode()) || MappingComponent.SnappingMode.BOTH.equals((Object)this.mappingComponent.getSnappingMode())) && (coord = PFeatureTools.getNearestCoordinateInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null)) != null) {
                        this.snappedCoordinates.put(point, coord);
                    }
                    if (point == null) {
                        point = pInputEvent.getPosition();
                    }
                    if (!this.inProgress) {
                        this.inProgress = true;
                        this.initTempFeature();
                        this.points = new ArrayList();
                        this.startPoint = point;
                        this.points.add(this.startPoint);
                    } else {
                        this.points.add(point);
                        this.updatePolygon(null);
                    }
                } else if (pInputEvent.getClickCount() == 2) {
                    if (this.isInMode("POLYGON")) {
                        if (this.points.size() == 2) {
                            Point2D pointP1 = this.points.get(0);
                            Point2D pointP4 = this.points.get(1);
                            this.points.remove(pointP4);
                            this.points.add(new Point2D.Double(pointP1.getX(), pointP4.getY()));
                            this.points.add(pointP4);
                            this.points.add(new Point2D.Double(pointP4.getX(), pointP1.getY()));
                        } else if (this.points.size() < 2) {
                            return;
                        }
                    }
                    this.readyForFinishing(pInputEvent);
                }
            } else if (pInputEvent.isRightMouseButton() && this.inProgress) {
                if (this.points.size() < 2 || pInputEvent.getClickCount() == 2) {
                    if (this.tempFeature != null) {
                        this.mappingComponent.getTmpFeatureLayer().removeChild((PNode)this.tempFeature);
                    }
                    this.inProgress = false;
                } else {
                    this.points.remove(this.points.size() - 1);
                    Point2D point = PFeatureTools.getNearestPointInArea(this.mappingComponent, pInputEvent.getCanvasPosition(), true, null).getPoint();
                    this.updatePolygon(point);
                }
            }
        }
    }

    private void readyForFinishing(PInputEvent event) {
        try {
            this.finishingEvent = event;
            if (this.currentFeature == null || this.currentFeature != null && this.currentFeature.getGeometry().isValid()) {
                this.createCurrentNewFeature(null);
                this.finishGeometry(this.currentFeature);
                this.inProgress = false;
            } else {
                this.reset();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error during the creation of the geometry", t);
        }
    }

    protected AbstractNewFeature getCurrentNewFeature() {
        return this.currentFeature;
    }

    protected void createCurrentNewFeature(Point2D lastPoint) {
        try {
            Point2D[] finalPoints = this.getPoints(lastPoint);
            AbstractNewFeature.geomTypes geomType = AbstractNewFeature.geomTypes.UNKNOWN;
            if (this.isInMode("ELLIPSE")) {
                geomType = AbstractNewFeature.geomTypes.ELLIPSE;
            } else if (this.isInMode("LINESTRING")) {
                geomType = AbstractNewFeature.geomTypes.LINESTRING;
            } else if (this.isInMode("POINT")) {
                geomType = AbstractNewFeature.geomTypes.POINT;
            } else if (this.isInMode("POLYGON")) {
                geomType = AbstractNewFeature.geomTypes.POLYGON;
            } else if (this.isInMode("BOUNDING_BOX")) {
                geomType = AbstractNewFeature.geomTypes.POLYGON;
            } else if (this.isInMode("RECTANGLE_FROM_LINE")) {
                geomType = AbstractNewFeature.geomTypes.POLYGON;
            } else if (this.isInMode("TEXT")) {
                geomType = AbstractNewFeature.geomTypes.TEXT;
            }
            int currentSrid = CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode());
            Constructor<? extends AbstractNewFeature> constructor = this.geometryFeatureClass.getConstructor(Point2D[].class, WorldToScreenTransform.class);
            AbstractNewFeature newFeature = constructor.newInstance(finalPoints, this.mappingComponent.getWtst());
            newFeature.setGeometryType(geomType);
            newFeature.getGeometry().setSRID(currentSrid);
            Geometry geom = newFeature.getGeometry();
            if (finalPoints != null) {
                boolean coordinatesChanged = false;
                for (int i = 0; i < finalPoints.length; ++i) {
                    Coordinate coord = this.snappedCoordinates.get(finalPoints[i]);
                    if (coord != null && (geom.getCoordinates()[i].x != coord.x || geom.getCoordinates()[i].y != coord.y)) {
                        geom.getCoordinates()[i].x = coord.x;
                        geom.getCoordinates()[i].y = coord.y;
                        coordinatesChanged = true;
                    }
                    if (!coordinatesChanged) continue;
                    geom.geometryChanged();
                }
            }
            geom = CrsTransformer.transformToGivenCrs(geom, this.mappingComponent.getMappingModel().getSrs().getCode());
            if (this.isInMode("LINESTRING") && geom.getGeometryType().equals("Polygon")) {
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), currentSrid);
                geom = factory.createLineString(((Polygon)geom).getExteriorRing().getCoordinates());
            }
            newFeature.setGeometry(geom);
            if (this.isInMode("TEXT")) {
                final AbstractNewFeature f = newFeature;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreateGeometryListener.this.createTextNode(f);
                    }
                });
                newFeature = null;
            }
            this.currentFeature = newFeature;
        }
        catch (Throwable throwable) {
            LOG.error((Object)"Error during the creation of the geometry", throwable);
            this.currentFeature = null;
        }
    }

    private void createTextNode(final AbstractNewFeature newFeature) {
        final NewTextDialog dialog = new NewTextDialog(StaticSwingTools.getParentFrame((Component)((Object)this.mappingComponent)), false);
        dialog.setRunWhenFinish(new Runnable(){

            @Override
            public void run() {
                if (dialog.isConfirmed()) {
                    newFeature.setName(dialog.getText());
                    if (!dialog.isAutoScaleEnabled()) {
                        int fontSize = (int)(CreateGeometryListener.this.mappingComponent.getScaleDenominator() / 3700.0 * 12.0);
                        Font f = dialog.getFont();
                        if (f == null) {
                            f = new Font("sansserif", 0, fontSize);
                        }
                        newFeature.setPrimaryAnnotationFont(f);
                    } else {
                        Font f = dialog.getFont();
                        if (f == null) {
                            int fontSize = (int)(CreateGeometryListener.this.mappingComponent.getScaleDenominator() / 3700.0 * 12.0);
                            f = new Font("sansserif", 0, fontSize);
                        } else {
                            int fontSize = (int)(CreateGeometryListener.this.mappingComponent.getScaleDenominator() / 3700.0 * (double)f.getSize());
                            f = f.deriveFont(fontSize);
                        }
                        newFeature.setPrimaryAnnotationFont(f);
                    }
                    newFeature.setAutoScale(dialog.isAutoScaleEnabled());
                    if (dialog.isHaloEnabled()) {
                        newFeature.setPrimaryAnnotationHalo(Color.WHITE);
                    }
                    CreateGeometryListener.this.finishGeometry(newFeature);
                }
            }
        });
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        dialog.setLocation((int)(mouseLocation.getX() + 10.0), (int)mouseLocation.getY());
        dialog.setVisible(true);
    }

    public void mouseReleased(PInputEvent arg0) {
        super.mouseReleased(arg0);
        if (this.inProgress && (this.isInMode("BOUNDING_BOX") || this.isInMode("ELLIPSE"))) {
            this.readyForFinishing(arg0);
        }
    }

    public void keyPressed(PInputEvent event) {
        if (this.inProgress) {
            if (!event.isControlDown() && this.points.size() > 0) {
                this.undoPoints.add(this.points.get(this.points.size() - 1));
                this.points.remove(this.points.size() - 1);
                if (this.points.isEmpty()) {
                    this.startPoint = null;
                    this.mappingComponent.getTmpFeatureLayer().removeAllChildren();
                    this.inProgress = false;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Backspace gedr\u00fcckt: letzter eingef\u00fcgter Punkt gel\u00f6scht.");
                }
                this.updatePolygon(null);
            } else if (event.isControlDown() && !this.undoPoints.isEmpty()) {
                this.points.add(this.undoPoints.pop());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Backspace + STRG gedr\u00fcckt: letzter gel\u00f6schter Punkt wiederhergestellt.");
                }
                this.updatePolygon(null);
            }
        } else if (!this.inProgress && this.points != null && this.points.isEmpty() && event.isControlDown()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Versuche Polygon und Startpunkt wiederherzustellen");
            }
            this.initTempFeature();
            this.startPoint = this.undoPoints.pop();
            this.points.add(this.startPoint);
            this.inProgress = true;
        }
    }

    private void createAction(MappingComponent m, AbstractNewFeature f) {
        this.mappingComponent.getMemUndo().addAction(new FeatureDeleteAction(m, f));
        this.mappingComponent.getMemRedo().clear();
    }

    protected Color getFillingColor() {
        return new Color(1.0f, 1.0f, 1.0f, 0.4f);
    }

    protected void updatePolygon(Point2D lastPoint) {
        this.createCurrentNewFeature(lastPoint);
        if (!(this.currentFeature instanceof SearchFeature)) {
            ArrayList<Feature> features = new ArrayList<Feature>();
            features.add(this.currentFeature);
            ((DefaultFeatureCollection)this.mappingComponent.getFeatureCollection()).fireFeaturesChanged(features);
        }
        if (this.tempFeature != null) {
            this.tempFeature.setPathToPolyline(this.getPoints(lastPoint));
            this.tempFeature.repaint();
        }
    }

    protected Point2D[] getPoints(Point2D lastPoint) {
        try {
            boolean movin;
            int plus;
            if (lastPoint == this.points.get(this.points.size() - 1)) {
                lastPoint = null;
            }
            if (lastPoint != null) {
                plus = 2;
                movin = true;
            } else {
                plus = 1;
                movin = false;
            }
            if (!this.isInMode("POLYGON")) {
                --plus;
            }
            Point2D[] p = new Point2D[this.points.size() + plus];
            for (int i = 0; i < this.points.size(); ++i) {
                p[i] = this.points.get(i);
            }
            if (movin) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"movin");
                }
                p[this.points.size()] = lastPoint;
                if (this.isInMode("POLYGON")) {
                    p[this.points.size() + 1] = this.startPoint;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"not movin");
                }
                if (this.isInMode("POLYGON")) {
                    p[this.points.size()] = this.startPoint;
                }
            }
            return p;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error in getPoints()", (Throwable)e);
            return new Point2D[0];
        }
    }

    @Override
    public boolean isInMode(String mode) {
        return this.mode.equals(mode);
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public Class getGeometryFeatureClass() {
        return this.geometryFeatureClass;
    }

    @Override
    public final void setGeometryFeatureClass(Class<? extends AbstractNewFeature> geometryFeatureClass) {
        this.geometryFeatureClass = geometryFeatureClass;
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        super.mouseDragged(pInputEvent);
        if (this.startPoint == null) {
            this.startPoint = pInputEvent.getPosition();
        }
        if (this.isInMode("BOUNDING_BOX")) {
            this.inProgress = true;
            this.points = new ArrayList(5);
            this.snappedCoordinates.clear();
            this.points.add(this.startPoint);
            this.points.add(new Point2D.Double(this.startPoint.getX(), pInputEvent.getPosition().getY()));
            this.points.add(pInputEvent.getPosition());
            this.points.add(new Point2D.Double(pInputEvent.getPosition().getX(), this.startPoint.getY()));
            this.points.add(this.startPoint);
            this.updatePolygon(null);
        } else if (this.isInMode("ELLIPSE")) {
            this.inProgress = true;
            Point2D dragPoint = pInputEvent.getPosition();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pInputEvent.getModifiers() = " + pInputEvent.getModifiers()));
            }
            double a = this.startPoint.getX() - dragPoint.getX();
            double b = this.startPoint.getY() - dragPoint.getY();
            double startX = this.startPoint.getX();
            double startY = this.startPoint.getY();
            Coordinate[] coordArr = EllipsePHandle.createEllipseCoordinates(this.getNumOfEllipseEdges(), a, b, pInputEvent.isControlDown(), pInputEvent.isShiftDown());
            this.points = new ArrayList(coordArr.length);
            this.snappedCoordinates.clear();
            for (int i = 0; i < coordArr.length; ++i) {
                this.points.add(new Point2D.Double(startX - coordArr[i].x, startY - coordArr[i].y));
            }
            this.updatePolygon(null);
        }
    }

    protected void finishGeometry(AbstractNewFeature newFeature) {
        this.mappingComponent.getTmpFeatureLayer().removeAllChildren();
        this.currentLength = null;
    }

    @Override
    public void setNumOfEllipseEdges(int numOfEllipseEdges) {
        if (numOfEllipseEdges <= 2) {
            numOfEllipseEdges = 36;
        }
        this.numOfEllipseEdges = numOfEllipseEdges;
    }

    @Override
    public int getNumOfEllipseEdges() {
        return this.numOfEllipseEdges;
    }

    protected PPath createNewTempFeature() {
        PPath newTempFeaturePath = new PPath();
        newTempFeaturePath.setStroke((Stroke)new FixedWidthStroke());
        if (!this.isInMode("LINESTRING")) {
            Color fillingColor = this.getFillingColor();
            newTempFeaturePath.setStrokePaint((Paint)fillingColor.darker());
            newTempFeaturePath.setPaint((Paint)fillingColor);
        }
        return newTempFeaturePath;
    }

    private void initTempFeature() {
        this.tempFeature = this.createNewTempFeature();
        this.mappingComponent.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
    }

    public void setMappingComponent(MappingComponent mappingComponent) {
        this.mappingComponent = mappingComponent;
    }
}

