/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionAdapter;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.LinearReferencedPointMarkPHandle;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class CreateLinearReferencedMarksListener
extends PBasicInputEventHandler {
    private static final float CURSOR_PANEL_TRANSPARENCY = 0.7f;
    private static final double INVISIBLE_CURSOR_DISTANCE = 0.015;
    protected MappingComponent mc;
    protected String mcModus = "LINEMEASUREMENT";
    private double identicalPositionDelta = 1.0;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private double cursorX = 1.4E-45f;
    private double cursorY = 1.4E-45f;
    private final LinearReferencedPointMarkPHandle cursorPHandle;
    private final Collection<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private HashMap<PFeature, Collection<PointMark>> featurePointMarks = new HashMap();
    private PointMark selectedPointMark;
    private Modus modus = Modus.MARK_ADD;
    private JPopupMenu menu;
    private JMenuItem cmdRemoveMark;
    private JMenuItem cmdRemoveAllMarks;

    public CreateLinearReferencedMarksListener(MappingComponent mc) {
        this.mc = mc;
        PLocator l = new PLocator(){

            public double locateX() {
                return CreateLinearReferencedMarksListener.this.cursorX;
            }

            public double locateY() {
                return CreateLinearReferencedMarksListener.this.cursorY;
            }
        };
        this.cursorPHandle = new LinearReferencedPointMarkPHandle(l, this, mc);
        this.cursorPHandle.setInfoPanelTransparency(0.7f);
        this.cursorPHandle.setPaint(null);
        if (mc != null) {
            mc.getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionAdapter(){

                @Override
                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    Feature[] sels;
                    Geometry geom;
                    Collection<Feature> sel = fce.getEventFeatures();
                    if (sel != null && sel.size() == 1 && ((geom = (sels = sel.toArray(new Feature[0]))[0].getGeometry()) != null || geom instanceof MultiLineString || geom instanceof LineString)) {
                        CreateLinearReferencedMarksListener.this.firePropertyChange(null);
                    }
                }
            });
        }
        this.initContextMenu();
    }

    public double getIdenticalPositionDelta() {
        return this.identicalPositionDelta;
    }

    public void setIdenticalPositionDelta(double identicalPositionDelta) {
        this.identicalPositionDelta = identicalPositionDelta;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        return this.listeners.remove(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public void mouseDragged(PInputEvent event) {
    }

    public void mouseReleased(PInputEvent event) {
    }

    public Double[] getMarkPositionsOfSelectedFeature() {
        Collection<PointMark> marks = this.getPointMarks(this.getSelectedLinePFeature());
        ArrayList<Double> positions = new ArrayList<Double>();
        for (PointMark mark : marks) {
            positions.add(mark.getPosition());
        }
        Object[] result = positions.toArray(new Double[0]);
        Arrays.sort(result);
        return result;
    }

    public void mouseClicked(PInputEvent event) {
        if (event.isLeftMouseButton()) {
            switch (this.modus) {
                case MARK_ADD: {
                    PFeature selPFeature = this.getSelectedLinePFeature();
                    if (selPFeature == null) break;
                    this.addMarkPHandle(new Coordinate(this.cursorX, this.cursorY));
                    break;
                }
            }
        }
    }

    public Coordinate getCoordinateOfPosition(double position) {
        LengthIndexedLine lil = new LengthIndexedLine(this.getSelectedLinePFeature().getFeature().getGeometry());
        return lil.extractPoint(position);
    }

    public Coordinate getSelectedMarkCoordinate() {
        return this.getCoordinateOfPosition(this.getSelectedMarkPosition());
    }

    public double getSelectedMarkPosition() {
        if (this.selectedPointMark != null) {
            return this.selectedPointMark.getPosition();
        }
        return 0.0;
    }

    public void setSelectedMark(LinearReferencedPointMarkPHandle markPHandle) {
        if (markPHandle == null) {
            this.selectedPointMark = null;
        } else {
            for (PointMark mark : this.getPointMarks(this.getSelectedLinePFeature())) {
                if (mark == null || !((Object)((Object)mark.getPHandle())).equals((Object)markPHandle)) continue;
                this.selectedPointMark = mark;
                break;
            }
        }
    }

    public JPopupMenu getContextMenu() {
        return this.menu;
    }

    public void removeContextMenuItem(JMenuItem item) {
        this.menu.remove(item);
    }

    public void addContextMenuItem(JMenuItem item) {
        this.menu.remove(this.cmdRemoveMark);
        this.menu.remove(this.cmdRemoveAllMarks);
        this.menu.add(item);
        this.menu.add(this.cmdRemoveMark);
        this.menu.add(this.cmdRemoveAllMarks);
    }

    private void initContextMenu() {
        this.menu = new JPopupMenu();
        this.cmdRemoveMark = new JMenuItem("Markierung entfernen");
        this.cmdRemoveAllMarks = new JMenuItem("alle Markierungen entfernen");
        this.cmdRemoveMark.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cismap/commons/gui/res/marker--minus.png")));
        this.cmdRemoveAllMarks.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cismap/commons/gui/res/marker--minus.png")));
        this.cmdRemoveMark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CreateLinearReferencedMarksListener.this.removeMark(CreateLinearReferencedMarksListener.this.selectedPointMark);
            }
        });
        this.cmdRemoveAllMarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CreateLinearReferencedMarksListener.this.removeAllMarks();
            }
        });
        if (this.menu.getComponentCount() > 0) {
            this.menu.addSeparator();
        }
        this.menu.add(this.cmdRemoveMark);
        this.menu.add(this.cmdRemoveAllMarks);
    }

    public PLayer getPLayer() {
        return this.mc.getHandleLayer();
    }

    private void removeMark(PointMark mark) {
        if (this.getSelectedLinePFeature() != null) {
            this.getPointMarks(this.getSelectedLinePFeature()).remove(mark);
            this.getPLayer().removeChild((PNode)mark.getPHandle());
            this.firePropertyChange(null);
        }
    }

    public void removeAllMarks() {
        Collection<PointMark> pointMarks = this.getPointMarks(this.getSelectedLinePFeature());
        for (PointMark mark : pointMarks) {
            this.getPLayer().removeChild((PNode)mark.getPHandle());
        }
        pointMarks.clear();
        this.firePropertyChange(null);
    }

    protected double getCurrentPosition() {
        if (this.getSelectedLinePFeature() != null) {
            double position = LinearReferencedPointFeature.getPositionOnLine(new Coordinate(this.mc.getWtst().getSourceX(this.cursorX), this.mc.getWtst().getSourceY(this.cursorY)), this.getSelectedLinePFeature().getFeature().getGeometry());
            if (position < 0.007) {
                return 0.0;
            }
            return position;
        }
        return 0.0;
    }

    private void showPointMarks(boolean show) {
        for (PointMark mark : this.getPointMarks(this.getSelectedLinePFeature())) {
            this.showOnFather((PNode)this.getPLayer(), mark.getPHandle(), show);
        }
    }

    private Collection<PointMark> getPointMarks(PFeature pFeature) {
        Collection<PointMark> pointMarks = this.featurePointMarks.get(this.getSelectedLinePFeature());
        if (pointMarks == null) {
            pointMarks = new ArrayList<PointMark>();
            this.featurePointMarks.put(pFeature, new ArrayList());
        }
        return pointMarks;
    }

    protected void addMarkPHandle(final Coordinate coordinate) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"create newPointHandle and Locator");
        }
        PLocator l = new PLocator(){

            public double locateX() {
                return coordinate.x;
            }

            public double locateY() {
                return coordinate.y;
            }
        };
        LinearReferencedPointMarkPHandle markHandle = new LinearReferencedPointMarkPHandle(l, this, this.mc);
        double currentPosition = this.getCurrentPosition();
        markHandle.setMarkPosition(currentPosition);
        Collection<PointMark> pointMarks = this.getPointMarks(this.getSelectedLinePFeature());
        boolean pointMarkStillExists = false;
        for (PointMark pointMark : pointMarks) {
            if (!(Math.abs(pointMark.getPosition() - currentPosition) < this.identicalPositionDelta)) continue;
            pointMarkStillExists = true;
            break;
        }
        if (!pointMarkStillExists) {
            PointMark pointMark = new PointMark(currentPosition, markHandle);
            pointMarks.add(pointMark);
            this.getPLayer().addChild((PNode)markHandle);
            this.setSelectedMark(markHandle);
            this.getPLayer().removeChild((PNode)this.cursorPHandle);
            this.getPLayer().addChild((PNode)this.cursorPHandle);
            this.firePropertyChange(null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Markierung mit (fast) der selben Position existiert bereits, neue Markierung wird also ignoriert.");
        }
    }

    private void showCursor(boolean show) {
        this.showOnFather((PNode)this.getPLayer(), this.cursorPHandle, show);
    }

    private void showOnFather(PNode father, PPath child, boolean show) {
        boolean found = false;
        for (Object o : father.getChildrenReference()) {
            if (o == null || !o.equals(child)) continue;
            found = true;
            break;
        }
        if (!found && show) {
            father.addChild((PNode)child);
        }
        if (found && !show) {
            father.removeChild((PNode)child);
        }
    }

    private void setModus(Modus modus) {
        this.modus = modus;
        this.refreshHandles();
    }

    private void refreshHandles() {
        if (this.getSelectedLinePFeature() != null) {
            switch (this.modus) {
                case MARK_SELECTION: {
                    this.showCursor(false);
                    this.showPointMarks(true);
                    break;
                }
                case MARK_ADD: {
                    this.showCursor(true);
                    this.showPointMarks(true);
                }
            }
        }
    }

    public Modus getModus() {
        return this.modus;
    }

    public void mouseMoved(PInputEvent event) {
        PFeature selPFeature;
        if (this.mc.getInteractionMode().equals(this.mcModus) && (selPFeature = this.getSelectedLinePFeature()) != null) {
            this.updateCursor(event.getPosition());
            this.cursorPHandle.setMarkPosition(this.getCurrentPosition());
            if (event.isControlDown()) {
                this.setModus(Modus.MARK_SELECTION);
            } else {
                this.setModus(Modus.MARK_ADD);
            }
        }
    }

    private void updateCursor(Point2D trigger) {
        PFeature selPFeature = this.getSelectedLinePFeature();
        if (selPFeature != null) {
            Geometry geom = selPFeature.getFeature().getGeometry();
            if (selPFeature != null) {
                Coordinate triggerCoordinate;
                Point2D point = trigger;
                Coordinate snapPoint = null;
                if (this.mc.isSnappingEnabled() && MappingComponent.SnappingMode.POINT.equals((Object)this.mc.getSnappingMode())) {
                    snapPoint = PFeatureTools.getNearestCoordinateInArea(this.mc, this.mc.getCamera().viewToLocal((Point2D)trigger.clone()), false, null);
                }
                if ((triggerCoordinate = snapPoint) == null) {
                    triggerCoordinate = new Coordinate(this.mc.getWtst().getSourceX(point.getX()), this.mc.getWtst().getSourceY(point.getY()));
                }
                Geometry lineGeometry = LinearReferencedPointFeature.getReducedLineGeometry(geom, new Coordinate(this.cursorX, this.cursorY), triggerCoordinate);
                Coordinate erg = LinearReferencedPointFeature.getNearestCoordninateOnLine(triggerCoordinate, lineGeometry);
                double dist = LinearReferencedPointFeature.getDistanceOfCoordToLine(triggerCoordinate, lineGeometry);
                boolean cursorIsVisible = dist / this.mc.getScaleDenominator() < 0.015;
                this.cursorPHandle.setVisible(cursorIsVisible);
                this.cursorX = this.mc.getWtst().getDestX(erg.x);
                this.cursorY = this.mc.getWtst().getDestY(erg.y);
            }
        }
    }

    public PFeature getSelectedLinePFeature() {
        FeatureCollection fc = this.mc.getFeatureCollection();
        Collection sel = fc.getSelectedFeatures();
        if (fc instanceof DefaultFeatureCollection && sel.size() == 1) {
            Feature[] sels = sel.toArray(new Feature[0]);
            Geometry geom = sels[0].getGeometry();
            if (geom != null || geom instanceof MultiLineString || geom instanceof LineString) {
                SelectionListener sl;
                List<PFeature> fl;
                PFeature pf = this.mc.getPFeatureHM().get(sels[0]);
                if (pf == null && (fl = (sl = (SelectionListener)this.mc.getInputEventListener().get("SELECT")).getAllSelectedPFeatures()) != null && fl.size() == 1) {
                    pf = fl.get(0);
                }
                return pf;
            }
            if (this.log.isDebugEnabled()) {
                if (geom == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"geom is null");
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Wrong geometry type: " + geom.getGeometryType()));
                }
            }
            return null;
        }
        return null;
    }

    class PointMark {
        private double position;
        private LinearReferencedPointMarkPHandle pHandle;

        PointMark(double position, LinearReferencedPointMarkPHandle handle) {
            this.pHandle = handle;
            this.position = position;
        }

        public double getPosition() {
            return this.position;
        }

        public LinearReferencedPointMarkPHandle getPHandle() {
            return this.pHandle;
        }
    }

    public static enum Modus {
        MARK_SELECTION,
        MARK_ADD,
        MEASUREMENT;

    }
}

