/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeregistrationListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.GeometryCheckInterface;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.InvalidPolygonTooltip;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RubberBandZoomListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureDeleteAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureRemoveEntityAction;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureRemoveHoleAction;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.openide.util.Lookup;

public class CreateNewGeometryListener
extends CreateGeometryListener
implements DeregistrationListener {
    private static final Logger LOG = Logger.getLogger(CreateNewGeometryListener.class);
    private static Collection<? extends GeometryCheckInterface> geometryChecks = Lookup.getDefault().lookupAll(GeometryCheckInterface.class);
    private final PBasicInputEventHandler zoomDelegate;
    private PFeature selectedPFeature = null;
    private int selectedEntityPosition = -1;
    private boolean creatingHole = false;
    private InvalidPolygonTooltip multiPolygonPointerAnnotation = new InvalidPolygonTooltip();

    public CreateNewGeometryListener(MappingComponent mc) {
        this(mc, PureNewFeature.class);
    }

    private CreateNewGeometryListener(MappingComponent mc, Class geometryFeatureClass) {
        super(mc, geometryFeatureClass);
        this.zoomDelegate = new RubberBandZoomListener();
        mc.getCamera().addChild((PNode)this.multiPolygonPointerAnnotation);
    }

    @Override
    protected Color getFillingColor() {
        return new Color(1.0f, 0.0f, 0.0f, 0.5f);
    }

    private Point getMousePoint(Point2D mousePosition) {
        WorldToScreenTransform wtst = this.getMappingComponent().getWtst();
        double mouseCoordX = wtst.getSourceX(mousePosition.getX() - this.getMappingComponent().getClip_offset_x());
        double mouseCoordY = wtst.getSourceY(mousePosition.getY() - this.getMappingComponent().getClip_offset_y());
        Coordinate mouseCoord = new Coordinate(mouseCoordX, mouseCoordY);
        int currentSrid = CrsTransformer.extractSridFromCrs(this.getMappingComponent().getMappingModel().getSrs().getCode());
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), currentSrid);
        Point mousePoint = CrsTransformer.transformToGivenCrs(geometryFactory.createPoint(mouseCoord), CrsTransformer.createCrsFromSrid(this.selectedPFeature.getFeature().getGeometry().getSRID()));
        return mousePoint;
    }

    @Override
    public void mousePressed(PInputEvent pInputEvent) {
        AbstractNewFeature tempFeature = this.getCurrentNewFeature();
        if (tempFeature != null && pInputEvent.getClickCount() == 1) {
            Geometry tempGeometry = tempFeature.getGeometry();
            if (geometryChecks != null && !geometryChecks.isEmpty()) {
                Point2D lastPoint = pInputEvent.getPosition();
                WorldToScreenTransform wtst = this.mappingComponent.getWtst();
                Coordinate lastCoordinate = new Coordinate(wtst.getSourceX((float)lastPoint.getX()), wtst.getSourceY((float)lastPoint.getY()));
                boolean ignoreLastGeometryCoordinate = false;
                if (this.points.size() < tempGeometry.getCoordinates().length) {
                    ignoreLastGeometryCoordinate = true;
                }
                for (GeometryCheckInterface geometryCheckInterface : geometryChecks) {
                    if (geometryCheckInterface.check(tempGeometry, lastCoordinate, ignoreLastGeometryCoordinate)) continue;
                    return;
                }
            }
        }
        this.multiPolygonPointerAnnotation.setVisible(false);
        if (pInputEvent.isLeftMouseButton()) {
            if (pInputEvent.getClickCount() == 1) {
                if (!this.isInProgress()) {
                    if (pInputEvent.isAltDown() && (this.isInMode("POLYGON") || this.isInMode("ELLIPSE") || this.isInMode("BOUNDING_BOX") || this.isInMode("RECTANGLE_FROM_LINE"))) {
                        PFeature pFeature;
                        Collection selectedFeatures = this.getMappingComponent().getFeatureCollection().getSelectedFeatures();
                        if (this.selectedPFeature != null && selectedFeatures.size() == 1) {
                            pFeature = this.getMappingComponent().getPFeatureHM().get((Feature)selectedFeatures.toArray()[0]);
                            if (pFeature != null && (pFeature.getFeature().getGeometry() instanceof MultiPolygon || pFeature.getFeature().getGeometry() instanceof Polygon)) {
                                Point mousePoint = this.getMousePoint(pInputEvent.getPosition());
                                this.selectedEntityPosition = pFeature.getEntityPositionUnderPoint(mousePoint);
                                this.creatingHole = this.selectedEntityPosition != -1;
                                super.mousePressed(pInputEvent);
                            }
                        } else {
                            pFeature = (PFeature)PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true);
                            if (pFeature != null && (pFeature.getFeature().getGeometry() instanceof MultiPolygon || pFeature.getFeature().getGeometry() instanceof Polygon)) {
                                this.getMappingComponent().getFeatureCollection().select(pFeature.getFeature());
                                this.selectedPFeature = pFeature;
                            }
                        }
                    } else if (this.isInMode("TEXT")) {
                        super.mousePressed(pInputEvent);
                    } else {
                        this.selectedPFeature = null;
                        super.mousePressed(pInputEvent);
                    }
                } else {
                    super.mousePressed(pInputEvent);
                }
            } else if (pInputEvent.getClickCount() == 2) {
                if (this.selectedPFeature == null || this.isTempFeatureValid()) {
                    super.mousePressed(pInputEvent);
                }
            } else {
                super.mousePressed(pInputEvent);
            }
        } else {
            this.selectedPFeature = null;
            super.mousePressed(pInputEvent);
        }
    }

    private boolean isTempFeatureValid() {
        AbstractNewFeature tempFeature = this.getCurrentNewFeature();
        Coordinate[] tempFeatureCoordinates = tempFeature.getGeometry().getCoordinates();
        if (tempFeatureCoordinates.length == 3) {
            int currentSrid = this.selectedPFeature.getFeature().getGeometry().getSRID();
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), currentSrid);
            Point point = geometryFactory.createPoint(tempFeatureCoordinates[1]);
            if (this.creatingHole) {
                return this.selectedPFeature.getEntityPositionUnderPoint(point) == this.selectedEntityPosition;
            }
            return this.selectedPFeature.getEntityPositionUnderPoint(point) == -1;
        }
        if (this.creatingHole) {
            return this.selectedPFeature.isValidWithThisNewHoleCoordinates(this.selectedEntityPosition, tempFeatureCoordinates);
        }
        return this.selectedPFeature.isValidWithThisNewEntityCoordinates(tempFeatureCoordinates);
    }

    @Override
    protected void reset() {
        super.reset();
        this.selectedPFeature = null;
        this.selectedEntityPosition = -1;
        this.creatingHole = false;
    }

    @Override
    public void mouseMoved(PInputEvent pInputEvent) {
        super.mouseMoved(pInputEvent);
        if (this.isInMode("POLYGON") || this.isInMode("ELLIPSE") || this.isInMode("BOUNDING_BOX") || this.isInMode("RECTANGLE_FROM_LINE")) {
            this.multiPolygonPointerAnnotation.setOffset(pInputEvent.getCanvasPosition().getX() + 20.0, pInputEvent.getCanvasPosition().getY() + 20.0);
            Collection selectedFeatures = this.getMappingComponent().getFeatureCollection().getSelectedFeatures();
            if (this.selectedPFeature == null || selectedFeatures.size() != 1) {
                if (pInputEvent.isAltDown()) {
                    this.multiPolygonPointerAnnotation.setMode(InvalidPolygonTooltip.Mode.SELECT_FEATURE);
                    this.multiPolygonPointerAnnotation.setVisible(true);
                } else {
                    this.multiPolygonPointerAnnotation.setVisible(false);
                }
            } else if (this.isInProgress()) {
                if (!this.isTempFeatureValid()) {
                    if (this.creatingHole) {
                        this.multiPolygonPointerAnnotation.setMode(InvalidPolygonTooltip.Mode.HOLE_ERROR);
                    } else {
                        this.multiPolygonPointerAnnotation.setMode(InvalidPolygonTooltip.Mode.ENTITY_ERROR);
                    }
                    this.multiPolygonPointerAnnotation.setVisible(true);
                } else {
                    this.multiPolygonPointerAnnotation.setVisible(false);
                }
            } else {
                this.multiPolygonPointerAnnotation.setVisible(false);
            }
        } else {
            this.multiPolygonPointerAnnotation.setVisible(false);
            AbstractNewFeature tempFeature = this.getCurrentNewFeature();
            if (tempFeature != null) {
                Geometry tempGeometry = tempFeature.getGeometry();
                boolean errorFound = false;
                if (geometryChecks != null && !geometryChecks.isEmpty()) {
                    Point2D lastPoint = pInputEvent.getPosition();
                    WorldToScreenTransform wtst = this.mappingComponent.getWtst();
                    Coordinate lastCoordinate = new Coordinate(wtst.getSourceX(lastPoint.getX()), wtst.getSourceY(lastPoint.getY()));
                    for (GeometryCheckInterface geometryCheckInterface : geometryChecks) {
                        if (geometryCheckInterface.check(tempGeometry, lastCoordinate, true)) continue;
                        this.multiPolygonPointerAnnotation.removeAllChildren();
                        this.multiPolygonPointerAnnotation.setCustomText("Geometrie ung\u00fcltig", geometryCheckInterface.getErrorText());
                        errorFound = true;
                    }
                }
                if (errorFound) {
                    this.multiPolygonPointerAnnotation.setOffset(pInputEvent.getCanvasPosition().getX() + 20.0, pInputEvent.getCanvasPosition().getY() + 20.0);
                }
                this.multiPolygonPointerAnnotation.setVisible(errorFound);
            }
        }
    }

    @Override
    protected void finishGeometry(AbstractNewFeature newFeature) {
        super.finishGeometry(newFeature);
        if (newFeature != null) {
            if (this.selectedPFeature == null) {
                newFeature.setEditable(true);
                this.getMappingComponent().getFeatureCollection().addFeature(newFeature);
                this.getMappingComponent().getFeatureCollection().holdFeature(newFeature);
                PNotificationCenter pn = PNotificationCenter.defaultCenter();
                pn.postNotification("GEOMETRY_CREATED_NOTIFICATION", (Object)newFeature);
                this.getMappingComponent().getMemUndo().addAction(new FeatureDeleteAction(this.getMappingComponent(), newFeature));
                this.getMappingComponent().getMemRedo().clear();
            } else {
                Polygon polygon = (Polygon)newFeature.getGeometry();
                if (this.creatingHole) {
                    this.selectedPFeature.addHoleToEntity(this.selectedEntityPosition, polygon.getExteriorRing());
                    this.getMappingComponent().getMemUndo().addAction(new FeatureRemoveHoleAction(this.getMappingComponent(), this.selectedPFeature.getFeature(), this.selectedEntityPosition, polygon.getExteriorRing()));
                } else {
                    this.selectedPFeature.addEntity(polygon);
                    this.getMappingComponent().getMemUndo().addAction(new FeatureRemoveEntityAction(this.mappingComponent, this.selectedPFeature.getFeature(), polygon));
                }
                this.getMappingComponent().getMemRedo().clear();
            }
        }
    }

    public void mouseWheelRotated(PInputEvent pie) {
        this.zoomDelegate.mouseWheelRotated(pie);
        this.mouseMoved(pie);
    }

    @Override
    public void deregistration() {
        if (this.multiPolygonPointerAnnotation != null && this.multiPolygonPointerAnnotation.getVisible()) {
            this.multiPolygonPointerAnnotation.setVisible(false);
        }
    }
}

