/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureDeleteAction;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CreateSimpleGeometryListener
extends PBasicInputEventHandler {
    public static final String GEOMETRY_CREATED_NOTIFICATION = "GEOMETRY_CREATED_NOTIFICATION";
    protected Point2D startPoint;
    protected PPath tempFeature;
    protected MappingComponent mc;
    protected boolean inProgress;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Vector<Point2D> points;
    private PureNewFeature newFeature = null;

    public CreateSimpleGeometryListener(MappingComponent mc) {
        this.mc = mc;
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        super.mouseMoved(pInputEvent);
    }

    public void mousePressed(PInputEvent pInputEvent) {
        super.mouseClicked(pInputEvent);
        if (!this.inProgress) {
            this.initTempFeature(true);
            this.startPoint = pInputEvent.getPosition();
        }
    }

    private void createPureNewFeature(AbstractNewFeature.geomTypes geomType) {
        try {
            Point2D[] p = this.points.toArray(new Point2D[0]);
            PureNewFeature pnf = new PureNewFeature(p, this.mc.getWtst());
            pnf.setGeometryType(geomType);
            this.finishGeometry(pnf);
        }
        catch (Throwable t) {
            this.log.error((Object)"Error during the creation of the geometry", t);
        }
        this.inProgress = false;
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        super.mouseReleased(pInputEvent);
        if (pInputEvent.isLeftMouseButton()) {
            if (this.inProgress) {
                this.createPureNewFeature(AbstractNewFeature.geomTypes.RECTANGLE);
            } else if (pInputEvent.getClickCount() == 1) {
                Point2D point = pInputEvent.getPosition();
                this.points = new Vector();
                this.points.add(point);
                this.createPureNewFeature(AbstractNewFeature.geomTypes.POINT);
            }
        }
    }

    private void createAction(MappingComponent m, PureNewFeature f) {
        this.mc.getMemUndo().addAction(new FeatureDeleteAction(m, f));
        this.mc.getMemRedo().clear();
    }

    protected Color getFillingColor() {
        return new Color(1.0f, 1.0f, 1.0f, 0.4f);
    }

    protected void updatePolygon(Point2D lastPoint) {
        Point2D[] p = this.points.toArray(new Point2D[0]);
        this.tempFeature.setPathToPolyline(p);
        this.tempFeature.repaint();
    }

    private void postGeometryCreatedNotificaton(PureNewFeature newFeature) {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(GEOMETRY_CREATED_NOTIFICATION, (Object)this);
    }

    protected void finishGeometry(PureNewFeature newFeature) {
        this.mc.getTmpFeatureLayer().removeAllChildren();
        this.newFeature = newFeature;
        this.postGeometryCreatedNotificaton(newFeature);
        this.createAction(this.mc, newFeature);
    }

    private void initTempFeature(boolean filled) {
        this.tempFeature = new PPath();
        this.tempFeature.setStroke((Stroke)new FixedWidthStroke());
        if (filled) {
            Color fillingColor = this.getFillingColor();
            this.tempFeature.setStrokePaint((Paint)fillingColor.darker());
            this.tempFeature.setPaint((Paint)fillingColor);
        }
        this.mc.getTmpFeatureLayer().addChild((PNode)this.tempFeature);
    }

    public PureNewFeature getNewFeature() {
        return this.newFeature;
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        super.mouseDragged(pInputEvent);
        if (this.startPoint == null) {
            this.startPoint = pInputEvent.getPosition();
        }
        this.inProgress = true;
        this.points = new Vector(5);
        this.points.add(this.startPoint);
        this.points.add(new Point2D.Double(this.startPoint.getX(), pInputEvent.getPosition().getY()));
        this.points.add(pInputEvent.getPosition());
        this.points.add(new Point2D.Double(pInputEvent.getPosition().getX(), this.startPoint.getY()));
        this.points.add(this.startPoint);
        this.updatePolygon(null);
    }
}

