/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.RequestForHidingHandles;
import de.cismet.cismap.commons.features.RequestNoAutoSelectionWhenMoving;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PHandle;
import de.cismet.cismap.commons.gui.piccolo.PivotPHandle;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelfManipulatingFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.FeatureMoveAction;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import edu.umd.cs.piccolox.util.PLocator;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FeatureMoveListener
extends PBasicInputEventHandler {
    public static final String SELECTION_CHANGED_NOTIFICATION = "SELECTION_CHANGED_NOTIFICATION_FEATUREMOVE";
    protected Point2D pressPoint;
    protected Point2D dragPoint;
    protected PDimension dragDim;
    protected PFeature pFeature;
    protected MappingComponent mc;
    protected Vector features = new Vector();
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private boolean ctrlPressed = false;
    private boolean drag = false;
    private final PLayer handleLayer;

    public FeatureMoveListener(MappingComponent mc) {
        this.mc = mc;
        this.handleLayer = mc.getHandleLayer();
    }

    public void mousePressed(PInputEvent e) {
        super.mousePressed(e);
        if (!this.ctrlPressed(e)) {
            this.unmarkFeatures();
        }
        if (e.isLeftMouseButton()) {
            this.pressPoint = e.getPosition();
            this.dragDim = e.getCanvasDelta();
            this.dragPoint = this.pressPoint;
            PNode o = PFeatureTools.getFirstValidObjectUnderPointer(e, new Class[]{PFeature.class}, true);
            if (o instanceof PFeature) {
                this.pFeature = (PFeature)o;
                if (this.pFeature.getFeature().isEditable() && this.pFeature.getFeature().canBeSelected() || this.pFeature.getFeature() instanceof LinearReferencedLineFeature) {
                    this.pFeature = (PFeature)o;
                    this.pFeature.setStrokePaint(Color.red);
                    if (!this.features.contains(this.pFeature)) {
                        this.features.add(this.pFeature);
                        this.pFeature.moveToFront();
                    }
                    if (!(this.pFeature.isSelected() && this.mc.getFeatureCollection().getSelectedFeatures().size() == 1 || this.pFeature.getFeature() instanceof RequestNoAutoSelectionWhenMoving)) {
                        this.mc.getFeatureCollection().unselectAll();
                        this.mc.getFeatureCollection().select(this.pFeature.getFeature());
                        this.postSelectionChanged();
                    }
                }
            } else {
                this.pFeature = null;
            }
        }
    }

    public void mouseDragged(PInputEvent e) {
        if (this.pFeature != null && (this.handleLayer.getChildrenCount() > 0 || this.pFeature.getFeature() instanceof RequestForHidingHandles)) {
            this.drag = true;
            super.mouseDragged(e);
            if (this.pFeature != null) {
                this.dragPoint = e.getPosition();
                Feature feat = this.pFeature.getFeature();
                if (feat instanceof SelfManipulatingFeature) {
                    SelfManipulatingFeature smFeature = (SelfManipulatingFeature)((Object)feat);
                    Coordinate coord = new Coordinate(this.mc.getWtst().getSourceX(this.dragPoint.getX()), this.mc.getWtst().getSourceY(this.dragPoint.getY()));
                    PDimension delta = e.getDelta();
                    smFeature.moveTo(coord, delta);
                } else {
                    PDimension delta = e.getCanvasDelta();
                    this.dragDim.setSize(this.dragDim.getWidth() - e.getCanvasDelta().getWidth(), this.dragDim.getHeight() - e.getCanvasDelta().getHeight());
                    for (Object o : this.features) {
                        if (!(o instanceof PFeature)) continue;
                        PFeature f = (PFeature)o;
                        f.moveFeature(delta);
                    }
                    double scale = this.mc.getCamera().getViewScale();
                    for (int i = 0; i < this.handleLayer.getChildrenCount(); ++i) {
                        PNode child = this.handleLayer.getChild(i);
                        if (child instanceof PivotPHandle) {
                            PivotPHandle pivotHandle = (PivotPHandle)child;
                            PLocator pLocator = pivotHandle.getLocator();
                            Point2D.Double newMid = new Point2D.Double(pLocator.locateX() + delta.getWidth() / scale, pLocator.locateY() + delta.getHeight() / scale);
                            pivotHandle.getMid().setLocation(newMid);
                        }
                        if (!(child instanceof PHandle)) continue;
                        PHandle pHandle = (PHandle)child;
                        pHandle.relocateHandle();
                    }
                }
                this.mc.syncSelectedObjectPresenter(0);
            }
        }
    }

    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        if (this.pFeature != null && this.drag) {
            this.drag = false;
            Feature feat = this.pFeature.getFeature();
            if (feat instanceof SelfManipulatingFeature) {
                ((SelfManipulatingFeature)((Object)feat)).moveFinished();
            }
            this.mc.getMemUndo().addAction(new FeatureMoveAction(this.mc, this.features, this.dragDim, true));
            this.mc.getMemRedo().clear();
            for (Object o : this.features) {
                if (!(o instanceof PFeature)) continue;
                PFeature f = (PFeature)o;
                if (this.mc.getFeatureCollection() instanceof DefaultFeatureCollection && !(this.pFeature.getFeature() instanceof RequestNoAutoSelectionWhenMoving)) {
                    Vector<Feature> v = new Vector<Feature>();
                    v.add(f.getFeature());
                    ((DefaultFeatureCollection)this.mc.getFeatureCollection()).fireFeaturesChanged(v);
                    continue;
                }
                this.mc.getFeatureCollection().reconsiderFeature(f.getFeature());
            }
            this.mc.showHandles(false);
        }
        if (!this.ctrlPressed(e)) {
            this.unmarkFeatures();
        }
    }

    private void postSelectionChanged() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(SELECTION_CHANGED_NOTIFICATION, (Object)this);
    }

    public void mouseMoved(PInputEvent event) {
        super.mouseMoved(event);
        if (!this.ctrlPressed(event)) {
            this.unmarkFeatures();
        }
    }

    private boolean ctrlPressed(PInputEvent event) {
        return (event.getModifiers() & 2) != 0;
    }

    private void unmarkFeatures() {
        for (Object o : this.features) {
            PFeature f;
            if (!(o instanceof PFeature) || !((f = (PFeature)o).getFeature() instanceof AbstractNewFeature)) continue;
            f.setStrokePaint(Color.black);
        }
        this.features = new Vector();
    }

    public void cleanup() {
        this.pFeature = null;
        this.features.clear();
    }
}

