/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionAdapter;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DrawSelectionFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelfManipulatingFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class LinearReferencedLineFeature
extends DefaultStyledFeature
implements DrawSelectionFeature,
XStyledFeature,
SelfManipulatingFeature {
    public static final Color DEFAULT_COLOR = new Color(255, 91, 0);
    public static final boolean FROM = true;
    public static final boolean TO = false;
    private static final Logger LOG = Logger.getLogger(LinearReferencedLineFeature.class);
    private static final ImageIcon ico = new ImageIcon(LinearReferencedLineFeature.class.getResource("/de/cismet/cismap/commons/gui/res/linRefPointIcon.png"));
    private LinearReferencedPointFeature fromFeature;
    private LinearReferencedPointFeature toFeature;
    private Geometry baseLineGeom;
    private FeatureCollectionListener featureCollectionListener;
    private boolean featCollLock = false;
    private LinearReferencedPointFeatureHandler fromPointListener;
    private LinearReferencedPointFeatureHandler toPointListener;

    public LinearReferencedLineFeature(LinearReferencedPointFeature fromFeature, LinearReferencedPointFeature toFeature) {
        this.baseLineGeom = fromFeature.getLineGeometry();
        this.setLineWidth(4);
        this.setLinePaint(DEFAULT_COLOR);
        this.setPrimaryAnnotationVisible(false);
        this.fromPointListener = new LinearReferencedPointFeatureHandler(true);
        this.toPointListener = new LinearReferencedPointFeatureHandler(false);
        this.initFeatureCollectionListener();
        this.setPointFeature(fromFeature, true);
        this.setPointFeature(toFeature, false);
    }

    public final void setPointFeature(LinearReferencedPointFeature pointFeature, boolean isFrom) {
        LinearReferencedPointFeatureHandler listener;
        LinearReferencedPointFeature oldFeature = isFrom ? this.fromFeature : this.toFeature;
        LinearReferencedPointFeatureHandler linearReferencedPointFeatureHandler = listener = isFrom ? this.fromPointListener : this.toPointListener;
        if (oldFeature != null) {
            oldFeature.removeListener(listener);
        }
        if (pointFeature != null) {
            pointFeature.addListener(listener);
        }
        if (isFrom) {
            this.fromFeature = pointFeature;
        } else {
            this.toFeature = pointFeature;
        }
        this.updateGeometry();
    }

    public LinearReferencedPointFeature getPointFeature(boolean isFrom) {
        return isFrom ? this.fromFeature : this.toFeature;
    }

    @Override
    public void setLinePaint(Paint linePaint) {
        super.setLinePaint(linePaint);
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        PFeature pFeature = mc.getPFeatureHM().get(this);
        if (pFeature != null) {
            pFeature.visualize();
        }
    }

    private void initFeatureCollectionListener() {
        this.featureCollectionListener = new FeatureCollectionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                Collection<Feature> features = fce.getEventFeatures();
                FeatureCollection collection = CismapBroker.getInstance().getMappingComponent().getFeatureCollection();
                if (!LinearReferencedLineFeature.this.featCollLock) {
                    LinearReferencedLineFeature.this.featCollLock = true;
                    try {
                        boolean addFeaturesToCollection = false;
                        if (features != null) {
                            for (Feature feature : features) {
                                if (!collection.isSelected(feature) || !(feature instanceof LinearReferencedLineFeature) || (LinearReferencedLineFeature)feature != LinearReferencedLineFeature.this) continue;
                                addFeaturesToCollection = true;
                            }
                        }
                        if (addFeaturesToCollection) {
                            collection.addToSelection(LinearReferencedLineFeature.this.fromFeature);
                            collection.addToSelection(LinearReferencedLineFeature.this.toFeature);
                        }
                    }
                    finally {
                        LinearReferencedLineFeature.this.featCollLock = false;
                    }
                }
            }
        };
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(this.featureCollectionListener);
    }

    public static Geometry createSubline(double von, double bis, Geometry auf) {
        LengthIndexedLine lil = new LengthIndexedLine(auf);
        return lil.extractLine(von, bis);
    }

    public final void updateGeometry() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"update Geometry");
        }
        if (this.fromFeature != null && this.toFeature != null) {
            Geometry sublineGeom;
            this.baseLineGeom = this.fromFeature.getLineGeometry();
            if (this.fromFeature != this.toFeature) {
                double to;
                double from = this.fromFeature.getCurrentPosition();
                if (from == (to = this.toFeature.getCurrentPosition())) {
                    if (from >= 1.0) {
                        from -= 1.0;
                    } else {
                        to += 1.0;
                    }
                }
                sublineGeom = LinearReferencedLineFeature.createSubline(from, to, this.baseLineGeom);
            } else {
                sublineGeom = this.fromFeature.getGeometry();
            }
            this.setGeometry(sublineGeom);
            MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            PFeature pFeature = mc.getPFeatureHM().get(this);
            if (pFeature != null) {
                pFeature.setCoordArr(0, 0, sublineGeom.getCoordinates());
                pFeature.updatePath();
                pFeature.syncGeometry();
                pFeature.visualize();
            }
        }
    }

    @Override
    public ImageIcon getIconImage() {
        return ico;
    }

    @Override
    public String getName() {
        return "Stationierte Linie";
    }

    @Override
    public String getType() {
        return "Stationierte Linie";
    }

    @Override
    public JComponent getInfoComponent(Refreshable refresh) {
        return null;
    }

    @Override
    public Stroke getLineStyle() {
        return null;
    }

    @Override
    public boolean isDrawingSelection() {
        return false;
    }

    @Override
    public synchronized void moveTo(Coordinate coord, PDimension delta) {
        Geometry originFromGeom = this.fromFeature.getGeometry();
        double fromX = this.fromFeature.getGeometry().getCoordinate().x;
        double fromY = this.fromFeature.getGeometry().getCoordinate().y;
        Coordinate fromCoord = new Coordinate(fromX + delta.getWidth(), fromY - delta.getHeight());
        Geometry originToGeom = this.toFeature.getGeometry();
        double length = this.toFeature.getCurrentPosition() - this.fromFeature.getCurrentPosition();
        try {
            this.fromFeature.moveTo(fromCoord, delta);
            this.toFeature.moveToPosition(this.fromFeature.getCurrentPosition() + length);
        }
        catch (TopologyException e) {
            this.toFeature.moveTo(originToGeom.getCoordinate(), delta);
            this.fromFeature.moveTo(originFromGeom.getCoordinate(), delta);
        }
        double newLength = this.toFeature.getCurrentPosition() - this.fromFeature.getCurrentPosition();
        if (Math.abs(length - newLength) > 0.1) {
            this.fromFeature.setGeometry(originFromGeom);
            this.toFeature.setGeometry(originToGeom);
        }
    }

    @Override
    public void moveFinished() {
        this.fromFeature.moveFinished();
        this.toFeature.moveFinished();
    }

    class LinearReferencedPointFeatureHandler
    implements LinearReferencedPointFeatureListener {
        private boolean isFrom;

        LinearReferencedPointFeatureHandler(boolean isFrom) {
            this.isFrom = isFrom;
        }

        @Override
        public void featureMerged(LinearReferencedPointFeature mergePoint, LinearReferencedPointFeature withPoint) {
            LinearReferencedLineFeature.this.setPointFeature(withPoint, this.isFrom);
            LinearReferencedLineFeature.this.updateGeometry();
        }

        @Override
        public void featureMoved(LinearReferencedPointFeature pointFeature) {
            LinearReferencedLineFeature.this.updateGeometry();
        }
    }
}

