/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.FeatureMoveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintTemplateFeature;
import de.cismet.cismap.commons.gui.printing.PrintingToolTip;
import de.cismet.cismap.commons.gui.printing.Resolution;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.printing.Template;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.PFeatureTools;
import de.cismet.tools.CismetThreadPool;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PrintingTemplatePreviewListener
extends FeatureMoveListener {
    private static final Logger log = Logger.getLogger(PrintingTemplatePreviewListener.class);
    public static final String WIDTH = "WIDTH";
    public static final String HEIGHT = "HEIGHT";
    public static final Color BORDER_COLOR = new Color(0, 0, 255, 75);
    Thread zoomThread;
    long zoomTime;
    private final PropertyChangeListener mapInteractionModeListener;
    private final MappingComponent mappingComponent;
    private final List<? extends Feature> backupFeature;
    private final List<? extends Feature> backupHoldFeature;
    private final PrintingToolTip PRINTING_TOOLTIP = new PrintingToolTip(new Color(255, 255, 222, 200));
    private boolean cleared = true;
    private String oldInteractionMode;
    private PrintTemplateFeature printTemplateStyledFeature;
    private boolean oldOverlappingCheck = true;

    public PrintingTemplatePreviewListener(MappingComponent mappingComponent) {
        super(mappingComponent);
        this.mappingComponent = mappingComponent;
        this.backupFeature = new ArrayList<Feature>();
        this.backupHoldFeature = new ArrayList<Feature>();
        this.oldInteractionMode = "PAN";
        this.mapInteractionModeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt != null && "INTERACTION_MODE".equals(evt.getPropertyName()) && "PRINTING_AREA_SELECTION".equals(evt.getOldValue())) {
                    PrintingTemplatePreviewListener.this.cleanUpAndRestoreFeatures();
                }
            }
        };
    }

    public String getOldInteractionMode() {
        return this.oldInteractionMode;
    }

    public void setOldInteractionMode(String oldInteractionMode) {
        this.oldInteractionMode = oldInteractionMode;
    }

    private void zoom(double scale, PrintTemplateFeature printingTemplate) {
        Point centroid = printingTemplate.getGeometry().getCentroid();
        AffineTransformation at = AffineTransformation.scaleInstance((double)scale, (double)scale, (double)centroid.getX(), (double)centroid.getY());
        Geometry g = at.transform(printingTemplate.getGeometry());
        printingTemplate.setGeometry(g);
        PFeature printPFeature = this.mappingComponent.getPFeatureHM().get(printingTemplate);
        printPFeature.visualize();
        this.mappingComponent.showHandles(true);
    }

    public void init() {
        this.mappingComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.mappingComponent.setPointerAnnotation(this.PRINTING_TOOLTIP);
        this.mappingComponent.setPointerAnnotationVisibility(true);
        String currentInteractionMode = this.mappingComponent.getInteractionMode();
        if (!"PRINTING_AREA_SELECTION".equals(currentInteractionMode)) {
            this.oldInteractionMode = currentInteractionMode;
            this.mappingComponent.addPropertyChangeListener(this.mapInteractionModeListener);
        }
        this.mappingComponent.setInteractionMode("PRINTING_AREA_SELECTION");
        this.cleared = false;
        this.mappingComponent.setCursor(Cursor.getPredefinedCursor(12));
        this.mappingComponent.setPointerAnnotation(this.PRINTING_TOOLTIP);
        this.mappingComponent.setPointerAnnotationVisibility(true);
    }

    public void init(Scale selectedScale, Resolution selectedResolution, Template selectedTemplate, String oldInteractionMode) {
        this.init();
        this.oldInteractionMode = oldInteractionMode;
        this.printTemplateStyledFeature = new PrintTemplateFeature(selectedTemplate, selectedResolution, selectedScale, this.mappingComponent);
        DefaultFeatureCollection mapFeatureCol = (DefaultFeatureCollection)this.mappingComponent.getFeatureCollection();
        this.oldOverlappingCheck = CismapBroker.getInstance().isCheckForOverlappingGeometriesAfterFeatureRotation();
        CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(false);
        mapFeatureCol.holdFeature(this.printTemplateStyledFeature);
        mapFeatureCol.addFeature(this.printTemplateStyledFeature);
        this.adjustMap();
        mapFeatureCol.select(this.printTemplateStyledFeature);
        this.mappingComponent.setHandleInteractionMode("ROTATE_POLYGON");
        this.mappingComponent.showHandles(false);
    }

    private void ensureVisibilityOfPrintingTemplates() {
        if (!this.mappingComponent.isFixedMapExtent()) {
            this.mappingComponent.zoomToAFeatureCollection(this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class), false, this.mappingComponent.isFixedMapScale());
        }
    }

    @Override
    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        this.ensureVisibilityOfPrintingTemplates();
    }

    @Override
    public void mouseMoved(PInputEvent event) {
        if (event.getPickedNode() instanceof PrintTemplateFeature.DerivedCloneArea) {
            this.mappingComponent.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.mappingComponent.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseWheelRotated(PInputEvent event) {
        super.mouseWheelRotatedByBlock(event);
        PNode o = PFeatureTools.getFirstValidObjectUnderPointer(event, new Class[]{PFeature.class}, true);
        if (!(o instanceof PFeature)) {
            return;
        }
        PFeature sel = (PFeature)o;
        if (!(sel.getFeature() instanceof PrintTemplateFeature)) {
            return;
        }
        PrintTemplateFeature ptf = (PrintTemplateFeature)sel.getFeature();
        if (ptf.getScale().getDenominator() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)event.getWheelRotation());
            }
            if (event.getWheelRotation() < 0) {
                this.zoom(0.9, ptf);
                this.adjustMap();
            } else {
                this.zoom(1.1, ptf);
                this.adjustMap();
            }
        }
    }

    public void cleanUpAndRestoreFeatures() {
    }

    public void adjustMap() {
        int delayTime = 500;
        this.zoomTime = System.currentTimeMillis() + 500L;
        if (this.zoomThread == null || !this.zoomThread.isAlive()) {
            this.zoomThread = new Thread("PrintFrameListener adjustMap()"){

                @Override
                public void run() {
                    while (System.currentTimeMillis() < PrintingTemplatePreviewListener.this.zoomTime) {
                        try {
                            2.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PrintingTemplatePreviewListener.this.ensureVisibilityOfPrintingTemplates();
                        }
                    });
                }
            };
            this.zoomThread.setPriority(5);
            CismetThreadPool.execute((Runnable)this.zoomThread);
        }
    }
}

