/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.features.ChildNodesProvider;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.RequestForHidingHandles;
import de.cismet.cismap.commons.features.RequestForNonreflectingFeature;
import de.cismet.cismap.commons.features.RequestForRotatingPivotLock;
import de.cismet.cismap.commons.features.RequestForUnaddableHandles;
import de.cismet.cismap.commons.features.RequestForUnmoveableHandles;
import de.cismet.cismap.commons.features.RequestForUnremovableHandles;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DeriveRule;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DerivedFixedPImage;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.georeferencing.PointCoordinatePair;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandlerListener;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizard;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizardListener;
import edu.umd.cs.piccolo.PNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RasterGeoRefFeature
extends DefaultStyledFeature
implements XStyledFeature,
ChildNodesProvider,
RequestForUnaddableHandles,
RequestForUnmoveableHandles,
RequestForUnremovableHandles,
RequestForRotatingPivotLock,
RequestForNonreflectingFeature,
RequestForHidingHandles,
RasterGeoReferencingHandlerListener,
RasterGeoReferencingWizardListener {
    private static final BufferedImage GEOREF_DOT_IMAGE;
    private static final BufferedImage GEOREF_CROSS_IMAGE;
    private static final ImageIcon GEOREF_ICON;
    private static final transient Logger LOG;
    private final ArrayList<PNode> children = new ArrayList();
    private final RasterGeoReferencingHandler handler;
    private boolean refreshing;

    public RasterGeoRefFeature(final RasterGeoReferencingHandler handler) {
        this.handler = handler;
        this.getHandler().addListener(this);
        RasterGeoReferencingWizard.getInstance().addListener(this);
        this.updateGeometry();
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){
            boolean ignoreSelection = false;

            @Override
            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            @Override
            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            @Override
            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            @Override
            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            @Override
            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                if (fce != null && fce.getEventFeatures() != null && fce.getEventFeatures().contains(RasterGeoRefFeature.this) && fce.getFeatureCollection().getSelectedFeatures().contains(RasterGeoRefFeature.this) && !this.ignoreSelection) {
                    this.ignoreSelection = true;
                    try {
                        RasterGeoReferencingWizard.getInstance().setHandler(handler);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().select(handler.getFeature());
                    }
                    finally {
                        this.ignoreSelection = false;
                    }
                }
            }

            @Override
            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            @Override
            public void featureCollectionChanged() {
            }
        });
    }

    private void updateGeometry() {
        Rectangle envelope = this.getHandler().getMetaData().getImageBounds();
        AffineTransformation transform = this.getHandler().getMetaData().getTransform();
        if (envelope != null && transform != null) {
            Coordinate upperLeftCoordinate = transform.transform(new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate());
            Coordinate upperRightCoordinate = transform.transform(new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate());
            Coordinate lowerRightCoordinate = transform.transform(new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate());
            Coordinate lowerLeftCoordinate = transform.transform(new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate());
            Coordinate[] coordinates = new Coordinate[]{upperLeftCoordinate, upperRightCoordinate, lowerRightCoordinate, lowerLeftCoordinate, upperLeftCoordinate};
            GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
            LinearRing linear = factory.createLinearRing(coordinates);
            this.setGeometry((Geometry)factory.createPolygon(linear, null));
        }
    }

    @Override
    public ImageIcon getIconImage() {
        return GEOREF_ICON;
    }

    @Override
    public String getType() {
        return "RasterGeoRef";
    }

    @Override
    public JComponent getInfoComponent(Refreshable refresh) {
        return null;
    }

    @Override
    public Stroke getLineStyle() {
        return null;
    }

    @Override
    public String getName() {
        return this.getHandler().getService().getName();
    }

    private void init(PFeature parent) {
        if ("GEO_REF".equals(CismapBroker.getInstance().getMappingComponent().getInteractionMode())) {
            int numOfPairs = this.getHandler().getPairs().length;
            for (int position = 0; position < numOfPairs; ++position) {
                this.addPointChild(parent, position);
                this.addCoordinateChild(parent, position);
            }
        }
    }

    private void addCoordinateChild(PFeature parent, int position) {
        final PointCoordinatePair pair = this.getHandler().getPair(position);
        if (pair != null && pair.getCoordinate() != null) {
            DerivedFixedPImage coordinateDFP = new DerivedFixedPImage(GEOREF_CROSS_IMAGE, parent, new DeriveRule(){

                @Override
                public Geometry derive(Geometry in) {
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
                    return factory.createPoint(pair.getCoordinate());
                }
            });
            coordinateDFP.setMultiplier(0.25);
            coordinateDFP.setSweetSpotX(0.5);
            coordinateDFP.setSweetSpotY(0.5);
            this.getChildren().add((PNode)coordinateDFP);
            DerivedFixedPImage textDFP = new DerivedFixedPImage(this.createImageFromText(Integer.toString(position + 1), 30, 30), parent, new DeriveRule(){

                @Override
                public Geometry derive(Geometry in) {
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
                    Point center = factory.createPoint(pair.getCoordinate());
                    return center;
                }
            });
            textDFP.setSweetSpotX(1.0);
            textDFP.setSweetSpotY(1.0);
            this.getChildren().add((PNode)textDFP);
        }
    }

    private void addPointChild(PFeature parent, int position) {
        AffineTransformation transform;
        final PointCoordinatePair pair = this.getHandler().getPair(position);
        if (pair != null && pair.getPoint() != null && (transform = this.getHandler().getMetaData().getTransform()) != null) {
            DerivedFixedPImage pointDFP = new DerivedFixedPImage(GEOREF_DOT_IMAGE, parent, new DeriveRule(){

                @Override
                public Geometry derive(Geometry in) {
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
                    return transform.transform((Geometry)factory.createPoint(new Coordinate(pair.getPoint().getX(), pair.getPoint().getY())));
                }
            });
            pointDFP.setMultiplier(0.25);
            pointDFP.setSweetSpotX(0.5);
            pointDFP.setSweetSpotY(0.5);
            this.getChildren().add((PNode)pointDFP);
            DerivedFixedPImage textDFP = new DerivedFixedPImage(this.createImageFromText(Integer.toString(position + 1), 30, 30), parent, new DeriveRule(){

                @Override
                public Geometry derive(Geometry in) {
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(), CrsTransformer.extractSridFromCrs(CismapBroker.getInstance().getSrs().getCode()));
                    return transform.transform((Geometry)factory.createPoint(new Coordinate(pair.getPoint().getX(), pair.getPoint().getY())));
                }
            });
            textDFP.setSweetSpotX(0.0);
            textDFP.setSweetSpotY(0.0);
            this.getChildren().add((PNode)textDFP);
        }
    }

    private BufferedImage createImageFromText(String text, int width, int height) {
        Font font = new Font("Arial", 1, 12);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, width, height);
        g2d.setComposite(AlphaComposite.Src);
        g2d.setColor(Color.BLACK);
        g2d.setFont(font);
        FontMetrics metrics = g2d.getFontMetrics(font);
        g2d.drawString(text, (float)width / 2.0f - (float)metrics.stringWidth(text) / 2.0f, (float)height / 2.0f - (float)metrics.getHeight() / 2.0f + (float)metrics.getAscent());
        g2d.dispose();
        return image;
    }

    @Override
    public Collection<PNode> provideChildren(PFeature parent) {
        if (this.getChildren().isEmpty()) {
            this.init(parent);
        }
        return this.getChildren();
    }

    private void refresh() {
        this.getChildren().clear();
        this.updateGeometry();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RasterGeoRefFeature.this.setRefreshing(true);
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(RasterGeoRefFeature.this);
                    if (RasterGeoRefFeature.this.getGeometry() != null) {
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature(RasterGeoRefFeature.this);
                    }
                }
                finally {
                    RasterGeoRefFeature.this.setRefreshing(false);
                }
            }
        });
    }

    @Override
    public void positionAdded(int position) {
        this.refresh();
    }

    @Override
    public void positionRemoved(int position) {
        this.refresh();
    }

    @Override
    public void positionChanged(int position) {
        this.refresh();
    }

    @Override
    public void transformationChanged() {
        this.refresh();
    }

    @Override
    public void pointSelected(int position) {
    }

    @Override
    public void coordinateSelected(int position) {
    }

    @Override
    public void handlerChanged(RasterGeoReferencingHandler handler) {
        if (handler != null && handler.equals(this.getHandler())) {
            this.refresh();
        }
    }

    private ArrayList<PNode> getChildren() {
        return this.children;
    }

    private RasterGeoReferencingHandler getHandler() {
        return this.handler;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    private void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    static {
        LOG = Logger.getLogger(RasterGeoRefFeature.class);
        BufferedImage geoRefDotImage = null;
        try {
            geoRefDotImage = ImageIO.read(RasterGeoRefFeature.class.getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef_dot.png"));
        }
        catch (IOException ex) {
            LOG.error((Object)"could not load the georref_dot image from resources");
        }
        GEOREF_DOT_IMAGE = geoRefDotImage;
        BufferedImage geoRefCrossImage = null;
        try {
            geoRefCrossImage = ImageIO.read(RasterGeoRefFeature.class.getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef_cross.png"));
        }
        catch (IOException ex) {
            LOG.error((Object)"could not load the georref_cross image from resources");
        }
        GEOREF_CROSS_IMAGE = geoRefCrossImage;
        BufferedImage geoRefIconImage = null;
        try {
            geoRefIconImage = ImageIO.read(RasterGeoRefFeature.class.getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef.png"));
        }
        catch (IOException ex) {
            LOG.error((Object)"could not load the georref_cross image from resources");
        }
        GEOREF_ICON = new ImageIcon(geoRefIconImage.getScaledInstance(13, 13, 4));
    }
}

