/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import com.vividsolutions.jts.geom.Coordinate;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PanAndMousewheelZoomListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingDialog;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizard;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizardListener;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class RasterGeoReferencingInputListener
extends PPanEventHandler
implements RasterGeoReferencingWizardListener {
    private static final transient Logger LOG = Logger.getLogger(RasterGeoReferencingInputListener.class);
    public static final String NAME = "RasterGeoRefInputListener";
    private boolean ignoreTransformationChanged = false;

    private RasterGeoReferencingInputListener() {
        RasterGeoReferencingInputListener.getWizard().addListener(this);
    }

    public void mouseMoved(PInputEvent pie) {
        super.mouseMoved(pie);
        if (RasterGeoReferencingDialog.getInstance().isVisible() && RasterGeoReferencingInputListener.getHandler() != null) {
            Coordinate coordinate;
            Point2D mouseScreenPoint = pie.getPosition();
            WorldToScreenTransform wtst = RasterGeoReferencingInputListener.getMainMap().getWtst();
            Coordinate mouseCoordinate = new Coordinate(wtst.getWorldX(mouseScreenPoint.getX()), wtst.getWorldY(mouseScreenPoint.getY()));
            int position = RasterGeoReferencingInputListener.getWizard().getPosition();
            Coordinate pointCoordinate = RasterGeoReferencingInputListener.getHandler().getPointCoordinate(position);
            if (!RasterGeoReferencingInputListener.getWizard().isCoordinateSelected() || pointCoordinate != null) {
                coordinate = !RasterGeoReferencingInputListener.getWizard().isCoordinateSelected() ? mouseCoordinate : pointCoordinate;
                RasterGeoReferencingInputListener.getWizard().setPointZoom(coordinate);
            }
            Coordinate coordinate2 = coordinate = RasterGeoReferencingInputListener.getWizard().isCoordinateSelected() ? mouseCoordinate : RasterGeoReferencingInputListener.getWizard().getSelectedCoordinate();
            if (RasterGeoReferencingInputListener.getWizard().isCoordinateSelected() || coordinate != null) {
                RasterGeoReferencingInputListener.getWizard().setCoordinateZoom(coordinate);
            }
        }
    }

    public void mouseDragged(PInputEvent pie) {
        super.mouseDragged(pie);
        this.getPanAndMousewheelZoomListener().mouseDragged(pie);
    }

    protected void dragActivityFirstStep(PInputEvent pie) {
        super.dragActivityFirstStep(pie);
        this.getPanAndMousewheelZoomListener().dragActivityFirstStep(pie);
    }

    protected void dragActivityFinalStep(PInputEvent pie) {
        super.dragActivityFinalStep(pie);
        this.getPanAndMousewheelZoomListener().dragActivityFinalStep(pie);
    }

    private PanAndMousewheelZoomListener getPanAndMousewheelZoomListener() {
        return (PanAndMousewheelZoomListener)RasterGeoReferencingInputListener.getMainMap().getInputListener("PAN");
    }

    public void mouseWheelRotated(PInputEvent pie) {
        this.getPanAndMousewheelZoomListener().mouseWheelRotated(pie);
    }

    public void mouseClicked(PInputEvent pie) {
        super.mouseClicked(pie);
        if (RasterGeoReferencingDialog.getInstance().isVisible() && pie.isLeftMouseButton()) {
            if (pie.getClickCount() < 2) {
                int position;
                block9: {
                    Point2D mapPoint = pie.getPosition();
                    WorldToScreenTransform wtst = RasterGeoReferencingInputListener.getMainMap().getWtst();
                    Coordinate coordinate = new Coordinate(wtst.getWorldX(mapPoint.getX()), wtst.getWorldY(mapPoint.getY()));
                    position = RasterGeoReferencingInputListener.getWizard().getPosition();
                    try {
                        Coordinate imageCoordinate = RasterGeoReferencingInputListener.getHandler().getMetaData().getTransform().getInverse().transform(coordinate, new Coordinate());
                        Point point = new Point((int)imageCoordinate.x, (int)imageCoordinate.y);
                        if (RasterGeoReferencingInputListener.getWizard().isPointSelected()) {
                            RasterGeoReferencingInputListener.getHandler().setPoint(position, point);
                            break block9;
                        }
                        if (RasterGeoReferencingInputListener.getWizard().isCoordinateSelected()) {
                            RasterGeoReferencingInputListener.getHandler().setCoordinate(position, coordinate);
                            break block9;
                        }
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (RasterGeoReferencingInputListener.getWizard().isCoordinateSelectionMode()) {
                    RasterGeoReferencingInputListener.getHandler().setPositionEnabled(position, true);
                }
                RasterGeoReferencingInputListener.getWizard().forward();
            }
        } else if (pie.isRightMouseButton()) {
            RasterGeoReferencingInputListener.getWizard().backward();
        }
    }

    public static MappingComponent getMainMap() {
        return CismapBroker.getInstance().getMappingComponent();
    }

    private static RasterGeoReferencingWizard getWizard() {
        return RasterGeoReferencingWizard.getInstance();
    }

    private static RasterGeoReferencingHandler getHandler() {
        return RasterGeoReferencingInputListener.getWizard().getHandler();
    }

    @Override
    public void pointSelected(int position) {
        RasterGeoReferencingInputListener.getWizard().updateZoom(position);
    }

    @Override
    public void coordinateSelected(int position) {
        RasterGeoReferencingInputListener.getWizard().updateZoom(position);
    }

    @Override
    public void handlerChanged(RasterGeoReferencingHandler handler) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RasterGeoReferencingInputListener.getWizard().refreshPointZoomMap();
            }
        });
    }

    @Override
    public void positionAdded(int position) {
    }

    @Override
    public void positionRemoved(int position) {
    }

    @Override
    public void positionChanged(int position) {
    }

    @Override
    public void transformationChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RasterGeoReferencingInputListener.getWizard().refreshPointZoomMap();
                RasterGeoReferencingInputListener.getWizard().updateZoom(RasterGeoReferencingInputListener.getWizard().getPosition());
            }
        });
    }

    public static RasterGeoReferencingInputListener getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    private boolean isIgnoreTransformationChanged() {
        return this.ignoreTransformationChanged;
    }

    private void setIgnoreTransformationChanged(boolean ignoreTransformationChanged) {
        this.ignoreTransformationChanged = ignoreTransformationChanged;
    }

    private static final class LazyInitialiser {
        private static final RasterGeoReferencingInputListener INSTANCE = new RasterGeoReferencingInputListener();

        private LazyInitialiser() {
        }
    }
}

