/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RectangleRubberBandListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.ZoomAction;
import de.cismet.cismap.commons.interaction.CismapBroker;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Timer;

public class RubberBandZoomListener
extends RectangleRubberBandListener {
    public static final int ANIMATION_DURATION = 750;
    private static final Config CONFIG = new Config();
    private final transient Timer timer = new Timer(1, null);
    private ActionListener zoomListener = null;

    public RubberBandZoomListener() {
        this.timer.setRepeats(false);
    }

    @Override
    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        if (e.getButton() == 1 && this.rectangle != null) {
            PBounds b = new PBounds(this.rectangle.getBounds());
            PBounds bb = (PBounds)b.clone();
            e.getCamera().viewToLocal((Rectangle2D)bb);
            if (bb.width > 20.0 && bb.height > 20.0 && e.getComponent() instanceof MappingComponent) {
                MappingComponent map = (MappingComponent)e.getComponent();
                e.getCamera().animateViewToCenterBounds((Rectangle2D)b, true, (long)map.getAnimationDuration());
                map.setNewViewBounds((Rectangle2D)b);
                map.queryServices();
            }
        }
    }

    public void mouseClicked(PInputEvent e) {
        super.mouseClicked(e);
        if (e.getButton() == 3 && e.getComponent() instanceof MappingComponent) {
            this.zoom(0.5f, e, ((MappingComponent)e.getComponent()).getAnimationDuration(), 200);
        }
    }

    public void mouseWheelRotated(PInputEvent pInputEvent) {
        int direction;
        super.mouseWheelRotated(pInputEvent);
        int n = direction = RubberBandZoomListener.CONFIG.invertScrollDirection ? -1 : 1;
        if (direction * pInputEvent.getWheelRotation() < 0) {
            this.zoom(0.9f, pInputEvent, 0, 800);
        } else {
            this.zoom(1.1f, pInputEvent, 0, 800);
        }
    }

    public void zoom(float factor, PInputEvent e, int localAnimationDuration) {
        this.zoom(factor, e, localAnimationDuration, 0);
    }

    public void zoom(float factor, PInputEvent e, int localAnimationDuration, int delayTime) {
        this.zoom(factor, e.getCamera(), localAnimationDuration, delayTime);
    }

    public void zoom(float factor, PCamera pc, int localAnimationDuration, int delayTime) {
        PBounds b = new PBounds();
        double scale = factor;
        double oldWidth = pc.getViewBounds().getWidth();
        double newWidth = oldWidth * (1.0 - scale + 1.0);
        double oldHeight = pc.getViewBounds().getHeight();
        double newHeight = oldHeight * (1.0 - scale + 1.0);
        double offsetX = (newWidth - oldWidth) / 2.0;
        double offsetY = (newHeight - oldHeight) / 2.0;
        Point2D origin = pc.getViewBounds().getOrigin();
        double originX = origin.getX() - offsetX;
        double originY = origin.getY() - offsetY;
        b.setOrigin(originX, originY);
        b.setSize(newWidth, newHeight);
        pc.animateViewToCenterBounds((Rectangle2D)b, true, (long)localAnimationDuration);
        if (localAnimationDuration == 0) {
            CismapBroker.getInstance().fireMapBoundsChanged();
        }
        if (this.zoomListener != null) {
            this.timer.removeActionListener(this.zoomListener);
        }
        this.zoomListener = new ZoomAction(b, (MappingComponent)pc.getComponent());
        this.timer.addActionListener(this.zoomListener);
        this.timer.setInitialDelay(delayTime);
        if (this.timer.isRunning()) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    public boolean isInvertScrollDirection() {
        return RubberBandZoomListener.CONFIG.invertScrollDirection;
    }

    public void setInvertScrollDirection(boolean invertScrollDirection) {
        RubberBandZoomListener.CONFIG.invertScrollDirection = invertScrollDirection;
    }

    static class Config {
        boolean invertScrollDirection = false;

        Config() {
        }
    }
}

