/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.piccolo.eventlistener;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.tools.PFeatureTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.PNotificationCenter;
import java.awt.geom.Point2D;
import org.apache.log4j.Logger;

public class SplitPolygonListener
extends PBasicInputEventHandler {
    public static final String SPLIT_FINISHED = "SPLIT_FINISHED";
    public static final String SELECTION_CHANGED = "SELECTION_CHANGED";
    private final MappingComponent mc;
    private PFeature pFeature = null;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public SplitPolygonListener(MappingComponent mc) {
        this.mc = mc;
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        PNode o;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"mouseClicked()");
        }
        if ((o = PFeatureTools.getFirstValidObjectUnderPointer(pInputEvent, new Class[]{PFeature.class}, true)) instanceof PFeature) {
            super.mouseClicked(pInputEvent);
            this.pFeature = (PFeature)o;
            if (!this.pFeature.isSelected()) {
                this.mc.getFeatureCollection().select(this.pFeature.getFeature());
            } else if (this.pFeature.inSplitProgress()) {
                Point2D point = null;
                if (this.mc.isSnappingEnabled()) {
                    point = PFeatureTools.getNearestPointInArea(this.mc, pInputEvent.getCanvasPosition());
                }
                if (point == null) {
                    point = pInputEvent.getPosition();
                }
                if (this.pFeature.inSplitProgress()) {
                    this.pFeature.getSplitPoints().add(point);
                    this.updateSplitLine(null);
                }
            } else {
                this.postClickDetected();
            }
        } else {
            this.pFeature = null;
        }
    }

    private void postClickDetected() {
        PNotificationCenter pn = PNotificationCenter.defaultCenter();
        pn.postNotification(SPLIT_FINISHED, (Object)this);
    }

    public PFeature getFeatureClickedOn() {
        return this.pFeature;
    }

    public PFeature getSelectedPFeature() {
        return this.pFeature;
    }

    public void mouseMoved(PInputEvent event) {
        PNode o = PFeatureTools.getFirstValidObjectUnderPointer(event, new Class[]{PFeature.class}, true);
        this.pFeature = (PFeature)o;
        if (this.pFeature == null && this.mc.getFeatureCollection().getSelectedFeatures().size() == 1) {
            this.pFeature = this.mc.getPFeatureHM().get(this.mc.getFeatureCollection().getSelectedFeatures().toArray()[0]);
        }
        if (this.pFeature != null && this.pFeature.inSplitProgress()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"want to draw line");
            }
            Point2D point = null;
            if (this.mc.isSnappingEnabled()) {
                point = PFeatureTools.getNearestPointInArea(this.mc, event.getCanvasPosition());
            }
            if (point == null) {
                point = event.getPosition();
            }
            this.updateSplitLine(point);
        }
        super.mouseMoved(event);
    }

    private void updateSplitLine(Point2D lastPoint) {
        Point2D[] pa = this.getPoints(lastPoint);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getSplitLine()" + this.pFeature.getSplitLine()));
        }
        this.pFeature.getSplitLine().setPathToPolyline(pa);
        this.pFeature.getSplitLine().repaint();
    }

    private Point2D[] getPoints(Point2D lastPoint) {
        boolean movin;
        int plus;
        if (lastPoint != null) {
            plus = 1;
            movin = true;
        } else {
            plus = 0;
            movin = false;
        }
        Point2D[] pa = new Point2D[this.pFeature.getSplitPoints().size() + plus];
        for (int i = 0; i < this.pFeature.getSplitPoints().size(); ++i) {
            pa[i] = this.pFeature.getSplitPoints().get(i);
        }
        if (movin) {
            pa[this.pFeature.getSplitPoints().size()] = lastPoint;
        }
        return pa;
    }
}

