/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;

public class JasperDownload
extends AbstractCancellableDownload {
    private final List<JasperPrint> prints = new ArrayList<JasperPrint>(5);
    private JasperReport report;
    private Map parameters;
    private JRDataSource dataSource;

    public JasperDownload(JasperPrint print, String directory, String title, String filename) {
        this.prints.add(print);
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".pdf");
    }

    public JasperDownload(Collection<JasperPrint> prints, String directory, String title, String filename) {
        this.prints.addAll(prints);
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".pdf");
    }

    public JasperDownload(JasperReport report, Map parameters, JRDataSource dataSource, String directory, String title, String filename) {
        this.report = report;
        this.parameters = parameters;
        this.dataSource = dataSource;
        this.directory = directory;
        this.title = title;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, ".pdf");
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        if (this.prints.isEmpty() && this.report != null) {
            try {
                this.prints.add(JasperFillManager.fillReport((JasperReport)this.report, (Map)this.parameters, (JRDataSource)this.dataSource));
            }
            catch (JRException ex) {
                this.error((Exception)((Object)ex));
            }
        }
        if (this.prints.size() > 0) {
            try {
                if (Thread.interrupted()) {
                    log.info((Object)"Download was interuppted");
                    this.deleteFile();
                    return;
                }
                JRPdfExporter exporter = new JRPdfExporter();
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.prints));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(this.fileToSaveTo.getPath()));
                SimplePdfExporterConfiguration configuration = new SimplePdfExporterConfiguration();
                configuration.setCreatingBatchModeBookmarks(Boolean.valueOf(true));
                exporter.setConfiguration((ExporterConfiguration)configuration);
                exporter.exportReport();
            }
            catch (JRException ex) {
                this.error((Exception)((Object)ex));
            }
        }
        this.cleanup();
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    private void cleanup() {
        this.report = null;
        this.parameters = null;
        this.dataSource = null;
        this.prints.clear();
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    public void setFileToSaveTo(File fileToSaveTo) {
        this.fileToSaveTo = fileToSaveTo;
    }
}

