/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.printing;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.PrintTemplateFeature;
import de.cismet.cismap.commons.gui.printing.Action;
import de.cismet.cismap.commons.gui.printing.Resolution;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.printing.Template;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class PrintingSettingsWidget
extends JDialog
implements Configurable {
    public static final double FEATURE_RESOLUTION_FACTOR = 125.0;
    private final Logger log = Logger.getLogger(this.getClass());
    private Element configuration = null;
    private Vector<Scale> scales = new Vector();
    private Vector<Resolution> resolutions = new Vector();
    private Vector<Template> templates = new Vector();
    private Vector<Action> actions = new Vector();
    private MappingComponent mappingComponent = null;
    private boolean chooseFileName = false;
    private boolean oldOverlappingCheck = true;
    private Color featureFillingColor;
    private JComboBox cboAction;
    private JComboBox cboResolution;
    private JComboBox cboScales;
    private JComboBox cboTemplates;
    private JButton cmdCancel;
    private JButton cmdOk;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JPanel panDesc;
    private JPanel panSettings;

    public PrintingSettingsWidget(boolean modal, MappingComponent mappingComponent) {
        super(StaticSwingTools.getParentFrame((Component)((Object)mappingComponent)), modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.cmdOk);
        this.mappingComponent = mappingComponent;
        this.oldOverlappingCheck = CismapBroker.getInstance().isCheckForOverlappingGeometriesAfterFeatureRotation();
    }

    public PrintingSettingsWidget cloneWithNewParent(boolean modal, MappingComponent mappingComponent) {
        PrintingSettingsWidget newWidget = new PrintingSettingsWidget(modal, mappingComponent);
        newWidget.configuration = this.configuration;
        newWidget.scales = this.scales;
        newWidget.resolutions = this.resolutions;
        newWidget.templates = this.templates;
        newWidget.actions = this.actions;
        newWidget.featureFillingColor = this.featureFillingColor;
        newWidget.cboScales.setModel(this.cboScales.getModel());
        newWidget.cboResolution.setModel(this.cboResolution.getModel());
        newWidget.cboTemplates.setModel(this.cboTemplates.getModel());
        newWidget.cboAction.setModel(new DefaultComboBoxModel<Action>(this.actions));
        newWidget.cboScales.setSelectedItem(this.cboScales.getSelectedItem());
        newWidget.cboResolution.setSelectedItem(this.cboResolution.getSelectedItem());
        newWidget.cboTemplates.setSelectedItem(this.cboTemplates.getSelectedItem());
        newWidget.cboAction.setSelectedItem(this.cboAction.getSelectedItem());
        return newWidget;
    }

    private void initComponents() {
        this.panDesc = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.cmdOk = new JButton();
        this.cmdCancel = new JButton();
        this.panSettings = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.cboTemplates = new JComboBox();
        this.cboScales = new JComboBox();
        this.cboResolution = new JComboBox();
        this.cboAction = new JComboBox();
        this.jSeparator4 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.title"));
        this.panDesc.setBackground(new Color(216, 228, 248));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel2.text"));
        this.jLabel3.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel3.text"));
        this.jLabel4.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel4.text"));
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/frameprint.png")));
        GroupLayout panDescLayout = new GroupLayout((Container)this.panDesc);
        this.panDesc.setLayout((LayoutManager)panDescLayout);
        panDescLayout.setHorizontalGroup((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((Component)this.jSeparator3, -1, 254, Short.MAX_VALUE).add(2, (GroupLayout.Group)panDescLayout.createSequentialGroup().addContainerGap(116, Short.MAX_VALUE).add((Component)this.jLabel5).addContainerGap()).add((GroupLayout.Group)panDescLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((GroupLayout.Group)panDescLayout.createSequentialGroup().add((Component)this.jSeparator2, -1, 234, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)panDescLayout.createSequentialGroup().add((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4)).add(83, 83, 83)))));
        panDescLayout.setVerticalGroup((GroupLayout.Group)panDescLayout.createParallelGroup(1).add((GroupLayout.Group)panDescLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSeparator2, -2, 2, -2).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0, 26, Short.MAX_VALUE).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jSeparator3, -2, -1, -2)));
        this.cmdOk.setMnemonic('O');
        this.cmdOk.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintingSettingsWidget.this.cmdOkActionPerformed(evt);
            }
        });
        this.cmdCancel.setMnemonic('A');
        this.cmdCancel.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.cmdCancel.text"));
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintingSettingsWidget.this.cmdCancelActionPerformed(evt);
            }
        });
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel6.text"));
        this.jLabel7.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel7.text"));
        this.jLabel8.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel8.text"));
        this.jLabel9.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel9.text"));
        this.jLabel10.setText(NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel10.text"));
        this.cboTemplates.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboScales.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboScales.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintingSettingsWidget.this.cboScalesActionPerformed(evt);
            }
        });
        this.cboResolution.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboAction.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout panSettingsLayout = new GroupLayout((Container)this.panSettings);
        this.panSettings.setLayout((LayoutManager)panSettingsLayout);
        panSettingsLayout.setHorizontalGroup((GroupLayout.Group)panSettingsLayout.createParallelGroup(1).add((GroupLayout.Group)panSettingsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panSettingsLayout.createParallelGroup(1).add((GroupLayout.Group)panSettingsLayout.createSequentialGroup().add((Component)this.jLabel6).add(14, 14, 14)).add((GroupLayout.Group)panSettingsLayout.createSequentialGroup().add((GroupLayout.Group)panSettingsLayout.createParallelGroup(1).add((Component)this.jLabel7).add((Component)this.jLabel8).add((Component)this.jLabel9).add((Component)this.jLabel10)).addPreferredGap(0).add((GroupLayout.Group)panSettingsLayout.createParallelGroup(1).add((Component)this.cboAction, 0, 302, Short.MAX_VALUE).add((Component)this.cboResolution, 0, 302, Short.MAX_VALUE).add((Component)this.cboScales, 0, 302, Short.MAX_VALUE).add((Component)this.cboTemplates, 0, 302, Short.MAX_VALUE)))).addContainerGap()).add((Component)this.jSeparator4, -1, 376, Short.MAX_VALUE).add(2, (GroupLayout.Group)panSettingsLayout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 366, Short.MAX_VALUE)));
        panSettingsLayout.setVerticalGroup((GroupLayout.Group)panSettingsLayout.createParallelGroup(1).add((GroupLayout.Group)panSettingsLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)panSettingsLayout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.cboTemplates, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panSettingsLayout.createParallelGroup(3).add((Component)this.jLabel8).add((Component)this.cboScales, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panSettingsLayout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.cboResolution, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panSettingsLayout.createParallelGroup(3).add((Component)this.jLabel10).add((Component)this.cboAction, -2, -1, -2)).addPreferredGap(0, 108, Short.MAX_VALUE).add((Component)this.jSeparator4, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.cmdCancel, -2, 110, -2).addPreferredGap(0).add((Component)this.cmdOk, -2, 107, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.panDesc, -2, -1, -2).add(18, 18, 18).add((Component)this.panSettings, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.panSettings, -1, -1, Short.MAX_VALUE).add(2, (Component)this.panDesc, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cmdOk).add((Component)this.cmdCancel)).addContainerGap()));
        this.pack();
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        try {
            Scale selectedScale = (Scale)this.cboScales.getSelectedItem();
            Resolution selectedResolution = (Resolution)this.cboResolution.getSelectedItem();
            this.mappingComponent.setPrintingResolution((double)selectedResolution.getResolution() / this.mappingComponent.getFeaturePrintingDpi());
            Template selectedTemplate = (Template)this.cboTemplates.getSelectedItem();
            PrintTemplateFeature printTemplateStyledFeature = new PrintTemplateFeature(selectedTemplate, selectedResolution, selectedScale, this.mappingComponent);
            DefaultFeatureCollection mapFeatureCol = (DefaultFeatureCollection)this.mappingComponent.getFeatureCollection();
            mapFeatureCol.holdFeature(printTemplateStyledFeature);
            mapFeatureCol.addFeature(printTemplateStyledFeature);
            this.mappingComponent.adjustMapForSpecialFeatureClasses(PrintTemplateFeature.class);
            mapFeatureCol.select(printTemplateStyledFeature);
            this.mappingComponent.setHandleInteractionMode("ROTATE_POLYGON");
            this.mappingComponent.showHandles(false);
            CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(false);
            this.dispose();
        }
        catch (Exception e) {
            this.log.error((Object)"Fehler beim Verarbeiten der Druckeinstellungen", (Throwable)e);
        }
    }

    private void cmdCancelActionPerformed(ActionEvent evt) {
        if (this.mappingComponent.getSpecialFeatureCollection(PrintTemplateFeature.class).size() == 0) {
            CismapBroker.getInstance().setCheckForOverlappingGeometriesAfterFeatureRotation(this.oldOverlappingCheck);
        }
        this.dispose();
    }

    private void cboScalesActionPerformed(ActionEvent evt) {
    }

    public Paint getFeatureFillingPaint() {
        return this.featureFillingColor;
    }

    public boolean getOldOverlappingCheckEnabled() {
        return this.oldOverlappingCheck;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public Element getConfiguration() {
        Element ret = new Element("printing");
        for (Scale scale : this.scales) {
            ret.addContent((Content)scale.getElement(scale.equals(this.cboScales.getSelectedItem())));
        }
        for (Resolution resolution : this.resolutions) {
            ret.addContent((Content)resolution.getElement(resolution.equals(this.cboResolution.getSelectedItem())));
        }
        for (Template template : this.templates) {
            ret.addContent((Content)template.getElement(template.equals(this.cboTemplates.getSelectedItem())));
        }
        for (Action action : this.actions) {
            ret.addContent((Content)action.getElement(action.equals(this.cboAction.getSelectedItem())));
        }
        return ret;
    }

    public void masterConfigure(Element parent) {
        try {
            Element prefs = parent.getChild("printing");
            this.configuration = (Element)prefs.clone();
            try {
                this.featureFillingColor = Color.decode(prefs.getAttributeValue("featureFillingColor"));
            }
            catch (Exception ex) {
                this.log.info((Object)"could not parse featureFillingColor", (Throwable)ex);
                this.featureFillingColor = UIManager.getDefaults().getColor("Cismap.featureSelectionForeground");
            }
            List scalesList = prefs.getChildren("scale");
            List resolutionsList = prefs.getChildren("resolution");
            List templatesList = prefs.getChildren("template");
            List actionList = prefs.getChildren("action");
            Scale selectedScale = null;
            Resolution selectedResolution = null;
            Template selectedTemplate = null;
            Action selectedAction = null;
            this.scales.removeAllElements();
            this.resolutions.removeAllElements();
            this.templates.removeAllElements();
            this.actions.removeAllElements();
            try {
                for (Object elem : scalesList) {
                    if (!(elem instanceof Element)) continue;
                    Scale s = new Scale((Element)elem);
                    this.scales.add(s);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedScale = s;
                }
                for (Object elem : resolutionsList) {
                    if (!(elem instanceof Element)) continue;
                    Resolution r = new Resolution((Element)elem);
                    this.resolutions.add(r);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedResolution = r;
                }
                for (Object elem : templatesList) {
                    if (!(elem instanceof Element)) continue;
                    Template t = new Template((Element)elem);
                    this.templates.add(t);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedTemplate = t;
                }
                this.templates.sort((Comparator<Template>)new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof Template && o2 instanceof Template) {
                            try {
                                if (((Template)o1).getTitle() != null && ((Template)o2).getTitle() != null) {
                                    return ((Template)o1).getTitle().compareTo(((Template)o2).getTitle());
                                }
                                if (((Template)o1).getTitle() != null) {
                                    return 1;
                                }
                                return -1;
                            }
                            catch (Exception e) {
                                return 0;
                            }
                        }
                        if (o1 instanceof Element) {
                            return 1;
                        }
                        if (o2 instanceof Element) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (Object elem : actionList) {
                    if (!(elem instanceof Element)) continue;
                    Action a = new Action((Element)elem);
                    this.actions.add(a);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedAction = a;
                }
                this.cboScales.setModel(new DefaultComboBoxModel<Scale>(this.scales));
                this.cboResolution.setModel(new DefaultComboBoxModel<Resolution>(this.resolutions));
                this.cboTemplates.setModel(new DefaultComboBoxModel<Template>(this.templates));
                this.cboAction.setModel(new DefaultComboBoxModel<Action>(this.actions));
                this.cboScales.setSelectedItem(selectedScale);
                this.cboResolution.setSelectedItem(selectedResolution);
                this.cboTemplates.setSelectedItem(selectedTemplate);
                this.cboAction.setSelectedItem(selectedAction);
            }
            catch (Exception e) {
                this.log.error((Object)"Error during initialization of the printingDialog", (Throwable)e);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Error during initialization of the PrintingWidgets. catched.", (Throwable)ex);
        }
    }

    public void configure(Element parent) {
        Element prefs;
        if (parent != null && (prefs = parent.getChild("printing")) != null) {
            this.configuration = (Element)prefs.clone();
            List scalesList = prefs.getChildren("scale");
            List resolutionsList = prefs.getChildren("resolution");
            List templatesList = prefs.getChildren("template");
            List actionList = prefs.getChildren("action");
            Scale selectedScale = null;
            Resolution selectedResolution = null;
            Template selectedTemplate = null;
            Action selectedAction = null;
            try {
                for (Object elem : scalesList) {
                    if (!(elem instanceof Element)) continue;
                    Scale s = new Scale((Element)elem);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedScale = s;
                }
                for (Object elem : resolutionsList) {
                    if (!(elem instanceof Element)) continue;
                    Resolution r = new Resolution((Element)elem);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedResolution = r;
                }
                for (Object elem : templatesList) {
                    if (!(elem instanceof Element)) continue;
                    Template t = new Template((Element)elem);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedTemplate = t;
                }
                for (Object elem : actionList) {
                    if (!(elem instanceof Element)) continue;
                    Action a = new Action((Element)elem);
                    if (!((Element)elem).getAttribute("selected").getBooleanValue()) continue;
                    selectedAction = a;
                }
                if (this.scales.contains(selectedScale)) {
                    this.cboScales.setSelectedItem(selectedScale);
                }
                if (this.resolutions.contains(selectedResolution)) {
                    this.cboResolution.setSelectedItem(selectedResolution);
                }
                if (this.templates.contains(selectedTemplate)) {
                    this.cboTemplates.setSelectedItem(selectedTemplate);
                }
                if (this.actions.contains(selectedAction)) {
                    this.cboAction.setSelectedItem(selectedAction);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error during initialization of the printingDialog", (Throwable)e);
            }
        }
    }

    public Scale getSelectedScale() {
        return (Scale)this.cboScales.getSelectedItem();
    }

    public Template getSelectedTemplate() {
        return (Template)this.cboTemplates.getSelectedItem();
    }

    public Resolution getSelectedResolution() {
        return (Resolution)this.cboResolution.getSelectedItem();
    }

    public Action getSelectedAction() {
        return (Action)this.cboAction.getSelectedItem();
    }

    public void setChooseFileName(boolean chooseFileName) {
        this.chooseFileName = chooseFileName;
    }

    public boolean isChooseFileName() {
        return this.chooseFileName;
    }

    public Collection<Scale> getScales() {
        return new ArrayList<Scale>(this.scales);
    }

    public Collection<Template> getTemplates() {
        return new ArrayList<Template>(this.templates);
    }

    public Collection<Resolution> getResolutions() {
        return new ArrayList<Resolution>(this.resolutions);
    }

    public String getTemplateString() {
        return NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel7.text");
    }

    public String getScaleString() {
        return NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel8.text");
    }

    public String getResolutionString() {
        return NbBundle.getMessage(PrintingSettingsWidget.class, (String)"PrintingSettingsWidget.jLabel9.text");
    }
}

