/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.progresswidgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseMotionListener;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class DocumentProgressWidget
extends JInternalFrame {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private JProgressBar progressBar;
    private JLabel serviceLabel;

    public DocumentProgressWidget() {
        try {
            BasicInternalFrameUI fui = (BasicInternalFrameUI)this.getUI();
            JComponent north = fui.getNorthPane();
            MouseMotionListener[] listener = (MouseMotionListener[])north.getListeners(MouseMotionListener.class);
            for (int i = 0; i < listener.length; ++i) {
                north.removeMouseMotionListener(listener[i]);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Fehler beim Entfernen von Mousemotionlisteners", (Throwable)e);
        }
        this.initComponents();
    }

    public void setServiceName(String name) {
        this.serviceLabel.setText(name);
    }

    public void setProgress(int progress) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setting progress: " + progress));
        }
        if (progress == -1) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(progress);
        }
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel();
        this.progressBar = new JProgressBar();
        JLabel iconLabel = new JLabel();
        this.serviceLabel = new JLabel();
        JLabel messageLabel = new JLabel();
        this.progressBar.setPreferredSize(new Dimension(360, 20));
        iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/blockdevice.png")));
        this.serviceLabel.setFont(new Font("Tahoma", 1, 12));
        this.serviceLabel.setText("Service Name");
        messageLabel.setText(NbBundle.getMessage(DocumentProgressWidget.class, (String)"DocumentProgressWidget.messageLabel"));
        GroupLayout mainPanelLayout = new GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -2, 360, -2).addGroup(mainPanelLayout.createSequentialGroup().addComponent(iconLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(messageLabel).addGap(51, 51, 51)).addComponent(this.serviceLabel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.serviceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(messageLabel)).addComponent(iconLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 20, -2).addContainerGap(20, Short.MAX_VALUE)));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
    }
}

