/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.shapeexport;

import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.gui.shapeexport.ExportWFS;
import de.cismet.cismap.commons.gui.shapeexport.ShapeExportAction;
import de.cismet.tools.collections.TypeSafeCollections;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class ShapeExport
implements Configurable,
ToolbarComponentsProvider,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(ShapeExport.class);
    private static final String PLUGIN_NAME = "SHAPE_EXPORT";
    private static final String XML_CONF_ROOT = "cismapShapeExport";
    private static final String XML_BBOX_TOKEN = "bboxToken";
    private static final String XML_WFS = "wfs";
    private static final String XML_WFS_TITLE = "title";
    private static final String XML_WFS_URL = "url";
    private static final String XML_WFS_QUERY = "query";
    private static final String XML_WFS_TARGET_CRS = "targetCRS";
    private static final String XML_DESTINATION = "destination";
    private static final String XML_DIRECTORY = "directory";
    private static final String XML_FILE = "file";
    private static final String XML_WFS_FILE = "file";
    private static final String XML_EXTENSION = "extension";
    private static Set<ExportWFS> wfsList = new LinkedHashSet<ExportWFS>();
    private static String bboxToken = "<cismap:BBOX/>";
    private static String destinationDirectory = "cismap";
    private static String destinationFile = "export";
    private static String destinationFileExtension = ".zip";
    private static boolean enableShapeExport = false;
    private List<ToolbarComponentDescription> toolbarComponents;

    public static Set<ExportWFS> getWFSList() {
        LinkedHashSet<ExportWFS> result = new LinkedHashSet<ExportWFS>();
        for (ExportWFS wfs : wfsList) {
            ExportWFS copiedWFS = null;
            copiedWFS = wfs.getTargetCRS() != null ? new ExportWFS(new String(wfs.getTopic()), new String(wfs.getFile()), new String(wfs.getQuery()), wfs.getUrl(), new String(wfs.getTargetCRS())) : new ExportWFS(new String(wfs.getTopic()), new String(wfs.getFile()), new String(wfs.getQuery()), wfs.getUrl(), null);
            result.add(copiedWFS);
        }
        return result;
    }

    public static String getBboxToken() {
        return bboxToken;
    }

    public static String getDestinationDirectory() {
        return destinationDirectory;
    }

    public static String getDestinationFile() {
        return destinationFile;
    }

    public static String getDestinationFileExtension() {
        return destinationFileExtension;
    }

    public void configure(Element parent) {
    }

    public void masterConfigure(Element parent) {
        Element file;
        enableShapeExport = true;
        Element cismapShapeExport = parent.getChild(XML_CONF_ROOT);
        if (cismapShapeExport == null) {
            LOG.warn((Object)"The shape export isn't configured. The export functionality will not be available.");
            enableShapeExport = false;
            return;
        }
        Element bbox = cismapShapeExport.getChild(XML_BBOX_TOKEN);
        if (bbox == null || bbox.getText() == null || bbox.getText().trim().length() == 0) {
            LOG.warn((Object)("There is no replacement token configured for shape export. Using default replacement token '" + bboxToken + "'."));
        } else {
            bboxToken = bbox.getText();
        }
        Element destination = cismapShapeExport.getChild(XML_DESTINATION);
        if (destination == null) {
            LOG.warn((Object)"There is no destination directory and file name configured for shape export. Using default directory and default file name.");
        }
        if (destination != null) {
            Element directory = destination.getChild(XML_DIRECTORY);
            if (directory == null || directory.getText() == null || directory.getText().trim().length() == 0) {
                LOG.warn((Object)"There is no destination directory configured for shape export. Using default directory.");
            } else {
                destinationDirectory = directory.getText();
            }
        }
        if ((file = destination.getChild("file")) == null || file.getText() == null || file.getText().trim().length() == 0) {
            LOG.warn((Object)("There is no destination file name configured for shape export. Using default file name '" + destinationFile + "'."));
        } else {
            destinationFile = file.getText();
        }
        Element extension = destination.getChild(XML_EXTENSION);
        if (extension == null || extension.getText() == null || extension.getText().trim().length() == 0) {
            LOG.warn((Object)("There is no destination file extension configured for shape export. Using default file extension '" + destinationFileExtension + "'."));
        } else {
            destinationFileExtension = extension.getText();
        }
        List exportWFSs = cismapShapeExport.getChildren(XML_WFS);
        for (Element exportWFS : exportWFSs) {
            Element title = exportWFS.getChild(XML_WFS_TITLE);
            Element wfsFile = exportWFS.getChild("file");
            Element url = exportWFS.getChild(XML_WFS_URL);
            Element query = exportWFS.getChild(XML_WFS_QUERY);
            Element targetCRS = exportWFS.getChild(XML_WFS_TARGET_CRS);
            if (title == null || url == null || query == null) continue;
            String contentOfTitle = title.getText();
            String contentOfUrl = url.getText();
            String contentOfQuery = query.getText();
            String contentOfWfsFile = destinationFile;
            String contentOfTargetCRS = null;
            if (targetCRS != null) {
                contentOfTargetCRS = targetCRS.getText();
            }
            if (wfsFile != null && wfsFile.getText() != null && wfsFile.getText().trim().length() > 0) {
                contentOfWfsFile = wfsFile.getText();
            }
            if (contentOfTitle == null || contentOfTitle.trim().length() <= 0 || contentOfUrl == null || contentOfUrl.trim().length() <= 0 || contentOfQuery == null || contentOfQuery.trim().length() <= 0) continue;
            URL convertedUrl = null;
            try {
                convertedUrl = new URL(contentOfUrl);
            }
            catch (MalformedURLException e) {
                LOG.error((Object)("The given URL for WFS '" + contentOfTitle + "' is invalid. This WFS will be skipped for shape export."), (Throwable)e);
            }
            if (convertedUrl == null) continue;
            wfsList.add(new ExportWFS(contentOfTitle, contentOfWfsFile, contentOfQuery, convertedUrl, contentOfTargetCRS));
        }
        if (wfsList.isEmpty()) {
            LOG.warn((Object)"Could not read the list of WFSs for shape export. The export functionality will not be available.");
            enableShapeExport = false;
        }
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public Collection<ToolbarComponentDescription> getToolbarComponents() {
        if (this.toolbarComponents == null && enableShapeExport) {
            JButton btnShapeExport = new JButton(new ShapeExportAction());
            btnShapeExport.setText(null);
            btnShapeExport.setName(NbBundle.getMessage(ShapeExportAction.class, (String)"ShapeExportAction.name"));
            btnShapeExport.setBorderPainted(false);
            btnShapeExport.setFocusable(false);
            btnShapeExport.setHorizontalTextPosition(0);
            btnShapeExport.setVerticalTextPosition(3);
            ArrayList preparationList = TypeSafeCollections.newArrayList();
            ToolbarComponentDescription shapeExport = new ToolbarComponentDescription("tlbMain", btnShapeExport, ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "cmdClipboard");
            preparationList.add(shapeExport);
            this.toolbarComponents = Collections.unmodifiableList(preparationList);
        }
        return this.toolbarComponents;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "ShapeExport";
        }
        return null;
    }

    public Component getComponent() {
        JButton btnShapeExport = new JButton(new ShapeExportAction());
        btnShapeExport.setText(null);
        btnShapeExport.setName(NbBundle.getMessage(ShapeExportAction.class, (String)"ShapeExportAction.name"));
        btnShapeExport.setBorderPainted(false);
        btnShapeExport.setFocusable(false);
        btnShapeExport.setHorizontalTextPosition(0);
        btnShapeExport.setVerticalTextPosition(3);
        return btnShapeExport;
    }
}

