/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.simplelayerwidget;

import de.cismet.cismap.commons.PNodeProvider;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.simplelayerwidget.LayerControlSelectionChangedListener;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.imagetooltip.ImageToolTip;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToolTip;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LayerControl
extends JPanel
implements RetrievalListener,
PNodeProvider {
    public static final int RASTER_SERVICE = 1;
    public static final int FEATURE_SERVICE = 2;
    public static final int FEATURE_COLLECTION = 4;
    private final Logger log = Logger.getLogger(this.getClass());
    private boolean selected = false;
    private ServiceLayer layer;
    private ImageIcon visibleIcon = null;
    private ImageIcon invisibleIcon = null;
    private ImageIcon visibleRasterIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/rasterLayerVisible.png"));
    private ImageIcon invisibleRasterIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/rasterLayerNotVisible.png"));
    private ImageIcon visibleFeatureIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/featureLayerVisible.png"));
    private ImageIcon invisibleFeatureIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/featureLayerNotVisible.png"));
    private ImageIcon visibleCollectionIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/featureCollectionLayerVisible.png"));
    private ImageIcon invisibleCollectionIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/featureCollectionLayerNotVisible.png"));
    private PNode transparentable;
    private int type;
    private Image errorImage = null;
    JSlider slider = new JSlider(){

        @Override
        public JToolTip createToolTip() {
            if (LayerControl.this.errorImage != null) {
                return new ImageToolTip(LayerControl.this.errorImage);
            }
            return super.createToolTip();
        }
    };
    private int errorAbolitionTime = 1000;
    private MappingComponent mappingComponent;
    private Vector<LayerControlSelectionChangedListener> listener = new Vector();
    private JSeparator jSeparator1;
    private JLabel lblIcon;
    private JLabel lblIndent;
    private JLabel lblLayerName;
    private JCheckBoxMenuItem mitGridEnabled;
    private JMenuItem mitLayerName;
    private JPopupMenu pmenProps;
    private JProgressBar prbLayer;

    public LayerControl(MappingComponent mappingComponent, int type, int errorAbolitionTime) {
        this.mappingComponent = mappingComponent;
        this.errorAbolitionTime = errorAbolitionTime;
        this.type = type;
        switch (type) {
            case 1: {
                this.visibleIcon = this.visibleRasterIcon;
                this.invisibleIcon = this.invisibleRasterIcon;
                break;
            }
            case 2: {
                this.visibleIcon = this.visibleFeatureIcon;
                this.invisibleIcon = this.invisibleFeatureIcon;
                break;
            }
            case 4: {
                this.visibleIcon = this.visibleCollectionIcon;
                this.invisibleIcon = this.invisibleCollectionIcon;
            }
        }
        this.initComponents();
        this.lblIcon.setIcon(this.visibleIcon);
        this.slider.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.slider.setFocusable(false);
        this.prbLayer.setLayout(new BorderLayout(2, 2));
        this.prbLayer.add((Component)this.slider, "Center");
        this.slider.setRequestFocusEnabled(false);
        this.slider.setOpaque(false);
        this.addMouseListener(new MousePopupListener());
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(final ChangeEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LayerControl.this.setTransparency((float)((double)((JSlider)e.getSource()).getValue() / 100.0));
                    }
                });
            }
        });
    }

    public void addLayerSelectionChangedListener(LayerControlSelectionChangedListener lc) {
        this.listener.add(lc);
    }

    public void removeLayerSelectionChangedListener(LayerControlSelectionChangedListener lc) {
        this.listener.remove(lc);
    }

    private void fireLayerSelectionChanged() {
        for (LayerControlSelectionChangedListener lc : this.listener) {
            lc.layerControlSelectionChanged(this);
        }
    }

    private void fireLayerWantsUp() {
        for (LayerControlSelectionChangedListener lc : this.listener) {
            lc.layerWantsUp(this);
        }
    }

    private void fireLayerWantsDown() {
        for (LayerControlSelectionChangedListener lc : this.listener) {
            lc.layerWantsDown(this);
        }
    }

    private void initComponents() {
        this.pmenProps = new JPopupMenu();
        this.mitLayerName = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.mitGridEnabled = new JCheckBoxMenuItem();
        this.lblIndent = new JLabel();
        this.lblIcon = new JLabel();
        this.lblLayerName = new JLabel();
        this.prbLayer = new JProgressBar();
        this.mitLayerName.setText(NbBundle.getMessage(LayerControl.class, (String)"LayerControl.mitLayerName.text"));
        this.mitLayerName.setEnabled(false);
        this.pmenProps.add(this.mitLayerName);
        this.pmenProps.add(this.jSeparator1);
        this.mitGridEnabled.setText(NbBundle.getMessage(LayerControl.class, (String)"LayerControl.mitGridEnabled.text"));
        this.pmenProps.add(this.mitGridEnabled);
        this.setToolTipText("");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayerControl.this.formMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                LayerControl.this.formMouseEntered(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LayerControl.this.formKeyPressed(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.lblIndent, gridBagConstraints);
        this.lblIcon.setText(NbBundle.getMessage(LayerControl.class, (String)"LayerControl.lblIcon.text"));
        this.lblIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayerControl.this.lblIconMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.lblIcon, gridBagConstraints);
        this.lblLayerName.setText(NbBundle.getMessage(LayerControl.class, (String)"LayerControl.lblLayerName.text"));
        this.lblLayerName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LayerControl.this.lblLayerNameMouseClicked(evt);
            }
        });
        this.lblLayerName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LayerControl.this.lblLayerNameKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.lblLayerName, gridBagConstraints);
        this.prbLayer.setPreferredSize(new Dimension(80, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.prbLayer, gridBagConstraints);
    }

    private void lblLayerNameKeyPressed(KeyEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"LBL Key");
        }
    }

    private void formKeyPressed(KeyEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Key");
        }
        if (evt.getKeyCode() == 38) {
            this.fireLayerWantsUp();
        } else if (evt.getKeyCode() == 40) {
            this.fireLayerWantsDown();
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        this.setSelected(!this.isSelected());
        this.fireLayerSelectionChanged();
        this.requestFocus();
    }

    private void lblLayerNameMouseClicked(MouseEvent evt) {
        this.setSelected(!this.isSelected());
        this.fireLayerSelectionChanged();
        this.requestFocus();
    }

    private void formMouseEntered(MouseEvent evt) {
    }

    private void lblIconMouseClicked(MouseEvent evt) {
        if (this.getLayer() != null) {
            if (evt.getButton() == 1) {
                this.getLayer().setEnabled(!this.getLayer().isEnabled());
                this.transparentable.setVisible(this.getLayer().isEnabled());
                this.transparentable.repaint();
            }
        }
        this.syncIconWithEnabledState();
    }

    public void syncIconWithEnabledState() {
        if (this.getLayer().isEnabled()) {
            this.lblIcon.setIcon(this.visibleIcon);
            if (this.getLayer() instanceof MapService) {
                // empty if block
            }
        } else {
            this.lblIcon.setIcon(this.invisibleIcon);
            ((AbstractRetrievalService)((Object)this.getLayer())).fireRetrievalAborted(new RetrievalEvent());
        }
        this.setObjectVisible(this.getLayer().isEnabled());
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LayerControl.this.getLayer().isEnabled()) {
                    LayerControl.this.resetProgressbarColor();
                    LayerControl.this.prbLayer.setIndeterminate(true);
                }
            }
        });
    }

    @Override
    public void retrievalProgress(final RetrievalEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LayerControl.this.getLayer().isEnabled()) {
                    LayerControl.this.prbLayer.setIndeterminate(false);
                    LayerControl.this.prbLayer.setValue(100 * e.getPercentageDone());
                }
            }
        });
    }

    @Override
    public void retrievalError(final RetrievalEvent e) {
        Thread t = new Thread("LayerControl retrievalError()"){

            @Override
            public void run() {
                if (LayerControl.this.getLayer().isEnabled()) {
                    if (e.getRetrievedObject() instanceof Image) {
                        Image i = (Image)e.getRetrievedObject();
                        int newWidth = (int)((double)i.getWidth(null) * 0.7);
                        int newHeight = (int)((double)i.getHeight(null) * 0.7);
                        if (LayerControl.this.log.isDebugEnabled()) {
                            LayerControl.this.log.debug((Object)("w,h:" + newWidth + "," + newHeight));
                        }
                        Image ii = i.getScaledInstance(newWidth, newHeight, 4);
                        BufferedImage bi = new BufferedImage(newWidth, newHeight, 2);
                        Graphics2D g = (Graphics2D)bi.getGraphics();
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                        g.drawImage(i, 0, 0, newWidth, newHeight, null);
                        g.drawLine(10, 0, 20, 0);
                        int maxX = 0;
                        int maxY = 0;
                        int minX = newWidth;
                        int minY = newHeight;
                        int white = -1;
                        for (int x = 0; x < newWidth; ++x) {
                            for (int y = 0; y < newHeight; ++y) {
                                int val = bi.getRGB(x, y);
                                if (val == -1) continue;
                                if (x > maxX) {
                                    maxX = x;
                                }
                                if (x < minX) {
                                    minX = x;
                                }
                                if (y > maxY) {
                                    maxY = y;
                                }
                                if (y >= minY) continue;
                                minY = y;
                            }
                        }
                        int border = 5;
                        minX = minX - 5 < 0 ? 0 : (minX -= 5);
                        minY = minY - 5 < 0 ? 0 : (minY -= 5);
                        maxX = maxX + 5 > newWidth ? newWidth : (maxX += 5);
                        maxY = maxY + 5 > newHeight ? newHeight : (maxY += 5);
                        try {
                            bi = bi.getSubimage(minX, minY, maxX, maxY);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LayerControl.this.errorImage = bi;
                        LayerControl.this.slider.setToolTipText(NbBundle.getMessage(LayerControl.class, (String)"LayerControl.slider.toolTipText1"));
                    } else if (e.getRetrievedObject() instanceof String) {
                        LayerControl.this.errorImage = null;
                        final String message = (String)e.getRetrievedObject();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LayerControl.this.slider.setToolTipText(NbBundle.getMessage(LayerControl.class, (String)"LayerControl.slider.toolTipText2", (Object[])new Object[]{message}));
                            }
                        });
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LayerControl.this.prbLayer.setForeground(Color.RED);
                            LayerControl.this.prbLayer.setIndeterminate(false);
                            LayerControl.this.prbLayer.setValue(100);
                        }
                    });
                    if (LayerControl.this.errorAbolitionTime > 0) {
                        ActionListener timerAction = new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                LayerControl.this.resetProgressbarColor();
                            }
                        };
                        Timer timer = new Timer(LayerControl.this.errorAbolitionTime, timerAction);
                        timer.setRepeats(false);
                        timer.start();
                    }
                }
            }
        };
        CismetThreadPool.execute((Runnable)t);
    }

    @Override
    public void retrievalComplete(final RetrievalEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (LayerControl.this.getLayer().isEnabled()) {
                    if (!e.isHasErrors()) {
                        LayerControl.this.errorImage = null;
                        LayerControl.this.slider.setToolTipText("");
                        LayerControl.this.prbLayer.setIndeterminate(false);
                        LayerControl.this.prbLayer.setValue(100);
                    } else {
                        LayerControl.this.retrievalError(e);
                    }
                }
            }
        });
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LayerControl.this.prbLayer.setIndeterminate(false);
                LayerControl.this.prbLayer.setValue(0);
            }
        });
    }

    public void setIndent(String s) {
        this.lblIndent.setText(s);
    }

    public void setLayer(ServiceLayer layer) {
        this.layer = layer;
        this.lblLayerName.setText(layer.getName());
        this.mitLayerName.setText(layer.getName());
    }

    public void setTransparentable(PNode t) {
        this.transparentable = t;
        this.slider.setValue((int)(100.0f * this.transparentable.getTransparency()));
    }

    @Override
    public PNode getPNode() {
        return this.transparentable;
    }

    @Override
    public void setPNode(PNode pNode) {
        this.setTransparentable(pNode);
    }

    private float getTransparency() {
        return this.transparentable.getTransparency();
    }

    private void setTransparency(float f) {
        this.transparentable.setTransparency(f);
        this.transparentable.repaint();
    }

    private void setObjectVisible(boolean b) {
        if (this.transparentable != null) {
            this.transparentable.setVisible(b);
        } else {
            this.log.warn((Object)"transparentable was null");
        }
    }

    public void flashObject(final boolean positive, final int fadeDuration, int flashDuration) {
        final float oldTrans = this.transparentable.getTransparency();
        if (positive) {
            this.transparentable.animateToTransparency(1.0f, (long)fadeDuration);
        } else {
            this.transparentable.setTransparency(0.1f);
        }
        ActionListener timerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (positive) {
                    LayerControl.this.transparentable.animateToTransparency(oldTrans, (long)fadeDuration);
                } else {
                    LayerControl.this.transparentable.setTransparency(oldTrans);
                }
            }
        };
        Timer timer = new Timer(flashDuration, timerAction);
        timer.setRepeats(false);
        timer.start();
    }

    public boolean isRunning() {
        return this.prbLayer.isIndeterminate() || this.prbLayer.getValue() < 100;
    }

    private void resetProgressbarColor() {
        this.prbLayer.setForeground(UIManager.getDefaults().getColor("ProgressBar.foreground"));
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public ServiceLayer getLayer() {
        return this.layer;
    }

    class SliderMenuItem
    extends JSlider
    implements MenuElement {
        public SliderMenuItem() {
            this.setMajorTickSpacing(25);
            this.setMinorTickSpacing(20);
        }

        @Override
        public void processMouseEvent(MouseEvent e, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
        }

        @Override
        public MenuElement[] getSubElements() {
            return new MenuElement[0];
        }

        @Override
        public Component getComponent() {
            return this;
        }
    }

    class MousePopupListener
    extends MouseAdapter {
        MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                // empty if block
            }
        }
    }
}

