/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.simplelayerwidget;

import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.simplelayerwidget.LayerControl;
import de.cismet.cismap.commons.gui.simplelayerwidget.LayerControlSelectionChangedListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class SimpleInternalLayerWidget
extends JInternalFrame
implements MouseListener,
LayerControlSelectionChangedListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private Vector<LayerControl> rasterLayerControls = new Vector();
    private Vector<LayerControl> featureLayerControls = new Vector();
    private LayerControl featureCollectionControl;
    private MappingComponent mappingComponent;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JPanel panFeatureCollection;
    private JPanel panFeatureServices;
    private JPanel panRasterServices;

    public SimpleInternalLayerWidget(MappingComponent mappingComponent) {
        this.initComponents();
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.mappingComponent = mappingComponent;
    }

    public LayerControl showFeatureCollection(int errorAbolitionTime) {
        LayerControl control = new LayerControl(this.mappingComponent, 4, errorAbolitionTime);
        control.addLayerSelectionChangedListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panFeatureCollection.add((Component)control, gridBagConstraints);
        this.featureCollectionControl = control;
        control.addMouseListener(this);
        return control;
    }

    public LayerControl addRasterService(int position, ServiceLayer layer, int errorAbolitionTime) {
        LayerControl control = new LayerControl(this.mappingComponent, 1, errorAbolitionTime);
        control.setLayer(layer);
        control.addLayerSelectionChangedListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = position;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panRasterServices.add((Component)control, gridBagConstraints);
        this.pack();
        this.rasterLayerControls.add(control);
        control.addMouseListener(this);
        control.syncIconWithEnabledState();
        return control;
    }

    public LayerControl addFeatureService(int position, ServiceLayer layer, int errorAbolitionTime) {
        LayerControl control = new LayerControl(this.mappingComponent, 2, errorAbolitionTime);
        control.setLayer(layer);
        control.addLayerSelectionChangedListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = position;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panFeatureServices.add((Component)control, gridBagConstraints);
        this.pack();
        this.featureLayerControls.add(control);
        control.addMouseListener(this);
        control.syncIconWithEnabledState();
        return control;
    }

    private void initComponents() {
        this.panRasterServices = new JPanel();
        this.panFeatureCollection = new JPanel();
        this.panFeatureServices = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setResizable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SimpleInternalLayerWidget.this.formKeyPressed(evt);
            }
        });
        this.panRasterServices.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.panRasterServices, gridBagConstraints);
        this.panFeatureCollection.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.panFeatureCollection, gridBagConstraints);
        this.panFeatureServices.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.panFeatureServices, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator2, gridBagConstraints);
        this.pack();
    }

    private void formKeyPressed(KeyEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof LayerControl && e.getClickCount() > 1) {
            if (e.getButton() == 1) {
                LayerControl flashControl = (LayerControl)e.getSource();
                Vector<LayerControl> allControls = new Vector<LayerControl>();
                allControls.addAll(this.rasterLayerControls);
                allControls.addAll(this.featureLayerControls);
                allControls.remove(flashControl);
                flashControl.flashObject(true, 1000, 3000);
                final Iterator it = allControls.iterator();
                ActionListener timerAction = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        while (it.hasNext()) {
                            LayerControl lc = (LayerControl)it.next();
                            lc.flashObject(false, 0, 4000);
                        }
                    }
                };
                Timer timer = new Timer(1000, timerAction);
                timer.setRepeats(false);
                timer.start();
            }
        }
    }

    @Override
    public void layerControlSelectionChanged(LayerControl lc) {
    }

    @Override
    public void layerWantsUp(LayerControl lc) {
    }

    @Override
    public void layerWantsDown(LayerControl lc) {
    }
}

