/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.gui.statusbar;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.statusbar.MapExtentFixedPanel;
import de.cismet.cismap.commons.gui.statusbar.MapExtentUnfixedPanel;
import de.cismet.cismap.commons.gui.statusbar.MapScaleFixedPanel;
import de.cismet.cismap.commons.gui.statusbar.MapScaleUnfixedPanel;
import de.cismet.cismap.commons.gui.statusbar.ServicesBusyPanel;
import de.cismet.cismap.commons.gui.statusbar.ServicesErrorPanel;
import de.cismet.cismap.commons.gui.statusbar.ServicesRetrievedPanel;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.StaticDecimalTools;
import de.cismet.tools.gui.NavigatorStatusBarComponent;
import de.cismet.tools.gui.exceptionnotification.DefaultExceptionHandlerListener;
import de.cismet.tools.gui.exceptionnotification.ExceptionNotificationStatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class StatusBar
extends JPanel
implements StatusListener,
FeatureCollectionListener,
ActiveLayerListener,
NavigatorStatusBarComponent {
    String mode;
    ImageIcon defaultIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/map.png"));
    MappingComponent mappingComponent;
    private final Logger log = Logger.getLogger(this.getClass());
    private CrsTransformer transformer = null;
    private final DecimalFormat df = new DecimalFormat("0.000000");
    private int servicesCounter = 0;
    private int servicesErroneousCounter = 0;
    private Collection<ServiceLayer> services = new HashSet<ServiceLayer>();
    private Collection<ServiceLayer> erroneousServices = new HashSet<ServiceLayer>();
    private final JPanel servicesBusyPanel = new ServicesBusyPanel();
    private final JPanel servicesRetrievedPanel = new ServicesRetrievedPanel();
    private final JPanel servicesErrorPanel = new ServicesErrorPanel();
    private final JPanel mapExtentFixedPanel = new MapExtentFixedPanel();
    private final JPanel mapExtentUnfixedPanel = new MapExtentUnfixedPanel();
    private final JPanel mapScaleFixedPanel = new MapScaleFixedPanel();
    private final JPanel mapScaleUnfixedPanel = new MapScaleUnfixedPanel();
    private boolean developerMode = false;
    private ExceptionNotificationStatusPanel exceptionNotificationStatusPanel;
    private Box.Filler gluFiller;
    private JSeparator jSeparator1;
    private JLabel lblCoordinates;
    private JLabel lblCrs;
    private JLabel lblMeasurement;
    private JLabel lblScale;
    private JLabel lblStatus;
    private JLabel lblStatusImage;
    private JLabel lblWgs84Coordinates;
    private JPanel pnlFixMapExtent;
    private JPanel pnlFixMapScale;
    private JPanel pnlServicesStatus;
    private JPopupMenu pomCrs;
    private JPopupMenu pomScale;
    private JSeparator sepCoordinates;
    private JSeparator sepCrs;
    private JSeparator sepExcNotStat;
    private JSeparator sepFeedbackIcons;
    private JSeparator sepMeasurement;
    private JSeparator sepScale;
    private ServicesRetrievedPanel servicesRetrievedPanel1;

    public StatusBar() {
    }

    public StatusBar(MappingComponent mappingComponent) {
        this.init(mappingComponent);
    }

    public final void init(MappingComponent mappingComponent) {
        this.initComponents();
        this.mappingComponent = mappingComponent;
        this.lblStatusImage.setText("");
        this.lblCoordinates.setText("");
        this.lblStatusImage.setIcon(this.defaultIcon);
        this.lblCrs.setText(CismapBroker.getInstance().getSrs().getCode());
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(dfs);
        this.pnlFixMapExtent.add((Component)this.mapExtentUnfixedPanel, "Center");
        this.pnlFixMapScale.add((Component)this.mapScaleUnfixedPanel, "Center");
        try {
            this.transformer = new CrsTransformer("EPSG:4326");
        }
        catch (Exception e) {
            this.log.error((Object)"cannot create a transformer for EPSG:4326.", (Throwable)e);
        }
        this.developerMode = StaticDebuggingTools.checkHomeForFile((String)"cismetDeveloper");
        CismapBroker.getInstance().addActiveLayerListener(this);
        CismapBroker.getInstance().addStatusListener(this);
    }

    public void addCrsPopups() {
        for (Crs c : this.mappingComponent.getCrsList()) {
            if (c.isHideInCrsSwitcher()) continue;
            this.addCrsPopup(c);
        }
    }

    public void addScalePopups() {
        for (Scale s : this.mappingComponent.getScales()) {
            if (s.getDenominator() <= 0) continue;
            this.addScalePopupMenu(s.getText(), s.getDenominator());
        }
    }

    @Override
    public void statusValueChanged(final StatusEvent e) {
        Runnable modifyControls = new Runnable(){

            @Override
            public void run() {
                if (e.getName().equals("coordinate_string")) {
                    boolean showAdditionalWSG84Coords;
                    Coordinate c = (Coordinate)e.getValue();
                    Crs crs = CismapBroker.getInstance().getSrs();
                    boolean bl = showAdditionalWSG84Coords = !crs.getCode().equalsIgnoreCase("epsg:4326");
                    if (crs.isMetric()) {
                        StatusBar.this.lblCoordinates.setText(MappingComponent.getCoordinateString(c.x, c.y));
                    } else {
                        StatusBar.this.lblCoordinates.setText(StatusBar.this.transformToWGS84Coords(c));
                    }
                    if (showAdditionalWSG84Coords) {
                        StatusBar.this.lblWgs84Coordinates.setText(StatusBar.this.transformToWGS84Coords(c));
                    }
                    StatusBar.this.lblWgs84Coordinates.setVisible(showAdditionalWSG84Coords);
                    StatusBar.this.sepCoordinates.setVisible(showAdditionalWSG84Coords);
                } else if (e.getName().equals("measurement")) {
                    StatusBar.this.lblStatus.setText(e.getValue().toString());
                } else if (e.getName().equals("mode")) {
                    StatusBar.this.lblStatus.setText("");
                } else if (e.getName().equals("object_infos")) {
                    if (e.getValue() != null && e.getValue() instanceof PFeature && ((PFeature)e.getValue()).getFeature() != null && ((PFeature)e.getValue()).getFeature() instanceof XStyledFeature) {
                        StatusBar.this.lblStatus.setText(((XStyledFeature)((PFeature)e.getValue()).getFeature()).getName());
                        ImageIcon ico = ((XStyledFeature)((PFeature)e.getValue()).getFeature()).getIconImage();
                        if (ico != null && ico.getIconWidth() > 0 && ico.getIconHeight() > 0) {
                            BufferedImage imageToScale = new BufferedImage(ico.getIconWidth(), ico.getIconHeight(), 2);
                            Graphics2D g = imageToScale.createGraphics();
                            g.drawImage(ico.getImage(), 0, 0, ico.getImageObserver());
                            g.dispose();
                            StatusBar.this.lblStatusImage.setIcon(new ImageIcon(Static2DTools.getFasterScaledInstance((BufferedImage)imageToScale, (int)StatusBar.this.lblStatusImage.getWidth(), (int)StatusBar.this.lblStatusImage.getHeight(), (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR, (boolean)true)));
                        } else {
                            StatusBar.this.lblStatusImage.setIcon(StatusBar.this.defaultIcon);
                        }
                    } else if (e.getValue() != null && e.getValue() instanceof PFeature && ((PFeature)e.getValue()).getFeature() != null && ((PFeature)e.getValue()).getFeature() instanceof DefaultFeatureServiceFeature) {
                        if (((DefaultFeatureServiceFeature)((PFeature)e.getValue()).getFeature()).getSecondaryAnnotation() != null) {
                            StatusBar.this.lblStatus.setText(((DefaultFeatureServiceFeature)((PFeature)e.getValue()).getFeature()).getSecondaryAnnotation());
                        } else {
                            StatusBar.this.lblStatus.setText("");
                        }
                    } else {
                        StatusBar.this.lblStatus.setText("");
                        StatusBar.this.lblStatusImage.setIcon(StatusBar.this.defaultIcon);
                    }
                } else if (e.getName().equals("scale")) {
                    int sd = (int)(StatusBar.this.mappingComponent.getScaleDenominator() + 0.5);
                    if (e.getValue().equals("window.removed") || StatusBar.this.mappingComponent.getWidth() == 0) {
                        StatusBar.this.lblScale.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.statusValueChanged(StatusEvent).mapHidden"));
                    } else if (StatusBar.this.mappingComponent.getWidth() < 1) {
                        StatusBar.this.lblScale.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.statusValueChanged(StatusEvent).mapMinimized"));
                    } else if (StatusBar.this.developerMode) {
                        StatusBar.this.lblScale.setText("OGC: " + StatusBar.this.mappingComponent.getCurrentOGCScale() + " 1:" + sd);
                    } else {
                        StatusBar.this.lblScale.setText("1:" + sd);
                    }
                } else if (e.getName().equals("crs")) {
                    StatusBar.this.lblCrs.setText(((Crs)e.getValue()).getShortname());
                    StatusBar.this.lblCoordinates.setToolTipText(((Crs)e.getValue()).getShortname());
                } else if (e.getName().equals("retrieval.started")) {
                    if (StatusBar.this.pnlServicesStatus.getComponentCount() > 0 && !StatusBar.this.pnlServicesStatus.getComponent(0).equals(StatusBar.this.servicesBusyPanel)) {
                        StatusBar.this.pnlServicesStatus.removeAll();
                        StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesBusyPanel, "Center");
                        StatusBar.this.pnlServicesStatus.revalidate();
                        StatusBar.this.pnlServicesStatus.repaint();
                    }
                } else if (e.getName().equals("retrieval.completed") || e.getName().equals("retrieval.aborted") || e.getName().equals("retrieval.removed")) {
                    if (StatusBar.this.servicesCounter == 0) {
                        StatusBar.this.pnlServicesStatus.removeAll();
                        if (StatusBar.this.servicesErroneousCounter == 0) {
                            StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesRetrievedPanel, "Center");
                        } else {
                            StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesErrorPanel, "Center");
                        }
                        StatusBar.this.pnlServicesStatus.revalidate();
                        StatusBar.this.pnlServicesStatus.repaint();
                    }
                } else if (e.getName().equals("retrieval.error")) {
                    if (StatusBar.this.pnlServicesStatus.getComponentCount() > 0 && !StatusBar.this.pnlServicesStatus.getComponent(0).equals(StatusBar.this.servicesErrorPanel)) {
                        StatusBar.this.pnlServicesStatus.removeAll();
                        StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesErrorPanel, "Center");
                        StatusBar.this.pnlServicesStatus.revalidate();
                        StatusBar.this.pnlServicesStatus.repaint();
                    }
                } else if (e.getName().equals("map.extent.fixed")) {
                    if (e.getValue() instanceof Boolean) {
                        StatusBar.this.pnlFixMapExtent.removeAll();
                        if (((Boolean)e.getValue()).booleanValue()) {
                            StatusBar.this.pnlFixMapExtent.add((Component)StatusBar.this.mapExtentFixedPanel, "Center");
                        } else {
                            StatusBar.this.pnlFixMapExtent.add((Component)StatusBar.this.mapExtentUnfixedPanel, "Center");
                        }
                        StatusBar.this.pnlFixMapExtent.revalidate();
                        StatusBar.this.pnlFixMapExtent.repaint();
                    }
                } else if (e.getName().equals("map.scale.fixed") && e.getValue() instanceof Boolean) {
                    StatusBar.this.pnlFixMapScale.removeAll();
                    if (((Boolean)e.getValue()).booleanValue()) {
                        StatusBar.this.pnlFixMapScale.add((Component)StatusBar.this.mapScaleFixedPanel, "Center");
                    } else {
                        StatusBar.this.pnlFixMapScale.add((Component)StatusBar.this.mapScaleUnfixedPanel, "Center");
                    }
                    StatusBar.this.pnlFixMapScale.revalidate();
                    StatusBar.this.pnlFixMapScale.repaint();
                }
            }
        };
        if (e.getName().equals("mode")) {
            this.mode = (String)e.getValue();
        } else if (e.getName().equals("retrieval.started")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entered RETRIEVAL_STARTED: " + e.getValue() + " (" + System.currentTimeMillis() + ")"));
            }
            if (e.getValue() instanceof ServiceLayer) {
                ServiceLayer service = (ServiceLayer)e.getValue();
                if (this.erroneousServices.contains(service)) {
                    this.erroneousServices.remove(service);
                    --this.servicesErroneousCounter;
                }
                if (!this.services.contains(service)) {
                    this.services.add(service);
                    ++this.servicesCounter;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RETRIEVAL_STARTED (" + e.getValue() + ", " + System.currentTimeMillis() + ") - services started: " + this.servicesCounter + ", erroneous services: " + this.servicesErroneousCounter));
            }
        } else if (e.getName().equals("retrieval.completed")) {
            ServiceLayer service;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entered RETRIEVAL_COMPLETED: " + e.getValue() + " (" + System.currentTimeMillis() + ")"));
            }
            if (e.getValue() instanceof ServiceLayer && this.services.contains(service = (ServiceLayer)e.getValue())) {
                this.services.remove(service);
                --this.servicesCounter;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RETRIEVAL_COMPLETED (" + e.getValue() + ", " + System.currentTimeMillis() + ") - services started: " + this.servicesCounter + ", erroneous services: " + this.servicesErroneousCounter));
            }
        } else if (e.getName().equals("retrieval.aborted")) {
            ServiceLayer service;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entered RETRIEVAL_ABORTED: " + e.getValue() + " (" + System.currentTimeMillis() + ")"));
            }
            if (e.getValue() instanceof ServiceLayer && this.services.contains(service = (ServiceLayer)e.getValue())) {
                this.services.remove(service);
                --this.servicesCounter;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RETRIEVAL_ABORTED (" + e.getValue() + ", " + System.currentTimeMillis() + ") - services started: " + this.servicesCounter + ", erroneous services: " + this.servicesErroneousCounter));
            }
        } else if (e.getName().equals("retrieval.error")) {
            ServiceLayer service;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entered RETRIEVAL_ERROR: " + e.getValue() + " (" + System.currentTimeMillis() + ")"));
            }
            if (e.getValue() instanceof ServiceLayer && this.services.contains(service = (ServiceLayer)e.getValue())) {
                this.services.remove(service);
                --this.servicesCounter;
                this.erroneousServices.add(service);
                ++this.servicesErroneousCounter;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RETRIEVAL_ERROR (" + e.getValue() + ", " + System.currentTimeMillis() + ") - services started: " + this.servicesCounter + ", erroneous services: " + this.servicesErroneousCounter));
            }
        } else if (e.getName().equals("retrieval.removed")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entered RETRIEVAL_REMOVED: " + e.getValue() + " (" + System.currentTimeMillis() + ")"));
            }
            if (e.getValue() instanceof ServiceLayer) {
                ServiceLayer service = (ServiceLayer)e.getValue();
                if (this.services.contains(service)) {
                    this.services.remove(service);
                    --this.servicesCounter;
                }
                if (this.erroneousServices.contains(service)) {
                    this.erroneousServices.remove(service);
                    --this.servicesErroneousCounter;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RETRIEVAL_REMOVED (" + e.getValue() + ", " + System.currentTimeMillis() + ") - services started: " + this.servicesCounter + ", erroneous services: " + this.servicesErroneousCounter));
            }
        } else if (e.getName().equals("retrieval.reset")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Entered RETRIEVAL_RESET: " + e.getValue() + " (" + System.currentTimeMillis() + ")"));
            }
            if (e.getValue() instanceof ServiceLayer) {
                ServiceLayer service = (ServiceLayer)e.getValue();
                if (this.services.contains(service)) {
                    this.services.remove(service);
                    --this.servicesCounter;
                }
                if (this.erroneousServices.contains(service)) {
                    this.erroneousServices.remove(service);
                    --this.servicesErroneousCounter;
                }
            }
            this.services.clear();
            this.erroneousServices.clear();
            this.servicesCounter = 0;
            this.servicesErroneousCounter = 0;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("RETRIEVAL_RESET (" + e.getValue() + ", " + System.currentTimeMillis() + ") - services started: " + this.servicesCounter + ", erroneous services: " + this.servicesErroneousCounter));
            }
        }
        if (EventQueue.isDispatchThread()) {
            modifyControls.run();
        } else {
            EventQueue.invokeLater(modifyControls);
        }
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.pomScale = new JPopupMenu();
        this.pomCrs = new JPopupMenu();
        this.pnlServicesStatus = new JPanel();
        this.servicesRetrievedPanel1 = new ServicesRetrievedPanel();
        this.pnlFixMapExtent = new JPanel();
        this.pnlFixMapScale = new JPanel();
        this.sepFeedbackIcons = new JSeparator();
        this.lblMeasurement = new JLabel();
        this.sepMeasurement = new JSeparator();
        this.lblStatusImage = new JLabel();
        this.lblStatus = new JLabel();
        this.gluFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, 0));
        this.lblScale = new JLabel();
        this.sepScale = new JSeparator();
        this.lblCrs = new JLabel();
        this.sepCrs = new JSeparator();
        this.lblCoordinates = new JLabel();
        this.sepCoordinates = new JSeparator();
        this.lblWgs84Coordinates = new JLabel();
        this.exceptionNotificationStatusPanel = new ExceptionNotificationStatusPanel();
        this.sepExcNotStat = new JSeparator();
        this.jSeparator1.setOrientation(1);
        this.setLayout(new GridBagLayout());
        this.pnlServicesStatus.setLayout(new BorderLayout());
        this.pnlServicesStatus.add((Component)this.servicesRetrievedPanel1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.pnlServicesStatus, gridBagConstraints);
        this.pnlFixMapExtent.setMinimumSize(new Dimension(16, 16));
        this.pnlFixMapExtent.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.pnlFixMapExtent, gridBagConstraints);
        this.pnlFixMapScale.setMinimumSize(new Dimension(16, 16));
        this.pnlFixMapScale.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.pnlFixMapScale, gridBagConstraints);
        this.sepFeedbackIcons.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.sepFeedbackIcons, gridBagConstraints);
        this.lblMeasurement.setMinimumSize(new Dimension(300, 17));
        this.lblMeasurement.setPreferredSize(new Dimension(300, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblMeasurement, gridBagConstraints);
        this.sepMeasurement.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.sepMeasurement, gridBagConstraints);
        this.lblStatusImage.setMaximumSize(new Dimension(17, 17));
        this.lblStatusImage.setMinimumSize(new Dimension(17, 17));
        this.lblStatusImage.setPreferredSize(new Dimension(17, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lblStatusImage, gridBagConstraints);
        this.lblStatus.setMinimumSize(new Dimension(100, 17));
        this.lblStatus.setPreferredSize(new Dimension(100, 17));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.lblStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.gluFiller, gridBagConstraints);
        this.lblScale.setComponentPopupMenu(this.pomScale);
        this.lblScale.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                StatusBar.this.lblScaleMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.lblScale, gridBagConstraints);
        this.sepScale.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.sepScale, gridBagConstraints);
        this.lblCrs.setComponentPopupMenu(this.pomCrs);
        this.lblCrs.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                StatusBar.this.lblCrsMousePressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.lblCrs, gridBagConstraints);
        this.sepCrs.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.sepCrs, gridBagConstraints);
        this.lblCoordinates.setHorizontalAlignment(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 13;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblCoordinates, gridBagConstraints);
        this.sepCoordinates.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.sepCoordinates, gridBagConstraints);
        this.lblWgs84Coordinates.setHorizontalAlignment(4);
        this.lblWgs84Coordinates.setToolTipText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblWgs84Coordinates.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)this.lblWgs84Coordinates, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.exceptionNotificationStatusPanel, gridBagConstraints);
        this.sepExcNotStat.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 16;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.sepExcNotStat, gridBagConstraints);
    }

    private void lblScaleMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.pomScale.setVisible(true);
        }
    }

    private void lblCrsMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.pomCrs.setVisible(true);
        }
    }

    private void addCrsPopup(final Crs crs) {
        JMenuItem jmi = new JMenuItem(crs.getShortname());
        if (crs.isSelected()) {
            jmi.setText("<html><b>" + crs.getShortname() + "</b></html>");
        }
        jmi.setToolTipText(crs.getName());
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CismapBroker.getInstance().setSrs(crs);
            }
        });
        this.pomCrs.add(jmi);
    }

    private void addScalePopupMenu(String text, final double scaleDenominator) {
        JMenuItem jmi = new JMenuItem(text);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusBar.this.mappingComponent.gotoBoundingBoxWithHistory(StatusBar.this.mappingComponent.getBoundingBoxFromScale(scaleDenominator));
            }
        });
        this.pomScale.add(jmi);
    }

    private void refreshMeasurementsInStatus() {
        try {
            Collection cf = this.mappingComponent.getFeatureCollection().getSelectedFeatures();
            this.refreshMeasurementsInStatus(cf);
        }
        catch (NullPointerException ex) {
            this.log.error((Object)"Error while refreshing measurements", (Throwable)ex);
        }
    }

    private void refreshMeasurementsInStatus(Collection<Feature> cf) {
        double umfang = 0.0;
        double area = 0.0;
        for (Feature f : cf) {
            if (f == null || f.getGeometry() == null) continue;
            Geometry geo = CrsTransformer.transformToMetricCrs(f.getGeometry());
            double correctionFactor = CrsTransformer.getCrsFactor(geo.getCentroid());
            area += geo.getArea() / correctionFactor;
            umfang += geo.getLength() / correctionFactor;
        }
        if (area == 0.0 && umfang == 0.0 || cf.size() == 0) {
            this.lblMeasurement.setText("");
        } else {
            this.lblMeasurement.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblMeasurement.text", (Object[])new Object[]{StaticDecimalTools.round((double)area), StaticDecimalTools.round((double)umfang)}));
        }
    }

    @Override
    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    @Override
    public void featuresChanged(FeatureCollectionEvent fce) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"FeatureChanged");
        }
        if (this.mappingComponent.getInteractionMode().equals("NEW_POLYGON")) {
            this.refreshMeasurementsInStatus(fce.getEventFeatures());
        } else {
            this.refreshMeasurementsInStatus();
        }
    }

    @Override
    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    @Override
    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.refreshMeasurementsInStatus();
    }

    @Override
    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    @Override
    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    public JPopupMenu getPomScale() {
        return this.pomScale;
    }

    @Override
    public void featureCollectionChanged() {
    }

    private String transformToWGS84Coords(Coordinate p) {
        String result = "";
        try {
            if (this.transformer != null) {
                Coordinate[] wgs84Coord = this.transformer.transformGeometry(CismapBroker.getInstance().getSrs().getCode(), p);
                result = "(" + this.df.format(wgs84Coord[0].x) + "," + this.df.format(wgs84Coord[0].y) + ")";
            } else {
                this.log.error((Object)("Cannot transform the current coordinates: " + p));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot transform the current coordinates: " + p), (Throwable)e);
        }
        return result;
    }

    @Override
    public void layerAdded(ActiveLayerEvent e) {
    }

    @Override
    public void layerRemoved(ActiveLayerEvent e) {
        if (e.getLayer() instanceof ServiceLayer) {
            this.statusValueChanged(new StatusEvent("retrieval.removed", (ServiceLayer)e.getLayer()));
        }
    }

    @Override
    public void layerPositionChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerVisibilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerAvailabilityChanged(ActiveLayerEvent e) {
        ServiceLayer layer;
        if (e.getLayer() instanceof ServiceLayer && !(layer = (ServiceLayer)e.getLayer()).isEnabled()) {
            this.statusValueChanged(new StatusEvent("retrieval.removed", layer));
        }
    }

    @Override
    public void layerInformationStatusChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerSelectionChanged(ActiveLayerEvent e) {
    }

    public DefaultExceptionHandlerListener getExceptionHandlerListener() {
        return this.exceptionNotificationStatusPanel;
    }

    public String getViewTitle() {
        return "Statusbar";
    }

    public Component getComponent() {
        return this;
    }

    public double getWeight() {
        return 0.8;
    }

    public NavigatorStatusBarComponent.Side getSide() {
        return NavigatorStatusBarComponent.Side.LEFT;
    }

    public boolean isVisibleInStatusBar() {
        return true;
    }

    public void initialize() {
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (mapC != null) {
            this.init(mapC);
            this.addCrsPopups();
            this.addScalePopups();
            mapC.getFeatureCollection().addFeatureCollectionListener(this);
        }
    }
}

