/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.preferences;

import de.cismet.cismap.commons.featureservice.SimplePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.SimpleUpdateablePostgisFeatureService;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.preferences.CismapPreferences;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class LayersPreferences {
    final Logger log = Logger.getLogger(this.getClass());
    private final CismapPreferences cismapPreferences;
    private TreeMap rasterServices = new TreeMap();
    private TreeMap featureServices = new TreeMap();
    private boolean appFeatureLayerEnabled = true;
    private float appFeatureLayerTranslucency = 0.9f;
    private String appFeatureLayerName = "";

    public LayersPreferences(CismapPreferences cismapPreferences, Element parent) {
        this.cismapPreferences = cismapPreferences;
        try {
            this.appFeatureLayerEnabled = parent.getChild("appFeatureLayer").getAttribute("enabled").getBooleanValue();
        }
        catch (Exception e) {
            this.cismapPreferences.log.warn((Object)"Read preferences. Error. appFeatureLayer.enabled  ", (Throwable)e);
        }
        try {
            this.appFeatureLayerTranslucency = parent.getChild("appFeatureLayer").getAttribute("translucency").getFloatValue();
        }
        catch (Exception e) {
            this.cismapPreferences.log.warn((Object)"Read preferences. Error. appFeatureLayer.translucency  ", (Throwable)e);
        }
        try {
            this.appFeatureLayerName = parent.getChild("appFeatureLayer").getAttribute("name").getValue();
        }
        catch (Exception e) {
            this.cismapPreferences.log.warn((Object)"Read preferences. Error. appFeatureLayer.name  ", (Throwable)e);
        }
        List simpleWmsList = parent.getChild("rasterLayers").getChildren("simpleWms");
        for (Object o : simpleWmsList) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            try {
                boolean skip = false;
                try {
                    skip = el.getAttribute("skip").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (skip) continue;
                SimpleWMS swms = new SimpleWMS(el);
                this.rasterServices.put(new Integer(swms.getLayerPosition()), swms);
            }
            catch (Exception ex) {
                this.log.warn((Object)"Read preferences. Error. SimpleWMS erzeugen  ", (Throwable)ex);
            }
        }
        List simplePostgisFeatureServiceList = parent.getChild("featureLayers").getChildren("simplePostgisFeatureService");
        for (Object o : simplePostgisFeatureServiceList) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("parsing '" + el.getName() + "' layer preferences"));
            }
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"SimplePostgisFeatureService added");
                }
                boolean skip = false;
                boolean updateable = false;
                try {
                    skip = el.getAttribute("skip").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    updateable = el.getAttribute("updateable").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (skip) continue;
                SimplePostgisFeatureService spfs = null;
                spfs = updateable ? new SimpleUpdateablePostgisFeatureService(el) : new SimplePostgisFeatureService(el);
                this.featureServices.put(new Integer(spfs.getLayerPosition()), spfs);
            }
            catch (Exception ex) {
                this.log.warn((Object)"Read preferences. Error. Create SimplePostgisFeatureService", (Throwable)ex);
            }
        }
        List simplePostgisWebServiceList = parent.getChild("featureLayers").getChildren("simpleWebFeatureService");
        for (Object o : simplePostgisWebServiceList) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            try {
                boolean skip = false;
                boolean updateable = false;
                try {
                    skip = el.getAttribute("skip").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    updateable = el.getAttribute("updateable").getBooleanValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (skip) continue;
                WebFeatureService swfs = null;
                if (!updateable) {
                    swfs = new WebFeatureService(el);
                }
                this.featureServices.put(new Integer(swfs.getLayerPosition()), swfs);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"SimpleWebFeatureService added");
            }
            catch (Exception ex) {
                this.log.warn((Object)"Read preferences. Error. SimpleWebFeatureService erzeugen  ", (Throwable)ex);
            }
        }
    }

    public TreeMap getRasterServices() {
        return this.rasterServices;
    }

    public void setRasterServices(TreeMap rasterServices) {
        this.rasterServices = rasterServices;
    }

    public TreeMap getFeatureServices() {
        return this.featureServices;
    }

    public void setFeatureServices(TreeMap featureServices) {
        this.featureServices = featureServices;
    }

    public boolean isAppFeatureLayerEnabled() {
        return this.appFeatureLayerEnabled;
    }

    public void setAppFeatureLayerEnabled(boolean appFeatureLayerEnabled) {
        this.appFeatureLayerEnabled = appFeatureLayerEnabled;
    }

    public float getAppFeatureLayerTranslucency() {
        return this.appFeatureLayerTranslucency;
    }

    public void setAppFeatureLayerTranslucency(float appFeatureLayerTranslucency) {
        this.appFeatureLayerTranslucency = appFeatureLayerTranslucency;
    }

    public String getAppFeatureLayerName() {
        return this.appFeatureLayerName;
    }

    public void setAppFeatureLayerName(String appFeatureLayerName) {
        this.appFeatureLayerName = appFeatureLayerName;
    }
}

