/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.rasterservice.ImageRetrieval;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.tools.CurrentStackTrace;
import java.awt.Image;
import org.apache.log4j.Logger;

public abstract class AbstractWMS
extends AbstractRetrievalService
implements MapService,
RetrievalListener,
ServiceLayer {
    private static final transient Logger LOG = Logger.getLogger(AbstractWMS.class);
    protected BoundingBox bb;
    protected boolean enabled = true;
    protected int height = 0;
    protected int width = 0;
    protected volatile ImageRetrieval ir;
    protected int layerPosition = 0;
    protected String name = null;
    protected float translucency = 1.0f;
    protected boolean visible = true;

    @Override
    public void setBoundingBox(BoundingBox bb) {
        this.bb = bb;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setSize(int height, int width) {
        this.height = height;
        this.width = width;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
        this.fireRetrievalStarted(e);
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
        this.fireRetrievalProgress(e);
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
        LOG.warn((Object)"retrievalError", (Throwable)new CurrentStackTrace());
        this.fireRetrievalError(e);
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
        Object o = e.getRetrievedObject();
        if (o instanceof Image) {
            if (Math.abs(((Image)o).getHeight(null) - this.height) > 1 || Math.abs(((Image)o).getWidth(null) - this.width) > 1) {
                e.setHasErrors(true);
            } else {
                e.setHasErrors(false);
            }
        }
        if (this.ir == null || this.ir.isAlive()) {
            this.fireRetrievalComplete(e);
        }
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
        this.fireRetrievalAborted(e);
    }

    @Override
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public float getTranslucency() {
        return this.translucency;
    }

    @Override
    public void setTranslucency(float translucency) {
        this.translucency = translucency;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

