/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.piccolo.XPImage;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.preferences.CapabilityLink;
import de.cismet.cismap.commons.raster.wms.SlidableWMSServiceLayerGroupInternalFrame;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.wms.capabilities.Envelope;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.LayerBoundingBox;
import de.cismet.commons.wms.capabilities.Position;
import de.cismet.commons.wms.capabilities.WMSCapabilities;
import edu.umd.cs.piccolo.PNode;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public final class SlidableWMSServiceLayerGroup
extends AbstractRetrievalService
implements RetrievalServiceLayer,
RasterMapService,
ChangeListener,
MapService,
LayerInfoProvider,
ActiveLayerListener {
    private static final transient Logger LOG = Logger.getLogger(SlidableWMSServiceLayerGroup.class);
    public static final String XML_ELEMENT_NAME = "SlidableWMSServiceLayerGroup";
    public static final String LAYERNAME_FROM_CONFIG_SUFFIX = "$fromConfig$";
    private static final String SLIDER_PREFIX = "Slider";
    private static List<Integer> uniqueNumbers = new ArrayList<Integer>();
    private static String addedInternalWidget = null;
    private static boolean BOTTOM_UP;
    private static boolean RESOURCE_CONSERVING;
    private static int TIME_TILL_LOCKED;
    private static int INACTIVE_TIME_TILL_LOCKED;
    private static double VERTICAL_LABEL_WIDTH_THRESHOLD;
    SlidableWMSServiceLayerGroupInternalFrame internalFrame;
    private boolean printMode = false;
    private boolean resourceConserving;
    private final List<WMSServiceLayer> layers = new ArrayList<WMSServiceLayer>();
    private boolean layerQuerySelected = false;
    private final String sliderName;
    private PNode pnode = new XPImage();
    private int layerPosition;
    private String name;
    private String completePath = null;
    private Map<WMSServiceLayer, Integer> progressTable = new ConcurrentHashMap<WMSServiceLayer, Integer>();
    private AtomicInteger layerComplete = new AtomicInteger(0);
    private String preferredRasterFormat;
    private String preferredBGColor;
    private String preferredExceptionsFormat;
    private String capabilitiesUrl = null;
    private WMSCapabilities wmsCapabilities;
    private XBoundingBox boundingBox;
    private String customSLD;
    private boolean selected = false;
    private boolean locked;
    private boolean doNotDisableSlider;
    private Timer lockTimer;
    private boolean crossfadeEnabled;
    private boolean bottomUp;
    private boolean enableAllChildren;
    private int timeTillLocked;
    private int inactiveTimeTillLocked;
    private double verticalLabelWidthThreshold;
    private ActionListener btnLockListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            SlidableWMSServiceLayerGroup.this.btnLockResultsActionPerformed(evt);
        }
    };
    private ActionListener lockTimerListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SlidableWMSServiceLayerGroup.this.doNotDisableSlider = !SlidableWMSServiceLayerGroup.this.lockTimer.isRunning();
            SlidableWMSServiceLayerGroup.this.setLocked(!SlidableWMSServiceLayerGroup.this.lockTimer.isRunning());
        }
    };
    private HashMap<WMSServiceLayer, RetrievalListener> layerRetrievalListeners = new HashMap();
    private boolean enabled = true;
    private List originalTreePaths;
    private Element originalElement;
    private HashMap<String, WMSCapabilities> orginalCapabilities;
    private float translucency = 1.0f;
    private boolean reverseAxisOrder = false;

    public SlidableWMSServiceLayerGroup(List treePaths) {
        this.originalTreePaths = treePaths;
        this.sliderName = SLIDER_PREFIX + SlidableWMSServiceLayerGroup.getUniqueRandomNumber();
        TreePath tp = (TreePath)treePaths.get(0);
        Layer selectedLayer = (Layer)tp.getLastPathComponent();
        this.evaluateLayerKeywords(selectedLayer);
        List<Layer> children = Arrays.asList(selectedLayer.getChildren());
        this.lockTimer = new Timer(this.timeTillLocked * 1000, this.lockTimerListener);
        this.lockTimer.setRepeats(false);
        this.setName(selectedLayer.getTitle());
        for (Object path : tp.getPath()) {
            if (!(path instanceof Layer)) continue;
            this.completePath = this.completePath == null ? ((Layer)path).getName() : this.completePath + "/" + ((Layer)path).getName();
        }
        double maxx = Double.NaN;
        double minx = Double.NaN;
        double maxy = Double.NaN;
        double miny = Double.NaN;
        String srsCode = null;
        boolean usesMultipleSrs = false;
        if (this.bottomUp) {
            Collections.reverse(children);
        }
        for (Layer l : children) {
            Position max;
            Position min;
            boolean addLayer = false;
            if (this.enableAllChildren) {
                addLayer = true;
            } else {
                for (String keyword : l.getKeywords()) {
                    if (!keyword.equalsIgnoreCase("cismapSlidingLayerGroupMember")) continue;
                    addLayer = true;
                }
            }
            if (!addLayer) continue;
            WMSServiceLayer wsl = new WMSServiceLayer(l);
            this.layers.add(wsl);
            LayerBoundingBox[] boundingBoxes = l.getBoundingBoxes();
            if (boundingBoxes.length > 0) {
                min = boundingBoxes[0].getMin();
                max = boundingBoxes[0].getMax();
                if (srsCode == null) {
                    srsCode = boundingBoxes[0].getSRS();
                } else if (!srsCode.equalsIgnoreCase(boundingBoxes[0].getSRS())) {
                    usesMultipleSrs = true;
                }
            } else {
                Envelope envelope = l.getLatLonBoundingBoxes();
                min = envelope.getMin();
                max = envelope.getMax();
                if (srsCode == null) {
                    srsCode = "EPSG:4326";
                } else if (!srsCode.equalsIgnoreCase("EPSG:4326")) {
                    usesMultipleSrs = true;
                }
            }
            if (Double.isNaN(maxx) || maxx < max.getX()) {
                maxx = max.getX();
            }
            if (Double.isNaN(minx) || minx > min.getX()) {
                minx = min.getX();
            }
            if (Double.isNaN(maxy) || maxy < max.getY()) {
                maxy = max.getY();
            }
            if (!Double.isNaN(miny) && !(miny > min.getY())) continue;
            miny = min.getY();
        }
        if (!usesMultipleSrs && maxx != Double.NaN && minx != Double.NaN && maxy != Double.NaN && miny != Double.NaN) {
            Crs srs = CismapBroker.getInstance().crsFromCode(srsCode);
            if (srs != null) {
                this.boundingBox = new XBoundingBox(minx, miny, maxx, maxy, srs.getCode(), srs.isMetric());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Layer's SRS code '" + srsCode + "' isn't available in cismap."));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The children of '" + this.getName() + "' whether use multiple srs or don't have valid bounding boxes."));
        }
        this.init(0);
    }

    public SlidableWMSServiceLayerGroup(Element element, HashMap<String, WMSCapabilities> capabilities) {
        this.orginalCapabilities = capabilities;
        this.originalElement = element;
        this.sliderName = SLIDER_PREFIX + SlidableWMSServiceLayerGroup.getUniqueRandomNumber();
        this.setName(element.getAttributeValue("name"));
        this.lockTimer = new Timer(this.timeTillLocked * 1000, this.lockTimerListener);
        this.lockTimer.setRepeats(false);
        try {
            this.setEnabled(element.getAttribute("enabled").getBooleanValue());
        }
        catch (DataConversionException ex) {
            LOG.warn((Object)"Attribute enabled has wrong data type.", (Throwable)ex);
        }
        catch (NullPointerException ex) {
            LOG.warn((Object)"Attribute enabled not found.", (Throwable)ex);
        }
        try {
            boolean visible = element.getAttribute("visible").getBooleanValue();
            this.pnode.setVisible(visible);
        }
        catch (DataConversionException e) {
            LOG.warn((Object)"Attribute visible has wrong data type.", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"Attribute visible not found.", (Throwable)e);
        }
        try {
            this.reverseAxisOrder = element.getAttribute("reverseAxisOrder").getBooleanValue();
        }
        catch (DataConversionException e) {
            LOG.warn((Object)"Attribute reverseAxisOrder has wrong data type.", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.info((Object)"Attribute reverseAxisOrder not found.", (Throwable)e);
        }
        try {
            this.pnode.setTransparency(element.getAttribute("translucency").getFloatValue());
        }
        catch (DataConversionException e) {
            LOG.warn((Object)"Attribute translucency has wrong data type.", (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"Attribute translucency not found.", (Throwable)e);
        }
        try {
            this.completePath = element.getAttribute("completePath").getValue();
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"Attribute translucency not found.", (Throwable)e);
        }
        try {
            this.preferredBGColor = element.getAttribute("bgColor").getValue();
            this.preferredRasterFormat = element.getAttribute("imageFormat").getValue();
            this.preferredExceptionsFormat = element.getAttribute("exceptionFormat").getValue();
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"Attribute not found.", (Throwable)e);
        }
        try {
            this.boundingBox = new XBoundingBox(element);
        }
        catch (Exception ex) {
            LOG.warn((Object)"Child element BoundingBox not found.", (Throwable)ex);
        }
        Element layersElement = element.getChild("layers");
        List layersList = layersElement.getChildren();
        this.evaluateElementKeywords(element);
        if (this.bottomUp) {
            Collections.reverse(layersList);
        }
        for (Object o : layersList) {
            WMSServiceLayer l = new WMSServiceLayer((Element)o, capabilities);
            this.layers.add(l);
        }
        try {
            Element capElement = element.getChild("capabilities");
            CapabilityLink cp = new CapabilityLink(capElement);
            this.setWmsCapabilities(capabilities.get(cp.getLink()));
            this.capabilitiesUrl = cp.getLink();
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"Child element capabilities not found.", (Throwable)e);
        }
        int sliderValue = 0;
        try {
            sliderValue = element.getAttribute("sliderValue").getIntValue();
        }
        catch (DataConversionException ex) {
            LOG.warn((Object)"Could not load attribute sliderValue.", (Throwable)ex);
        }
        this.init(sliderValue);
    }

    public SlidableWMSServiceLayerGroup(String name, String completePath, Collection<Layer> layers, WMSCapabilities wmsCapabilities, String capabilitiesUrl, Crs srs) {
        this.sliderName = SLIDER_PREFIX + SlidableWMSServiceLayerGroup.getUniqueRandomNumber();
        this.setName(name);
        this.completePath = completePath;
        this.setWmsCapabilities(wmsCapabilities);
        double maxx = Double.NaN;
        double minx = Double.NaN;
        double maxy = Double.NaN;
        double miny = Double.NaN;
        this.evaluateLayerKeywords(null);
        for (Layer l : layers) {
            Position max;
            Position min;
            this.layers.add(new WMSServiceLayer(l));
            LayerBoundingBox[] boundingBoxes = l.getBoundingBoxes();
            if (boundingBoxes.length > 0) {
                min = boundingBoxes[0].getMin();
                max = boundingBoxes[0].getMax();
            } else {
                Envelope envelope = l.getLatLonBoundingBoxes();
                min = envelope.getMin();
                max = envelope.getMax();
            }
            if (Double.isNaN(maxx) || maxx < max.getX()) {
                maxx = max.getX();
            }
            if (Double.isNaN(minx) || minx > min.getX()) {
                minx = min.getX();
            }
            if (Double.isNaN(maxy) || maxy < max.getY()) {
                maxy = max.getY();
            }
            if (!Double.isNaN(miny) && !(miny > min.getY())) continue;
            miny = min.getY();
        }
        if (maxx != Double.NaN && minx != Double.NaN && maxy != Double.NaN && miny != Double.NaN) {
            this.boundingBox = new XBoundingBox(minx, miny, maxx, maxy, srs.getCode(), srs.isMetric());
        }
        this.setWmsCapabilities(wmsCapabilities);
        this.setCapabilitiesUrl(capabilitiesUrl);
        this.init(0);
    }

    public void setPrintMode(boolean printMode) {
        this.printMode = printMode;
    }

    public boolean isPrintMode() {
        return this.printMode;
    }

    private static int getUniqueRandomNumber() {
        int number = 0;
        while (uniqueNumbers.contains(number = new Random(System.currentTimeMillis()).nextInt())) {
        }
        uniqueNumbers.add(number);
        return number;
    }

    private void init(int sliderValue) {
        this.setDefaults();
        for (final WMSServiceLayer wsl : this.layers) {
            if (this.capabilitiesUrl == null) {
                this.capabilitiesUrl = wsl.getCapabilitiesUrl();
            }
            wsl.setPNode((PNode)new XPImage());
            this.pnode.addChild(wsl.getPNode());
            RetrievalListener retrievalListener = new RetrievalListener(){

                @Override
                public void retrievalStarted(RetrievalEvent e) {
                    SlidableWMSServiceLayerGroup.this.fireRetrievalStarted(e);
                }

                @Override
                public void retrievalProgress(RetrievalEvent e) {
                    RetrievalEvent event = new RetrievalEvent();
                    SlidableWMSServiceLayerGroup.this.progressTable.put(wsl, e.getPercentageDone());
                    int progress = 0;
                    Iterator iterator = SlidableWMSServiceLayerGroup.this.progressTable.values().iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        progress += i;
                    }
                    if (!SlidableWMSServiceLayerGroup.this.isLocked()) {
                        progress /= SlidableWMSServiceLayerGroup.this.layers.size();
                    }
                    SlidableWMSServiceLayerGroup.this.progress = progress;
                    event.setPercentageDone(progress);
                    SlidableWMSServiceLayerGroup.this.fireRetrievalProgress(event);
                }

                @Override
                public void retrievalComplete(final RetrievalEvent e) {
                    Image i = (Image)e.getRetrievedObject();
                    ((XPImage)wsl.getPNode()).setImage(i);
                    new Thread("SlidableWMSServiceLayerGroup retrievalComplete()"){

                        @Override
                        public void run() {
                            Point2D localOrigin = CismapBroker.getInstance().getMappingComponent().getCamera().getViewBounds().getOrigin();
                            double localScale = CismapBroker.getInstance().getMappingComponent().getCamera().getViewScale();
                            wsl.getPNode().setScale(1.0 / localScale);
                            wsl.getPNode().setOffset(localOrigin);
                            SlidableWMSServiceLayerGroup.this.layerComplete.incrementAndGet();
                            if (SlidableWMSServiceLayerGroup.this.layerComplete.get() == SlidableWMSServiceLayerGroup.this.layers.size()) {
                                CismapBroker.getInstance().getMappingComponent().repaint();
                                RetrievalEvent re = new RetrievalEvent();
                                re.setIsComplete(true);
                                re.setRetrievalService(SlidableWMSServiceLayerGroup.this);
                                re.setHasErrors(false);
                                re.setRetrievedObject(null);
                                SlidableWMSServiceLayerGroup.this.fireRetrievalComplete(re);
                                SlidableWMSServiceLayerGroup.this.stateChanged(new ChangeEvent(this));
                                SlidableWMSServiceLayerGroup.this.enableSliderAndRestartTimer();
                                SlidableWMSServiceLayerGroup.this.progressTable.clear();
                            } else if (wsl == SlidableWMSServiceLayerGroup.this.getSelectedLayer()) {
                                CismapBroker.getInstance().getMappingComponent().repaint();
                            }
                            if (SlidableWMSServiceLayerGroup.this.isPrintMode()) {
                                SlidableWMSServiceLayerGroup.this.fireRetrievalComplete(e);
                            }
                        }
                    }.start();
                }

                @Override
                public void retrievalAborted(RetrievalEvent e) {
                    SlidableWMSServiceLayerGroup.this.fireRetrievalAborted(e);
                }

                @Override
                public void retrievalError(RetrievalEvent e) {
                    SlidableWMSServiceLayerGroup.this.fireRetrievalError(e);
                }
            };
            this.layerRetrievalListeners.put(wsl, retrievalListener);
            wsl.addRetrievalListener(retrievalListener);
            if (wsl.getBackgroundColor() == null) {
                wsl.setBackgroundColor(this.preferredBGColor);
            }
            if (wsl.getExceptionsFormat() == null) {
                wsl.setExceptionsFormat(this.preferredExceptionsFormat);
            }
            if (wsl.getImageFormat() != null) continue;
            wsl.setImageFormat(this.preferredRasterFormat);
        }
        this.layers.get(0).setVisible(true);
        this.initDialog(sliderValue);
        if (SwingUtilities.isEventDispatchThread()) {
            CismapBroker.getInstance().addActiveLayerListener(this);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CismapBroker.getInstance().addActiveLayerListener(SlidableWMSServiceLayerGroup.this);
                }
            });
        }
    }

    private void evaluateElementKeywords(Element slidableLayerElement) {
        try {
            this.resourceConserving = slidableLayerElement.getAttribute("resourceConserving").getBooleanValue();
            this.timeTillLocked = slidableLayerElement.getAttribute("timeTillLocked").getIntValue();
            this.inactiveTimeTillLocked = slidableLayerElement.getAttribute("inactiveTimeTillLocked").getIntValue();
            this.bottomUp = slidableLayerElement.getAttribute("bottomUp").getBooleanValue();
            this.verticalLabelWidthThreshold = slidableLayerElement.getAttribute("verticalLabelWidthThreshold").getDoubleValue();
            this.crossfadeEnabled = slidableLayerElement.getAttribute("crossfadeEnabled").getBooleanValue();
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"Attribute not found.", (Throwable)e);
        }
        catch (DataConversionException ex) {
            LOG.warn((Object)"Attribute could not be converted.", (Throwable)ex);
        }
    }

    private void evaluateLayerKeywords(Layer selectedLayer) {
        if (selectedLayer != null) {
            Boolean resourceConserving = null;
            Integer timeTillLocked = null;
            Integer inactiveTimeTillLocked = null;
            Boolean bottomUp = null;
            Double verticalLabelWidthThreshold = null;
            this.enableAllChildren = false;
            this.crossfadeEnabled = false;
            for (String keyword : selectedLayer.getKeywords()) {
                String value;
                if (keyword.equalsIgnoreCase("cismapSlidingLayerGroup.config.resourceConserving.enabled")) {
                    resourceConserving = true;
                } else if (keyword.equalsIgnoreCase("cismapSlidingLayerGroup.config.resourceConserving.disabled")) {
                    resourceConserving = false;
                }
                if (keyword.startsWith("cismapSlidingLayerGroup.config.resourceConserving.timeTillLocked")) {
                    try {
                        value = keyword.split(":")[1];
                        timeTillLocked = Integer.parseInt(value);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"An error occured while parsing timeTillLocked. Use default value.", (Throwable)ex);
                    }
                }
                if (keyword.startsWith("cismapSlidingLayerGroup.config.resourceConserving.inactiveTimeTillLocked")) {
                    try {
                        value = keyword.split(":")[1];
                        inactiveTimeTillLocked = Integer.parseInt(value);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"An error occured while parsing inactiveTimeTillLocked. Use default value.", (Throwable)ex);
                    }
                }
                if (keyword.equalsIgnoreCase("cismapSlidingLayerGroup.config.bottomUp")) {
                    bottomUp = true;
                } else if (keyword.equalsIgnoreCase("cismapSlidingLayerGroup.config.topDown")) {
                    bottomUp = false;
                }
                if (keyword.startsWith("cismapSlidingLayerGroup.config.verticalLabelWidthThreshold")) {
                    try {
                        value = keyword.split(":")[1];
                        verticalLabelWidthThreshold = Double.parseDouble(value);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"An error occured while parsing inactiveTimeTillLocked. Use default value.", (Throwable)ex);
                    }
                }
                if (keyword.equalsIgnoreCase("cismapSlidingLayerGroup.config.enableAllChildren")) {
                    this.enableAllChildren = true;
                }
                if (!keyword.equalsIgnoreCase("cismapSlidingLayerGroup.config.crossfadeEnabled")) continue;
                this.crossfadeEnabled = true;
            }
            this.resourceConserving = resourceConserving == null ? RESOURCE_CONSERVING : resourceConserving;
            this.timeTillLocked = timeTillLocked == null ? TIME_TILL_LOCKED : timeTillLocked;
            this.inactiveTimeTillLocked = inactiveTimeTillLocked == null ? INACTIVE_TIME_TILL_LOCKED : inactiveTimeTillLocked;
            this.bottomUp = bottomUp == null ? BOTTOM_UP : bottomUp;
            this.verticalLabelWidthThreshold = verticalLabelWidthThreshold == null ? VERTICAL_LABEL_WIDTH_THRESHOLD : verticalLabelWidthThreshold;
        } else {
            this.resourceConserving = RESOURCE_CONSERVING;
            this.timeTillLocked = TIME_TILL_LOCKED;
            this.inactiveTimeTillLocked = INACTIVE_TIME_TILL_LOCKED;
            this.bottomUp = BOTTOM_UP;
            this.verticalLabelWidthThreshold = VERTICAL_LABEL_WIDTH_THRESHOLD;
            this.enableAllChildren = false;
        }
    }

    private void setDefaults() {
        this.preferredRasterFormat = "image/png";
        this.preferredBGColor = "0xF0F0F0";
        this.preferredExceptionsFormat = "application/vnd.ogc.se_xml";
    }

    public void setWmsCapabilities(WMSCapabilities wmsCapabilities) {
        this.wmsCapabilities = wmsCapabilities;
        for (WMSServiceLayer layer : this.layers) {
            layer.setWmsCapabilities(wmsCapabilities);
        }
    }

    public void setCapabilitiesUrl(String capabilitiesUrl) {
        this.capabilitiesUrl = capabilitiesUrl;
        for (WMSServiceLayer layer : this.layers) {
            layer.setCapabilitiesUrl(capabilitiesUrl);
        }
    }

    public void setSrs(String srs) {
        for (WMSServiceLayer layer : this.layers) {
            layer.setSrs(srs);
        }
    }

    private void initDialog(int sliderValue) {
        this.internalFrame = new SlidableWMSServiceLayerGroupInternalFrame(this, sliderValue);
        this.setLocked(this.resourceConserving);
    }

    private void btnLockResultsActionPerformed(ActionEvent evt) {
        this.setLocked(!this.isLocked());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.getPNode() == null) {
            return;
        }
        int i = this.internalFrame.getSliderValue() / 100;
        int rest = this.internalFrame.getSliderValue() % 100;
        for (int j = 0; j < this.getPNode().getChildrenCount(); ++j) {
            if (i == j) {
                this.getPNode().getChild(i).setTransparency(1.0f);
                continue;
            }
            this.getPNode().getChild(j).setTransparency(0.0f);
        }
        if (this.internalFrame.isAllowCrossfade() && i + 1 < this.getPNode().getChildrenCount()) {
            this.getPNode().getChild(i + 1).setTransparency((float)rest / 100.0f);
        }
        if (this.lockTimer.isRunning()) {
            this.lockTimer.restart();
        }
    }

    @Override
    public PNode getPNode() {
        return this.pnode;
    }

    @Override
    public void setPNode(PNode imageObject) {
        this.pnode = imageObject;
    }

    @Override
    public void retrieve(boolean forced) {
        if (this.enabled || forced) {
            this.progress = -1;
            this.layerComplete.set(0);
            this.progressTable.clear();
            this.internalFrame.enableSlider(false);
            this.lockTimer.stop();
            if (this.isLocked()) {
                this.getSelectedLayer().retrieve(forced);
            } else {
                for (WMSServiceLayer layer : this.layers) {
                    layer.retrieve(forced);
                }
            }
            this.setRefreshNeeded(false);
        }
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public XBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public String getPath() {
        return this.completePath;
    }

    public void setCustomSLD(String customSLD) {
        this.customSLD = customSLD;
        for (WMSServiceLayer layer : this.layers) {
            layer.setCustomSLD(this.customSLD);
        }
    }

    public String getCustomSLD() {
        return this.customSLD;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        for (WMSServiceLayer layer : this.layers) {
            layer.setEnabled(enabled);
        }
    }

    @Override
    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public float getTranslucency() {
        return this.translucency;
    }

    @Override
    public void setTranslucency(float t) {
        this.translucency = t;
    }

    @Override
    public Object clone() {
        SlidableWMSServiceLayerGroup clonedLayer;
        if (this.originalTreePaths != null) {
            clonedLayer = new SlidableWMSServiceLayerGroup(this.originalTreePaths);
            clonedLayer.setWmsCapabilities(this.wmsCapabilities);
        } else if (this.originalElement != null) {
            clonedLayer = new SlidableWMSServiceLayerGroup(this.originalElement, this.orginalCapabilities);
        } else {
            LOG.error((Object)"Could not clone SlidableWMSServiceLayerGroup.", (Throwable)new Exception());
            return null;
        }
        clonedLayer.setBoundingBox(this.boundingBox);
        clonedLayer.setCapabilitiesUrl(this.capabilitiesUrl);
        clonedLayer.setCustomSLD(this.customSLD);
        clonedLayer.setEnabled(this.enabled);
        clonedLayer.setLayerPosition(this.layerPosition);
        clonedLayer.setLayerQuerySelected(this.layerQuerySelected);
        clonedLayer.setLocked(true);
        clonedLayer.setName(this.name);
        clonedLayer.setPNode(null);
        clonedLayer.setTranslucency(this.getTranslucency());
        clonedLayer.setSliderValue(this.internalFrame.getSliderValue());
        clonedLayer.reverseAxisOrder = this.reverseAxisOrder;
        return clonedLayer;
    }

    @Override
    public boolean isVisible() {
        return this.pnode.getVisible();
    }

    @Override
    public void setBoundingBox(BoundingBox bb) {
        for (WMSServiceLayer layer : this.layers) {
            layer.setBoundingBox(bb);
        }
    }

    @Override
    public void setSize(int height, int width) {
        for (WMSServiceLayer layer : this.layers) {
            layer.setSize(height, width);
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getLayerURI() {
        return this.getName();
    }

    @Override
    public String getServerURI() {
        return this.capabilitiesUrl;
    }

    @Override
    public boolean isLayerQuerySelected() {
        return this.layerQuerySelected;
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
        this.layerQuerySelected = selected;
    }

    @Override
    public boolean isQueryable() {
        return true;
    }

    public double getVerticalLabelWidthThreshold() {
        return this.verticalLabelWidthThreshold;
    }

    public boolean isCrossfadeEnabled() {
        return this.crossfadeEnabled;
    }

    public boolean isResourceConserving() {
        return this.resourceConserving;
    }

    @Override
    public Layer getLayerInformation() {
        if (this.wmsCapabilities != null) {
            return this.getLayerInformation(null, this.wmsCapabilities.getLayer().getChildren());
        }
        return null;
    }

    private Layer getLayerInformation(String path, Layer[] layerArray) {
        if (layerArray != null) {
            for (Layer l : layerArray) {
                String currentPath;
                String string = currentPath = path == null ? l.getName() : path + "/" + l.getName();
                if (currentPath.equals(this.completePath)) {
                    return l;
                }
                Layer res = this.getLayerInformation(currentPath, l.getChildren());
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SlidableWMSServiceLayerGroup) {
            SlidableWMSServiceLayerGroup other = (SlidableWMSServiceLayerGroup)obj;
            Iterator<WMSServiceLayer> otherLayerIt = other.layers.iterator();
            for (WMSServiceLayer l : this.layers) {
                WMSServiceLayer lOther;
                if (!otherLayerIt.hasNext() || (lOther = otherLayerIt.next()).propertyEquals(l)) continue;
                return false;
            }
            return other.layers.size() == this.layers.size();
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (WMSServiceLayer l : this.layers) {
            hash += l.hashCode() % 71;
        }
        return hash;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        if (this.resourceConserving) {
            this.locked = locked;
            if (locked) {
                this.internalFrame.setLockIcon();
                this.internalFrame.enableSlider(this.doNotDisableSlider);
            } else {
                this.internalFrame.setUnlocIcon();
                this.doNotDisableSlider = false;
                this.retrieve(false);
            }
        } else {
            this.locked = false;
        }
    }

    public ActionListener getLockListener() {
        return this.btnLockListener;
    }

    private void enableSliderAndRestartTimer() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SlidableWMSServiceLayerGroup.this.internalFrame.enableSlider(true);
                SlidableWMSServiceLayerGroup.this.lockTimer.restart();
            }
        };
        if (!this.isLocked()) {
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    public List<WMSServiceLayer> getLayers() {
        return this.layers;
    }

    public Element toElement() {
        Element element = new Element(XML_ELEMENT_NAME);
        element.setAttribute("name", this.getName());
        element.setAttribute("visible", this.getPNode().getVisible() ? "true" : "false");
        element.setAttribute("enabled", Boolean.toString(this.isEnabled()));
        element.setAttribute("translucency", "" + this.getPNode().getTransparency());
        element.setAttribute("bgColor", this.preferredBGColor);
        element.setAttribute("imageFormat", this.preferredRasterFormat);
        element.setAttribute("exceptionFormat", this.preferredExceptionsFormat);
        element.setAttribute("completePath", String.valueOf(this.completePath));
        element.setAttribute("resourceConserving", Boolean.toString(this.resourceConserving));
        element.setAttribute("timeTillLocked", Integer.toString(this.timeTillLocked));
        element.setAttribute("inactiveTimeTillLocked", Integer.toString(this.inactiveTimeTillLocked));
        element.setAttribute("bottomUp", Boolean.toString(this.bottomUp));
        element.setAttribute("verticalLabelWidthThreshold", Double.toString(this.verticalLabelWidthThreshold));
        element.setAttribute("crossfadeEnabled", Boolean.toString(this.crossfadeEnabled));
        element.setAttribute("sliderValue", Integer.toString(this.internalFrame.getSliderValue()));
        if (this.boundingBox != null) {
            element.addContent((Content)this.boundingBox.getJDOMElement());
        }
        Element capElement = new Element("capabilities");
        CapabilityLink capLink = new CapabilityLink("OGC", this.capabilitiesUrl, this.reverseAxisOrder, false);
        capElement.addContent((Content)capLink.getElement());
        element.addContent((Content)capElement);
        Element layersElement = new Element("layers");
        for (WMSServiceLayer l : this.layers) {
            Element layerElement = l.getElement();
            layerElement.setAttribute("name", this.internalFrame.getTickTitle(l) + LAYERNAME_FROM_CONFIG_SUFFIX);
            layersElement.addContent((Content)layerElement);
        }
        element.addContent((Content)layersElement);
        return element;
    }

    @Override
    public void layerAdded(ActiveLayerEvent e) {
    }

    @Override
    public void layerRemoved(ActiveLayerEvent e) {
        if (e.getLayer() == this) {
            if (addedInternalWidget != null && addedInternalWidget.equals(this.sliderName)) {
                CismapBroker.getInstance().getMappingComponent().removeInternalWidget(this.sliderName);
                this.internalFrame.removeModel();
                this.internalFrame = null;
                addedInternalWidget = null;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                CismapBroker.getInstance().removeActiveLayerListener(this);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CismapBroker.getInstance().removeActiveLayerListener(SlidableWMSServiceLayerGroup.this);
                    }
                });
            }
            try {
                uniqueNumbers.remove(Integer.valueOf(this.sliderName.substring(SLIDER_PREFIX.length())));
            }
            catch (NumberFormatException ex) {
                LOG.error((Object)"The name of the internal slider widget is not valid.", (Throwable)ex);
            }
            this.lockTimer.removeActionListener(this.lockTimerListener);
            this.lockTimer.stop();
            for (WMSServiceLayer wsl : this.layers) {
                wsl.removeRetrievalListener(this.layerRetrievalListeners.get(wsl));
            }
        }
    }

    @Override
    public void layerPositionChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerVisibilityChanged(ActiveLayerEvent e) {
        if (e.getLayer() == this && this.getPNode() != null) {
            boolean fadeOutOldWidget = false;
            boolean fadeInThisWidget = false;
            if (!this.getPNode().getVisible()) {
                fadeOutOldWidget = addedInternalWidget != null && addedInternalWidget.equals(this.sliderName);
            } else {
                fadeInThisWidget = this.selected;
            }
            if (fadeOutOldWidget) {
                CismapBroker.getInstance().getMappingComponent().removeInternalWidget(addedInternalWidget);
                addedInternalWidget = null;
            }
            if (fadeInThisWidget) {
                this.internalFrame.updateHorizontalOrVertical();
                CismapBroker.getInstance().getMappingComponent().addInternalWidget(this.sliderName, 4, this.internalFrame);
                addedInternalWidget = this.sliderName;
                CismapBroker.getInstance().getMappingComponent().showInternalWidget(this.sliderName, true, 800);
            }
        }
    }

    @Override
    public void layerAvailabilityChanged(ActiveLayerEvent e) {
    }

    @Override
    public void layerInformationStatusChanged(ActiveLayerEvent e) {
    }

    @Override
    public synchronized void layerSelectionChanged(ActiveLayerEvent e) {
        boolean bl = this.selected = e.getLayer() == this;
        if (e.getLayer() == this) {
            if (addedInternalWidget != null) {
                CismapBroker.getInstance().getMappingComponent().removeInternalWidget(addedInternalWidget);
                CismapBroker.getInstance().getMappingComponent().repaint();
            }
            if (this.getPNode() != null && this.getPNode().getVisible()) {
                this.internalFrame.updateHorizontalOrVertical();
                CismapBroker.getInstance().getMappingComponent().addInternalWidget(this.sliderName, 4, this.internalFrame);
                addedInternalWidget = this.sliderName;
                CismapBroker.getInstance().getMappingComponent().showInternalWidget(this.sliderName, true, 800);
            }
        } else if (addedInternalWidget != null && !(e.getLayer() instanceof SlidableWMSServiceLayerGroup)) {
            CismapBroker.getInstance().getMappingComponent().showInternalWidget(addedInternalWidget, false, 800);
        }
        this.updateTimerDelay();
    }

    private WMSServiceLayer getSelectedLayer() {
        int i = this.internalFrame.getSliderValue() / 100;
        if (i < this.layers.size()) {
            return this.layers.get(i);
        }
        return this.layers.get(this.layers.size() - 1);
    }

    private void setSliderValue(int value) {
        this.internalFrame.setSliderValue(value);
    }

    private void updateTimerDelay() {
        if (this.selected) {
            this.lockTimer.setDelay(this.timeTillLocked * 1000);
            this.lockTimer.setInitialDelay(this.timeTillLocked * 1000);
        } else {
            this.lockTimer.setDelay(this.inactiveTimeTillLocked * 1000);
            this.lockTimer.setInitialDelay(this.inactiveTimeTillLocked * 1000);
        }
        if (this.lockTimer.isRunning()) {
            this.lockTimer.restart();
        }
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(SlidableWMSServiceLayerGroup.class.getResourceAsStream("SlidableWMSServiceLayerGroup.properties"));
            BOTTOM_UP = prop.getProperty("bottomUp", "true").trim().equalsIgnoreCase("true");
            RESOURCE_CONSERVING = prop.getProperty("resourceConserving", "false").trim().equalsIgnoreCase("true");
            TIME_TILL_LOCKED = Math.abs(Integer.parseInt(prop.getProperty("timeTillLocked", "60")));
            INACTIVE_TIME_TILL_LOCKED = Math.abs(Integer.parseInt(prop.getProperty("inactiveTimeTillLocked", "10")));
            VERTICAL_LABEL_WIDTH_THRESHOLD = Math.abs(Double.parseDouble(prop.getProperty("verticalLabelWidthThreshold", "0.5")));
        }
        catch (Exception ex) {
            LOG.error((Object)"Could not load the properties for the SlidableWMSServiceLayerGroup", (Throwable)ex);
            BOTTOM_UP = true;
            RESOURCE_CONSERVING = false;
            TIME_TILL_LOCKED = 60;
            INACTIVE_TIME_TILL_LOCKED = 10;
            VERTICAL_LABEL_WIDTH_THRESHOLD = 0.5;
        }
    }

    public static enum LabelDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

