/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.Style;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class WMSCapabilitiesTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Logger log = Logger.getLogger(this.getClass());
    private ImageIcon layersIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers.png"));
    private ImageIcon layerIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layer.png"));
    private ImageIcon layersInfoIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers_i.png"));
    private ImageIcon layerInfoIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layer_i.png"));
    private ImageIcon styleIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/style.png"));
    private ImageIcon unselectedStyleIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/style.png"));
    private ImageIcon serverIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png"));
    private DefaultTreeCellRenderer defaultRenderer;
    private ImageIcon disabledLayersIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/disabledLayers.png"));
    private ImageIcon disabledLayerIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/disabledLayer.png"));
    private ImageIcon disabledLayerInfoIcon = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/disabledLayer_i.png"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        if (value instanceof Layer) {
            Layer tmpLayer = (Layer)value;
            boolean rightScale = true;
            try {
                double mxScale = tmpLayer.getScaleDenominationMax();
                double mnScale = tmpLayer.getScaleDenominationMin();
                double scale = CismapBroker.getInstance().getMappingComponent().getCurrentOGCScale();
                if (scale < mnScale || scale > mxScale) {
                    if (!isSelected) {
                        this.setForeground(Color.GRAY);
                    }
                    rightScale = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setText(tmpLayer.getTitle());
            if (tmpLayer.isQueryable()) {
                if (tmpLayer.getChildren().length == 0) {
                    if (rightScale) {
                        this.setIcon(this.layerInfoIcon);
                    } else {
                        this.setIcon(this.disabledLayerInfoIcon);
                    }
                } else if (rightScale) {
                    this.setIcon(this.layersInfoIcon);
                } else {
                    this.setIcon(this.layersInfoIcon);
                }
            } else if (tmpLayer.getChildren().length == 0) {
                if (rightScale) {
                    this.setIcon(this.layerIcon);
                } else {
                    this.setIcon(this.disabledLayerIcon);
                }
            } else if (rightScale) {
                this.setIcon(this.layersIcon);
            } else {
                this.setIcon(this.disabledLayersIcon);
            }
        } else if (value instanceof Style) {
            Style tmpStyle = (Style)value;
            if (tmpStyle.getTitle() != null && tmpStyle.getTitle().trim().length() > 0) {
                this.setText(tmpStyle.getTitle());
            } else {
                this.setText(tmpStyle.getName());
            }
            this.setIcon(this.styleIcon);
        }
        return this;
    }
}

