/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms;

import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.raster.wms.WMSServiceLayer;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.commons.wms.capabilities.Style;

public class WMSLayer
implements LayerInfoProvider {
    private boolean enabled;
    private Style selectedStyle;
    private boolean querySelected;
    private Layer ogcCapabilitiesLayer;
    private WMSServiceLayer parentServiceLayer = null;
    private String name;
    private String styleName;

    public WMSLayer(Layer ogcCapabilitiesLayer, Style selectedStyle) {
        this.ogcCapabilitiesLayer = ogcCapabilitiesLayer;
        this.selectedStyle = selectedStyle;
        this.enabled = true;
        this.querySelected = false;
        this.selectedStyle = selectedStyle;
    }

    public WMSLayer(String name, String styleName, boolean enabled, boolean querySelected) {
        this.name = name;
        this.styleName = styleName;
        this.enabled = enabled;
        this.querySelected = querySelected;
    }

    public String toString() {
        if (this.ogcCapabilitiesLayer != null) {
            return this.ogcCapabilitiesLayer.getTitle();
        }
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled && this.parentServiceLayer != null) {
            this.parentServiceLayer.disableWhenChildrenDisabled();
        }
    }

    public Style getSelectedStyle() {
        return this.selectedStyle;
    }

    public void setSelectedStyle(Style selectedStyle) {
        this.selectedStyle = selectedStyle;
    }

    public boolean isQuerySelected() {
        return this.querySelected;
    }

    public void setQuerySelected(boolean querySelected) {
        this.querySelected = querySelected;
    }

    public Layer getOgcCapabilitiesLayer() {
        return this.ogcCapabilitiesLayer;
    }

    public void setOgcCapabilitiesLayer(Layer ogcCapabilitiesLayer) {
        this.ogcCapabilitiesLayer = ogcCapabilitiesLayer;
    }

    public boolean isSrsSupported(String srs) {
        return this.ogcCapabilitiesLayer.isSrsSupported(srs);
    }

    public WMSServiceLayer getParentServiceLayer() {
        return this.parentServiceLayer;
    }

    public void setParentServiceLayer(WMSServiceLayer parentServiceLayer) {
        this.parentServiceLayer = parentServiceLayer;
    }

    @Override
    public String getLayerURI() {
        return this.ogcCapabilitiesLayer.getName();
    }

    @Override
    public String getServerURI() {
        return this.parentServiceLayer.getCapabilitiesUrl();
    }

    @Override
    public boolean isLayerQuerySelected() {
        return this.isQuerySelected();
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
        this.setQuerySelected(selected);
    }

    @Override
    public boolean isQueryable() {
        if (this.isDummy()) {
            return this.querySelected;
        }
        return this.getOgcCapabilitiesLayer().isQueryable();
    }

    @Override
    public Layer getLayerInformation() {
        return null;
    }

    public boolean isDummy() {
        return this.ogcCapabilitiesLayer == null;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }
}

