/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.raster.wms.googlemaps;

import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.raster.wms.googlemaps.GMBoundingBox;
import de.cismet.cismap.commons.raster.wms.googlemaps.GMGISPosition;
import de.cismet.cismap.commons.rasterservice.ImageRetrieval;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import edu.umd.cs.piccolo.PNode;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GMService
extends AbstractWMS
implements RasterMapService,
RetrievalServiceLayer {
    private static long TWO_TO_THIRTYTWO = 0x100000000L;
    private static double LONG_DEGREES_PER_PIXEL = 1.0759E-5;
    private static double LAT_DEGREES_PER_PIXEL = 5.25E-6;
    private static double[] ZOOM_LEVELS = new double[]{0.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0, 300.0, 1000.0};
    private final Logger log = Logger.getLogger(this.getClass());
    private ImageRetrieval ir;
    private boolean enabled = true;
    private PNode pNode = new PNode();

    @Override
    public void retrieve(boolean forced) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"retrieve()");
        }
        GMBoundingBox real = new GMBoundingBox();
        String url = GMService.generateURL(new GMBoundingBox(new GMGISPosition(this.bb.getY1(), this.bb.getX1()), new GMGISPosition(this.bb.getY2(), this.bb.getX2())), this.width, this.height, real);
        if (this.ir != null && this.ir.isAlive() && this.ir.getUrl().equals(url.toString()) && !forced) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"multiple invocations with the same url = humbug");
            }
        } else {
            if (this.ir != null && this.ir.isAlive()) {
                this.ir.youngerWMSCall();
                this.ir.interrupt();
            }
            this.ir = new ImageRetrieval(this);
            this.ir.setUrl(url);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"ir.start();");
            }
            this.ir.setPriority(5);
            this.ir.start();
        }
    }

    @Override
    public Object clone() {
        return new GMService();
    }

    @Override
    public PNode getPNode() {
        return this.pNode;
    }

    @Override
    public void setPNode(PNode pNode) {
        this.pNode = pNode;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public int getLayerPosition() {
        return -1;
    }

    @Override
    public void setLayerPosition(int layerPosition) {
    }

    @Override
    public float getTranslucency() {
        return 0.5f;
    }

    @Override
    public void setTranslucency(float t) {
    }

    @Override
    public String getName() {
        return "GM";
    }

    @Override
    public void setName(String name) {
    }

    public static String generateURL(GMBoundingBox box, int image_width, int image_height, GMBoundingBox result) {
        GMGISPosition position = box.middle();
        double width = box.width();
        String URL2 = null;
        int ZoomLevel = 1;
        double Magnification = 0.0;
        double longtitude = new BigDecimal(position.getLongitude()).setScale(6, 5).doubleValue();
        double latitude = new BigDecimal(position.getLatitude()).setScale(6, 5).doubleValue();
        double pixelwidth = (double)image_width * LONG_DEGREES_PER_PIXEL;
        Magnification = width < pixelwidth ? ZOOM_LEVELS[0] : (width < pixelwidth * ZOOM_LEVELS[1] ? ZOOM_LEVELS[1] : (width < pixelwidth * ZOOM_LEVELS[2] ? ZOOM_LEVELS[2] : (width < pixelwidth * ZOOM_LEVELS[3] ? ZOOM_LEVELS[3] : (width < pixelwidth * ZOOM_LEVELS[4] ? ZOOM_LEVELS[4] : (width < pixelwidth * ZOOM_LEVELS[5] ? ZOOM_LEVELS[5] : (width < pixelwidth * ZOOM_LEVELS[6] ? ZOOM_LEVELS[6] : (width < pixelwidth * ZOOM_LEVELS[7] ? ZOOM_LEVELS[7] : (width < pixelwidth * ZOOM_LEVELS[8] ? ZOOM_LEVELS[8] : ZOOM_LEVELS[9]))))))));
        ZoomLevel = new Double((double)image_width * (1.0 + Magnification)).intValue();
        longtitude *= 1000000.0;
        latitude *= 1000000.0;
        if (longtitude < 0.0) {
            longtitude += (double)TWO_TO_THIRTYTWO;
        }
        if (latitude < 0.0) {
            latitude += (double)TWO_TO_THIRTYTWO;
        }
        URL2 = "http://maps.google.com/mapdata?latitude_e6=" + new BigDecimal(latitude).setScale(0, 5) + "&longitude_e6=" + new BigDecimal(longtitude).setScale(0, 5) + "&zm=" + ZoomLevel + "&cc=us&min_priority=2&w=" + image_width + "&h=" + image_height;
        if (Magnification == 0.0) {
            Magnification = 1.0;
        }
        double long_half = (double)(image_width / 2) * (LONG_DEGREES_PER_PIXEL * Magnification);
        double dpp = 1.075E-5 * Math.cos(position.latitude * Math.PI / 180.0);
        double lat_half = (double)(image_height / 2) * (dpp * Magnification);
        GMGISPosition topLeft = new GMGISPosition(position.latitude - lat_half, position.longitude - long_half);
        GMGISPosition bottomRight = new GMGISPosition(position.latitude + lat_half, position.longitude + long_half);
        result.setBottomRight(bottomRight);
        result.setTopLeft(topLeft);
        return URL2;
    }
}

