/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.LayerInfoProvider;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.rasterservice.ImageFileRetrieval;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.rasterservice.RasterMapService;
import de.cismet.cismap.commons.retrieval.AbstractRetrievalService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.commons.wms.capabilities.Layer;
import de.cismet.tools.CurrentStackTrace;
import edu.umd.cs.piccolo.PNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.httpclient.HttpClient;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class ImageRasterService
extends AbstractRetrievalService
implements MapService,
RasterMapService,
RetrievalServiceLayer,
LayerInfoProvider,
RetrievalListener,
ServiceLayer {
    private final Logger LOG = Logger.getLogger(this.getClass());
    private File imageFile;
    private ImageFileRetrieval ir;
    private PNode pNode;
    private String name = "ImageRasterService";
    private HttpClient preferredClient = null;
    private BoundingBox bb;
    private boolean enabled = true;
    private int height = 0;
    private int width = 0;
    private int layerPosition = 0;
    private float translucency = 1.0f;
    private boolean visible = true;
    private Geometry envelope;
    private ImageFileUtils.Mode mode;

    public ImageRasterService(ImageRasterService s) {
        this(s.imageFile, s.mode);
        if (s.bb != null) {
            this.bb = (BoundingBox)s.bb.clone();
        }
        this.enabled = s.enabled;
        this.height = s.height;
        this.layerPosition = s.layerPosition;
        this.name = s.name;
        this.translucency = s.translucency;
        this.width = s.width;
        this.ir = new ImageFileRetrieval(s.imageFile, this, s.mode);
        this.listeners = new ArrayList();
        this.listeners = Collections.synchronizedList(this.listeners);
        this.listeners.addAll(s.listeners);
    }

    public ImageRasterService(Element object) throws Exception {
        File worldFile;
        Attribute translucencyAttr;
        Attribute visAttr;
        Attribute nameAttr;
        Attribute enabledAttr;
        String filePath = object.getTextTrim();
        this.imageFile = new File(filePath);
        Attribute layerPositionAttr = object.getAttribute("layerPosition");
        if (layerPositionAttr != null) {
            try {
                this.layerPosition = layerPositionAttr.getIntValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((enabledAttr = object.getAttribute("enabled")) != null) {
            try {
                this.enabled = enabledAttr.getBooleanValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((nameAttr = object.getAttribute("name")) != null) {
            try {
                this.name = nameAttr.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((visAttr = object.getAttribute("visible")) != null) {
            try {
                this.visible = visAttr.getBooleanValue();
                this.pNode.setVisible(this.visible);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((translucencyAttr = object.getAttribute("translucency")) != null) {
            try {
                this.setTranslucency(translucencyAttr.getFloatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mode = (worldFile = ImageFileUtils.getWorldFile(this.imageFile)) != null ? (ImageFileUtils.checkIfRasterGeoRef(worldFile) ? ImageFileUtils.Mode.GEO_REFERENCED : ImageFileUtils.Mode.WORLDFILE) : ImageFileUtils.Mode.TIFF;
    }

    public ImageRasterService(File imageFile, ImageFileUtils.Mode mode) {
        this.imageFile = imageFile;
        this.name = imageFile.getName();
        this.mode = mode;
    }

    public ImageFileUtils.Mode getMode() {
        return this.mode;
    }

    public Element getElement() {
        Element element = new Element("ImageRasterService");
        element.setAttribute("layerPosition", Integer.toString(this.layerPosition));
        element.setAttribute("type", this.getClass().getName());
        element.setAttribute("enabled", Boolean.toString(this.enabled));
        element.setAttribute("visible", Boolean.toString(this.pNode.getVisible()));
        element.setAttribute("name", this.name);
        element.setAttribute("translucency", Float.toString(this.translucency));
        CDATA data = new CDATA(this.imageFile.getAbsolutePath());
        element.addContent((Content)data);
        return element;
    }

    @Override
    public synchronized void retrieve(boolean forced) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"retrieve()");
        }
        ImageFileRetrieval ifr = new ImageFileRetrieval(this.imageFile, this, this.mode);
        ifr.setHeight(this.height);
        ifr.setWidth(this.width);
        ifr.setX1(this.bb.getX1());
        ifr.setY1(this.bb.getY1());
        ifr.setX2(this.bb.getX2());
        ifr.setY2(this.bb.getY2());
        if (this.ir != null && this.ir.isAlive() && ifr.equals(this.ir) && !forced) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"multiple invocations with the same url = humbug");
            }
        } else {
            if (this.ir != null && this.ir.isAlive()) {
                this.ir.youngerCall();
                this.ir.interrupt();
                this.retrievalAborted(new RetrievalEvent());
            }
            if (this.ir != null) {
                ifr.copyMetaData(this.ir);
            }
            this.ir = ifr;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"ir.start();");
            }
            this.ir.setPriority(5);
            this.ir.start();
        }
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    @Override
    public void setPNode(PNode imageObject) {
        this.pNode = imageObject;
    }

    @Override
    public PNode getPNode() {
        return this.pNode;
    }

    @Override
    public Object clone() {
        return new ImageRasterService(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    public HttpClient getPreferredClient() {
        return this.preferredClient;
    }

    public void setPreferredClient(HttpClient preferredClient) {
        this.preferredClient = preferredClient;
    }

    @Override
    public String getLayerURI() {
        return this.imageFile.getAbsolutePath();
    }

    @Override
    public String getServerURI() {
        return this.imageFile.getAbsolutePath();
    }

    @Override
    public boolean isLayerQuerySelected() {
        return false;
    }

    @Override
    public void setLayerQuerySelected(boolean selected) {
    }

    @Override
    public boolean isQueryable() {
        return false;
    }

    @Override
    public Layer getLayerInformation() {
        return null;
    }

    public Geometry getEnvelope() {
        if (this.envelope == null) {
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));
            Envelope en = new ImageFileRetrieval(this.imageFile, this, this.mode).getEnvelope();
            if (en != null) {
                this.envelope = gf.toGeometry(en);
            }
        }
        return this.envelope;
    }

    @Override
    public void setBoundingBox(BoundingBox bb) {
        this.bb = bb;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setSize(int height, int width) {
        this.height = height;
        this.width = width;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public void retrievalStarted(RetrievalEvent e) {
        this.fireRetrievalStarted(e);
    }

    @Override
    public void retrievalProgress(RetrievalEvent e) {
        this.fireRetrievalProgress(e);
    }

    @Override
    public void retrievalError(RetrievalEvent e) {
        this.LOG.warn((Object)"retrievalError", (Throwable)new CurrentStackTrace());
        this.fireRetrievalError(e);
    }

    @Override
    public void retrievalComplete(RetrievalEvent e) {
        if (this.ir == null || this.ir.isAlive()) {
            this.fireRetrievalComplete(e);
        }
    }

    @Override
    public void retrievalAborted(RetrievalEvent e) {
        this.fireRetrievalAborted(e);
    }

    @Override
    public int getLayerPosition() {
        return this.layerPosition;
    }

    @Override
    public void setLayerPosition(int layerPosition) {
        this.layerPosition = layerPosition;
    }

    @Override
    public float getTranslucency() {
        return this.translucency;
    }

    @Override
    public void setTranslucency(float translucency) {
        this.translucency = translucency;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

