/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.rasterservice.georeferencing;

import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingDialog;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingHandler;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizard;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingWizardListener;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RasterGeoReferencingToolbarComponentProvider
extends JPanel
implements ToolbarComponentsProvider,
CidsUiComponent {
    private static final String PLUGIN_NAME = "RASTER_GEO_REFERENCING";
    private final List<ToolbarComponentDescription> toolbarComponents = new ArrayList<ToolbarComponentDescription>();
    private JToggleButton btnRasterGeoRef;

    public RasterGeoReferencingToolbarComponentProvider() {
        this.initComponents();
        if (CismapBroker.getInstance().isEnableRasterGeoReferencingToolbar()) {
            this.getToolbarComponents().add(this.getToolbarComponentDescription());
            CismapBroker.getInstance().addStatusListener(new MapStatusListenerHandler());
            RasterGeoReferencingWizard.getInstance().addListener(new WizardListenerHandler());
        }
    }

    private ToolbarComponentDescription getToolbarComponentDescription() {
        return new ToolbarComponentDescription("tlbMain", this.btnRasterGeoRef, ToolbarComponentsProvider.ToolbarPositionHint.AFTER, "cmdPan", true);
    }

    private void initComponents() {
        this.btnRasterGeoRef = new JToggleButton();
        this.setLayout(new GridBagLayout());
        this.btnRasterGeoRef.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/rasterservice/georeferencing/georef.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRasterGeoRef, (String)NbBundle.getMessage(RasterGeoReferencingToolbarComponentProvider.class, (String)"RasterGeoReferencingToolbarComponentProvider.btnRasterGeoRef.text"));
        this.btnRasterGeoRef.setEnabled(false);
        this.btnRasterGeoRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterGeoReferencingToolbarComponentProvider.this.btnRasterGeoRefActionPerformed(evt);
            }
        });
        this.add((Component)this.btnRasterGeoRef, new GridBagConstraints());
    }

    private void btnRasterGeoRefActionPerformed(ActionEvent evt) {
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("GEO_REF");
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    public String getValue(String key) {
        if (key.equals("CidsActionKey")) {
            return "RasterGeoReferencingToolbar";
        }
        return null;
    }

    public Component getComponent() {
        return this.btnRasterGeoRef;
    }

    public List<ToolbarComponentDescription> getToolbarComponents() {
        return this.toolbarComponents;
    }

    private class WizardListenerHandler
    implements RasterGeoReferencingWizardListener {
        private WizardListenerHandler() {
        }

        @Override
        public void pointSelected(int position) {
        }

        @Override
        public void coordinateSelected(int position) {
        }

        @Override
        public void handlerChanged(RasterGeoReferencingHandler handler) {
            RasterGeoReferencingToolbarComponentProvider.this.btnRasterGeoRef.setEnabled(handler != null);
        }

        @Override
        public void positionAdded(int position) {
        }

        @Override
        public void positionRemoved(int position) {
        }

        @Override
        public void positionChanged(int position) {
        }

        @Override
        public void transformationChanged() {
        }
    }

    private class MapStatusListenerHandler
    implements StatusListener {
        private MapStatusListenerHandler() {
        }

        @Override
        public void statusValueChanged(StatusEvent evt) {
            if ("mode".equals(evt.getName())) {
                if ("GEO_REF".equals(evt.getValue())) {
                    RasterGeoReferencingToolbarComponentProvider.this.btnRasterGeoRef.setSelected(true);
                    if (!RasterGeoReferencingDialog.getInstance().isVisible()) {
                        StaticSwingTools.showDialog((JDialog)RasterGeoReferencingDialog.getInstance());
                    }
                } else {
                    RasterGeoReferencingToolbarComponentProvider.this.btnRasterGeoRef.setSelected(false);
                    RasterGeoReferencingDialog.getInstance().setVisible(false);
                }
                if (RasterGeoReferencingWizard.getInstance().getHandler() != null && RasterGeoReferencingWizard.getInstance().getHandler().getFeature() != null) {
                    RasterGeoReferencingWizard.getInstance().getHandler().getFeature().transformationChanged();
                }
            }
        }
    }
}

