/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.tools.ShapeWriter;
import de.cismet.cismap.commons.tools.SimpleFeatureCollection;
import java.io.File;
import java.util.List;
import org.deegree.io.shpapi.shape_new.ShapeFile;
import org.deegree.io.shpapi.shape_new.ShapeFileWriter;
import org.deegree.model.feature.FeatureCollection;

public class DefaultShapeWriter
implements ShapeWriter {
    @Override
    public void writeShape(FeatureServiceFeature[] features, List<String[]> aliasAttributeList, File fileToSaveTo) throws Exception {
        SimpleFeatureCollection fc = new SimpleFeatureCollection(this.getId(), features, aliasAttributeList);
        ShapeFile shape = new ShapeFile((FeatureCollection)fc, fileToSaveTo.getAbsolutePath().substring(0, fileToSaveTo.getAbsolutePath().lastIndexOf(".")));
        ShapeFileWriter writer = new ShapeFileWriter(shape);
        writer.write();
    }

    @Override
    public void writeDbf(FeatureServiceFeature[] features, List<String[]> aliasAttributeList, File fileToSaveTo) throws Exception {
        this.writeShape(features, aliasAttributeList, fileToSaveTo);
        if (fileToSaveTo.getAbsolutePath().toLowerCase().endsWith(".dbf")) {
            String fileNameWithoutExt = fileToSaveTo.getAbsolutePath().substring(0, fileToSaveTo.getAbsolutePath().length() - 4);
            String fileName = fileNameWithoutExt + ".shp";
            this.deleteFileIfExists(fileName);
            fileName = fileNameWithoutExt + ".shx";
            this.deleteFileIfExists(fileName);
        }
    }

    private String getId() {
        return String.valueOf(System.currentTimeMillis());
    }

    private void deleteFileIfExists(String fileName) {
        File fileToDelete = new File(fileName);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }
}

