/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PersistentFeature;
import de.cismet.cismap.commons.tools.ExportDownload;
import de.cismet.cismap.commons.tools.GeometryUtils;
import de.cismet.cismap.commons.tools.ShapeWriter;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.File;
import java.util.Collection;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExportShapeDownload
extends ExportDownload {
    public ExportShapeDownload() {
    }

    public ExportShapeDownload(String filename, String extension, FeatureServiceFeature[] features) {
        this.init(filename, extension, features, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        try {
            this.status = Download.State.RUNNING;
            this.stateChanged();
            try {
                this.loadFeaturesIfRequired();
            }
            catch (Exception e) {
                log.error((Object)"Error while retrieving features", (Throwable)e);
                this.error(e);
                this.features = null;
                this.service = null;
                return;
            }
            if (this.features != null && this.features.length > 0) {
                try {
                    Collection writer = Lookup.getDefault().lookupAll(ShapeWriter.class);
                    if (writer.size() > 0) {
                        if (this.getDefaultExtension().equalsIgnoreCase(".dbf")) {
                            ((ShapeWriter)writer.iterator().next()).writeDbf(this.features, this.aliasAttributeList, this.fileToSaveTo);
                        } else {
                            ((ShapeWriter)writer.iterator().next()).writeShape(this.features, this.aliasAttributeList, this.fileToSaveTo);
                        }
                    }
                }
                catch (Exception ex) {
                    this.error(ex);
                }
                if (this.features[0] instanceof PersistentFeature) {
                    ((PersistentFeature)this.features[0]).getPersistenceManager().close();
                }
            } else {
                try {
                    String filenameStem;
                    block28: {
                        Collection writer;
                        FeatureServiceFeature feature = this.service.getFeatureFactory().createNewFeature();
                        String geometryType = this.service.getGeometryType();
                        if (!this.getDefaultExtension().equalsIgnoreCase(".dbf")) {
                            Geometry g = GeometryUtils.createDummyGeometry(geometryType);
                            feature.setGeometry(g);
                        }
                        this.features = new FeatureServiceFeature[]{feature};
                        filenameStem = this.fileToSaveTo.getAbsolutePath();
                        if (filenameStem.contains(".")) {
                            filenameStem = filenameStem.substring(0, filenameStem.indexOf("."));
                        }
                        if ((writer = Lookup.getDefault().lookupAll(ShapeWriter.class)).size() > 0) {
                            if (this.getDefaultExtension().equalsIgnoreCase(".dbf")) {
                                ((ShapeWriter)writer.iterator().next()).writeDbf(this.features, this.aliasAttributeList, this.fileToSaveTo);
                            } else {
                                ((ShapeWriter)writer.iterator().next()).writeShape(this.features, this.aliasAttributeList, this.fileToSaveTo);
                            }
                        }
                        byte shpGeoType = GeometryUtils.getShpGeometryType(geometryType);
                        try {
                            GeometryUtils.clearShpOrShxFile(filenameStem + ".shp", shpGeoType);
                            GeometryUtils.clearShpOrShxFile(filenameStem + ".shx", shpGeoType);
                            GeometryUtils.clearDbfFile(filenameStem + ".dbf");
                        }
                        catch (Exception e) {
                            log.error((Object)"Cannot remove content from shape. So remove it completely", (Throwable)e);
                            File shapeFile = new File(filenameStem + ".shp");
                            File shxFile = new File(filenameStem + ".shx");
                            File dbfFile = new File(filenameStem + ".dbf");
                            if (shapeFile.exists()) {
                                shapeFile.delete();
                            }
                            if (shxFile.exists()) {
                                shxFile.delete();
                            }
                            if (!dbfFile.exists()) break block28;
                            dbfFile.delete();
                        }
                    }
                    if (this.getDefaultExtension().equalsIgnoreCase(".dbf")) {
                        String shpFileName = filenameStem + ".shp";
                        this.deleteFileIfExists(shpFileName);
                        shpFileName = filenameStem + ".shx";
                        this.deleteFileIfExists(shpFileName);
                    }
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
        }
        finally {
            this.features = null;
            this.service = null;
        }
    }

    private void deleteFileIfExists(String fileName) {
        File fileToDelete = new File(fileName);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }

    private String getId() {
        return String.valueOf(System.currentTimeMillis());
    }

    @Override
    public String getDefaultExtension() {
        return ".shp";
    }

    public String toString() {
        return NbBundle.getMessage(ExportShapeDownload.class, (String)"ExportShapeDownload.toString");
    }
}

