/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FeatureTools {
    private static final Logger LOG = Logger.getLogger(FeatureTools.class);
    public static final DecimalFormat FORMATTER = new DecimalFormat();

    public static Class<?> getClass(FeatureServiceAttribute attr) {
        if (attr.isGeometry()) {
            return String.class;
        }
        if (attr.getType().equals(String.valueOf(1)) || attr.getType().equals(String.valueOf(12)) || attr.getType().equals(String.valueOf(-1))) {
            return String.class;
        }
        if (attr.getType().equals(String.valueOf(4)) || attr.getType().equals(String.valueOf(5)) || attr.getType().equals(String.valueOf(-6)) || attr.getType().equals("xsd:integer")) {
            return Integer.class;
        }
        if (attr.getType().equals(String.valueOf(-5)) || attr.getType().equals("xsd:long")) {
            return Long.class;
        }
        if (attr.getType().equals(String.valueOf(8)) || attr.getType().equals(String.valueOf(6)) || attr.getType().equals(String.valueOf(3)) || attr.getType().equals("xsd:float") || attr.getType().equals("xsd:decimal") || attr.getType().equals("xsd:double")) {
            return Double.class;
        }
        if (attr.getType().equals(String.valueOf(2))) {
            return BigDecimal.class;
        }
        if (attr.getType().equals(String.valueOf(91)) || attr.getType().equals(String.valueOf(92)) || attr.getType().equals(String.valueOf(93))) {
            return Date.class;
        }
        if (attr.getType().equals(String.valueOf(16)) || attr.getType().equals("xsd:boolean")) {
            return Boolean.class;
        }
        return String.class;
    }

    public static String getType(Class cl) {
        if (Geometry.class.isAssignableFrom(cl)) {
            return String.valueOf(10012);
        }
        if (cl.getName().endsWith("String")) {
            return String.valueOf(12);
        }
        if (cl.getName().endsWith("Integer") || cl.getName().equals("int")) {
            return String.valueOf(4);
        }
        if (cl.getName().endsWith("Long") || cl.getName().equals("long")) {
            return String.valueOf(-5);
        }
        if (cl.getName().endsWith("Double") || cl.getName().equals("double") || cl.getName().endsWith("Float") || cl.getName().equals("float")) {
            return String.valueOf(8);
        }
        if (cl.getName().endsWith("Date")) {
            return String.valueOf(91);
        }
        if (cl.getName().endsWith("Timestamp")) {
            return String.valueOf(93);
        }
        if (cl.getName().endsWith("Boolean") || cl.getName().equals("boolean")) {
            return String.valueOf(16);
        }
        if (cl.getName().endsWith("BigDecimal")) {
            return String.valueOf(2);
        }
        return String.valueOf(12);
    }

    public static String getH2DataType(FeatureServiceAttribute attr) {
        if (attr.isGeometry()) {
            return "Geometry";
        }
        if (attr.getType().equals(String.valueOf(1)) || attr.getType().equals(String.valueOf(12)) || attr.getType().equals(String.valueOf(-1))) {
            return "VARCHAR";
        }
        if (attr.getType().equals(String.valueOf(4)) || attr.getType().equals(String.valueOf(5)) || attr.getType().equals(String.valueOf(-6)) || attr.getType().equals("xsd:integer")) {
            return "Integer";
        }
        if (attr.getType().equals(String.valueOf(-5)) || attr.getType().equals("xsd:long")) {
            return "BIGINT";
        }
        if (attr.getType().equals(String.valueOf(8)) || attr.getType().equals(String.valueOf(6)) || attr.getType().equals(String.valueOf(3)) || attr.getType().equals("xsd:float") || attr.getType().equals("xsd:decimal") || attr.getType().equals("xsd:double")) {
            return "Double";
        }
        if (attr.getType().equals(String.valueOf(91)) || attr.getType().equals(String.valueOf(92)) || attr.getType().equals(String.valueOf(93))) {
            return "Timestamp";
        }
        if (attr.getType().equals(String.valueOf(2))) {
            return "NUMERIC";
        }
        if (attr.getType().equals(String.valueOf(16)) || attr.getType().equals("xsd:boolean")) {
            return "Boolean";
        }
        if (attr.getType().equalsIgnoreCase("geometry")) {
            return "Geometry";
        }
        return attr.getType();
    }

    public static Object convertObjectToClass(Object object, Class cl) throws Exception {
        String objectAsString = String.valueOf(object);
        if (object == null) {
            return object;
        }
        try {
            if (cl.equals(String.class)) {
                if (object instanceof Float || object instanceof Double) {
                    return FORMATTER.format(object);
                }
                return objectAsString;
            }
            if (cl.equals(Double.class)) {
                return Double.parseDouble(objectAsString.replace(",", "."));
            }
            if (cl.equals(Float.class)) {
                return Float.valueOf(Float.parseFloat(objectAsString.replace(",", ".")));
            }
            if (cl.equals(Integer.class)) {
                try {
                    return Integer.parseInt(objectAsString);
                }
                catch (NumberFormatException e) {
                    Double d = Double.parseDouble(objectAsString.replace(",", "."));
                    return d.intValue();
                }
            }
            if (cl.equals(Boolean.class)) {
                return Boolean.parseBoolean(objectAsString);
            }
            if (cl.equals(Long.class)) {
                try {
                    return Long.parseLong(objectAsString);
                }
                catch (NumberFormatException e) {
                    Double d = Double.parseDouble(objectAsString.replace(",", "."));
                    return d.longValue();
                }
            }
            if (cl.equals(Date.class)) {
                return Timestamp.valueOf(objectAsString);
            }
            if (cl.equals(BigDecimal.class)) {
                return new BigDecimal(objectAsString.replace(",", "."));
            }
            return object;
        }
        catch (Exception e) {
            LOG.error((Object)("Wrong data type: " + objectAsString + " expected type: " + cl.toString()), (Throwable)e);
            throw new Exception(NbBundle.getMessage(FeatureTools.class, (String)"FeatureTools.convertObjectToClass.message", (Object)objectAsString, (Object)cl.getName()));
        }
    }

    public static AbstractNewFeature.geomTypes getGeomType(Geometry geom) {
        String jtsGeomType = geom.getGeometryType();
        if ("Polygon".equals(jtsGeomType)) {
            if (geom.isRectangle()) {
                return AbstractNewFeature.geomTypes.RECTANGLE;
            }
            return AbstractNewFeature.geomTypes.POLYGON;
        }
        if ("Point".equals(jtsGeomType)) {
            return AbstractNewFeature.geomTypes.POINT;
        }
        if ("LineString".equals(jtsGeomType)) {
            return AbstractNewFeature.geomTypes.LINESTRING;
        }
        if ("MultiPolygon".equals(jtsGeomType)) {
            return AbstractNewFeature.geomTypes.MULTIPOLYGON;
        }
        return AbstractNewFeature.geomTypes.UNKNOWN;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        FORMATTER.setDecimalFormatSymbols(symbols);
        FORMATTER.setGroupingUsed(false);
    }
}

