/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.tools;

import de.cismet.cismap.commons.ErroneousRetrievalServiceProvider;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.retrieval.RetrievalService;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class FutureImageDownload
extends AbstractDownload
implements Cancellable {
    private static final Logger LOG = Logger.getLogger(FutureImageDownload.class);
    String extension;
    Future<Image> futureImage;
    int futureImageHash;

    public FutureImageDownload(String filename, String extension, String title, File fileToSaveTo, Future<Image> futureImage) {
        this.extension = extension;
        this.futureImage = futureImage;
        this.futureImageHash = futureImage.hashCode();
        this.title = title;
        this.status = Download.State.WAITING;
        this.fileToSaveTo = fileToSaveTo;
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            this.releaseMemory();
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        Image image = null;
        if (this.futureImage != null) {
            try {
                if (!Thread.interrupted()) {
                    ErroneousRetrievalServiceProvider p;
                    HashSet<RetrievalService> layers;
                    image = this.futureImage.get();
                    if (this.futureImage instanceof ErroneousRetrievalServiceProvider && (layers = (p = (ErroneousRetrievalServiceProvider)((Object)this.futureImage)).getErroneousLayer()) != null && !layers.isEmpty()) {
                        String layersWithErrors = null;
                        for (RetrievalService service : layers) {
                            if (layersWithErrors == null) {
                                layersWithErrors = service.toString();
                                continue;
                            }
                            layersWithErrors = layersWithErrors + "\n" + service.toString();
                        }
                        MappingComponent parent = CismapBroker.getInstance().getMappingComponent();
                        JOptionPane.showMessageDialog((Component)((Object)parent), NbBundle.getMessage(FutureImageDownload.class, (String)"FutureImageDownload.run().cannotLoadLayer.message", layersWithErrors), NbBundle.getMessage(FutureImageDownload.class, (String)"FutureImageDownload.run().cannotLoadLayer.title"), 2);
                    }
                } else {
                    this.deleteFile();
                }
            }
            catch (InterruptedException ex) {
                this.deleteFile();
                this.releaseMemory();
                return;
            }
            catch (ExecutionException ex) {
                LOG.error((Object)"Error while getting the image.", (Throwable)ex);
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                this.deleteFile();
                this.releaseMemory();
                return;
            }
        }
        if (image != null && !Thread.interrupted()) {
            try {
                ImageIO.write((RenderedImage)this.prepareImage(image), this.extension, this.fileToSaveTo);
            }
            catch (IOException ex) {
                LOG.error((Object)"Error while saving the image", (Throwable)ex);
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                this.deleteFile();
                this.releaseMemory();
                return;
            }
        } else {
            this.status = Download.State.COMPLETED_WITH_ERROR;
            this.stateChanged();
            this.deleteFile();
            this.releaseMemory();
            return;
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
        this.releaseMemory();
    }

    private void releaseMemory() {
        this.futureImage = null;
    }

    private BufferedImage prepareImage(Image image) {
        if (this.extension.endsWith("jpg") || this.extension.endsWith("jpeg")) {
            return this.removeTransparency(image);
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage removeTransparency(Image transparentImage) {
        BufferedImage whiteBackgroundImage = new BufferedImage(transparentImage.getWidth(null), transparentImage.getHeight(null), 1);
        Graphics2D g2 = null;
        try {
            g2 = whiteBackgroundImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, whiteBackgroundImage.getWidth(), whiteBackgroundImage.getHeight());
            g2.drawImage(transparentImage, 0, 0, whiteBackgroundImage.getWidth(), whiteBackgroundImage.getHeight(), null);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
        return whiteBackgroundImage;
    }

    public boolean cancel() {
        boolean cancelled = true;
        if (this.downloadFuture != null) {
            cancelled = this.downloadFuture.cancel(true);
        }
        if (cancelled) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
            this.releaseMemory();
        }
        return cancelled;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.futureImageHash;
        hash = 37 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 37 * hash + (this.fileToSaveTo != null ? this.fileToSaveTo.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FutureImageDownload other = (FutureImageDownload)((Object)obj);
        if (this.futureImageHash != other.futureImageHash) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return this.fileToSaveTo == other.fileToSaveTo || this.fileToSaveTo != null && this.fileToSaveTo.equals(other.fileToSaveTo);
    }
}

