/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.util;

import java.util.HashMap;
import java.util.Map;

public class SimpleCache<T> {
    private String[] ids;
    private int index = 0;
    private Map<String, T> dataMap;

    public SimpleCache(int size) {
        this.init(size);
    }

    private void init(int size) {
        this.ids = new String[size];
        this.index = 0;
        this.dataMap = new HashMap<String, T>();
    }

    public void clear() {
        this.ids = new String[this.ids.length];
        this.index = 0;
        this.dataMap.clear();
    }

    public void add(String id, T data) {
        if (this.ids[this.index] != null) {
            this.dataMap.remove(this.ids[this.index]);
        }
        this.ids[this.index] = id;
        this.increaseIndex();
        this.dataMap.put(id, data);
    }

    public void add(int id, T data) {
        this.add(String.valueOf(id), data);
    }

    public T get(String id) {
        T res = this.dataMap.get(id);
        if (res != null) {
            while (this.ids[this.index] == null || !this.ids[this.index].equals(id)) {
                this.increaseIndex();
            }
            this.increaseIndex();
        }
        return res;
    }

    public T get(int id) {
        return this.get(String.valueOf(id));
    }

    private void setSize(int size) {
        this.init(size);
    }

    private void increaseIndex() {
        ++this.index;
        if (this.index >= this.ids.length) {
            this.index = 0;
        }
    }
}

