/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import com.vividsolutions.jts.geom.Point;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.events.CrsChangedEvent;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.cismap.commons.wfsforms.WFSFormsListAndComboBoxModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.util.NbBundle;

public abstract class AbstractWFSForm
extends JPanel
implements CrsChangeListener {
    public static final int FEATURE_BORDER = 200;
    protected HashMap<String, JComponent> listComponents = new HashMap();
    protected HashMap<String, WFSFormQuery> queriesByComponentName = new HashMap();
    protected ImageIcon mark = new ImageIcon(this.getClass().getResource("/images/markPoint.png"));
    protected FixedPImage pMark = new FixedPImage(this.mark.getImage());
    protected MappingComponent mappingComponent;
    Vector<ActionListener> actionListener = new Vector();
    private final Properties sweetSpotOfpMark = new Properties();
    private final Logger log = Logger.getLogger(this.getClass());
    private Vector<WFSFormQuery> queries = new Vector();
    private final String loadingMessage = NbBundle.getMessage(AbstractWFSForm.class, (String)"AbstractWFSForm.loadingMessage");
    private final String errorMessage = NbBundle.getMessage(WFSFormsListAndComboBoxModel.class, (String)"WFSFormsListAndComboBoxModel.errorMessage");
    private WFSFormFeature lastFeature = null;
    private String title;
    private String id;
    private String menuString;
    private Icon icon;
    private String iconPath;
    private String className;
    private boolean inited = false;
    private String sorter = null;
    private WFSFormFeature lastVisualizedFeature = null;

    public AbstractWFSForm() {
        try {
            this.sweetSpotOfpMark.load(this.getClass().getResourceAsStream("/images/markPointSweetSpot.properties"));
            this.pMark.setSweetSpotX(Double.valueOf(this.sweetSpotOfpMark.getProperty("x", "0")));
            this.pMark.setSweetSpotY(Double.valueOf(this.sweetSpotOfpMark.getProperty("y", "0")));
        }
        catch (IOException iox) {
            this.log.warn((Object)"Problem when loading the markPointSweetSpot.properties", (Throwable)iox);
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!AbstractWFSForm.this.isInited() && AbstractWFSForm.this.isDisplayable()) {
                    AbstractWFSForm.this.initWFSForm();
                }
            }
        });
        this.pMark.setVisible(false);
    }

    public JComponent getListComponentByName(String name) {
        return this.listComponents.get(name);
    }

    public void initWFSForm() {
        try {
            this.inited = true;
            for (WFSFormQuery q : this.queries) {
                WFSFormsListAndComboBoxModel w;
                JProgressBar bar;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.title + "Components:" + this.listComponents));
                }
                this.queriesByComponentName.put(q.getComponentName(), q);
                if (!q.getType().equals("INITIAL") || !this.listComponents.containsKey(q.getComponentName())) continue;
                JComponent c = this.listComponents.get(q.getComponentName());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Comp: " + q.getComponentName()));
                }
                if (c instanceof JComboBox) {
                    try {
                        bar = (JProgressBar)this.listComponents.get(q.getComponentName() + "Progress");
                        w = new WFSFormsListAndComboBoxModel(q, c, bar);
                        w.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                AbstractWFSForm.this.fireActionPerformed(e);
                            }
                        });
                        ((JComboBox)c).setModel(w);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"Error in initWFSForm", (Throwable)ex);
                    }
                    continue;
                }
                if (!(c instanceof JList)) continue;
                try {
                    bar = (JProgressBar)this.listComponents.get(q.getComponentName() + "Progress");
                    w = new WFSFormsListAndComboBoxModel(q, c, bar);
                    w.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AbstractWFSForm.this.fireActionPerformed(e);
                        }
                    });
                    ((JList)c).setModel(w);
                }
                catch (Exception ex) {
                    this.log.error((Object)"Error in initWFSForm", (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error during initWFSForm", (Throwable)e);
        }
    }

    protected void checkCboCorrectness(JComboBox combo) {
        String itemString = String.valueOf(combo.getSelectedItem()).trim();
        if (!(combo.getSelectedItem() == null || itemString.equals("") || itemString.equals(this.loadingMessage) || itemString.equals(this.errorMessage) || combo.getSelectedIndex() != -1)) {
            combo.getEditor().getEditorComponent().setBackground(Color.red);
            this.garbageDuringAutoCompletion(combo);
        } else {
            combo.getEditor().getEditorComponent().setBackground(Color.white);
        }
    }

    public abstract void garbageDuringAutoCompletion(JComboBox var1);

    public void requestRefresh(String component, HashMap<String, String> replacingValues) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("requestRefresh: Queries=" + this.queries));
        }
        for (WFSFormQuery q : this.queries) {
            WFSFormsListAndComboBoxModel model;
            JProgressBar bar;
            if (!component.equals(q.getComponentName()) || !this.listComponents.containsKey(q.getComponentName())) continue;
            JComponent c = this.listComponents.get(q.getComponentName());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("requestRefresh JComponent=" + c));
            }
            if (c instanceof JComboBox) {
                try {
                    bar = (JProgressBar)this.listComponents.get(q.getComponentName() + "Progress");
                    model = new WFSFormsListAndComboBoxModel(q, replacingValues, c, bar);
                    model.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AbstractWFSForm.this.fireActionPerformed(e);
                        }
                    });
                    ((JComboBox)c).setModel(model);
                }
                catch (Exception ex) {
                    this.log.error((Object)"Error in requestRefresh", (Throwable)ex);
                }
                continue;
            }
            if (!(c instanceof JList)) continue;
            try {
                bar = (JProgressBar)this.listComponents.get(q.getComponentName() + "Progress");
                model = new WFSFormsListAndComboBoxModel(q, replacingValues, c, bar);
                model.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractWFSForm.this.fireActionPerformed(e);
                    }
                });
                ((JList)c).setModel(model);
            }
            catch (Exception ex) {
                this.log.error((Object)"Error in requestRefresh", (Throwable)ex);
            }
        }
    }

    public Element getElement() {
        Element ret = new Element("wfsForm");
        ret.setAttribute("id", this.getId());
        ret.setAttribute("title", this.getTitle());
        ret.setAttribute("icon", this.getIconPath());
        ret.setAttribute("className", this.getClassName());
        ret.setAttribute("menu", this.getMenuString());
        for (WFSFormQuery query : this.queries) {
            ret.addContent((Content)query.getElement());
        }
        return ret;
    }

    public void requestRefresh(String component, WFSFormFeature value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("requestRefresh(+" + component + "," + value + ")"));
        }
        if (this.lastFeature == null || !value.getIdentifier().equals(this.lastFeature.getIdentifier())) {
            this.lastFeature = value;
            WFSFormQuery q = this.queriesByComponentName.get(component);
            if (q != null) {
                HashMap<String, String> hm = new HashMap<String, String>();
                hm.put(q.getQueryPlaceholder(), value.getIdentifier());
                this.requestRefresh(component, hm);
            }
        }
    }

    public void visualizePosition(WFSFormFeature feature, boolean showMarker) {
        this.lastVisualizedFeature = feature;
        this.mappingComponent.getHighlightingLayer().removeAllChildren();
        this.mappingComponent.getHighlightingLayer().addChild((PNode)this.pMark);
        this.mappingComponent.addStickyNode(this.pMark);
        Point p = CrsTransformer.transformToGivenCrs(feature.getPosition(), this.mappingComponent.getMappingModel().getSrs().getCode());
        double x = this.mappingComponent.getWtst().getScreenX(p.getCoordinate().x);
        double y = this.mappingComponent.getWtst().getScreenY(p.getCoordinate().y);
        this.pMark.setOffset(x, y);
        this.pMark.setVisible(showMarker);
        this.mappingComponent.rescaleStickyNodes();
        CismapBroker.getInstance().removeCrsChangeListener(this);
        CismapBroker.getInstance().addCrsChangeListener(this);
    }

    public Vector<WFSFormQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(Vector<WFSFormQuery> queries) {
        this.queries = queries;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMenuString() {
        return this.menuString;
    }

    public void setMenuString(String menuString) {
        this.menuString = menuString;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isInited() {
        return this.inited;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public void setMappingComponent(MappingComponent mappingComponent) {
        this.mappingComponent = mappingComponent;
        mappingComponent.addStickyNode(this.pMark);
    }

    public void addActionListener(ActionListener a) {
        this.actionListener.add(a);
    }

    public void removeActionListener(ActionListener a) {
        this.actionListener.remove(a);
    }

    public void fireActionPerformed(ActionEvent e) {
        for (ActionListener a : this.actionListener) {
            a.actionPerformed(e);
        }
    }

    public String getSorter() {
        return this.sorter;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        CismapBroker.getInstance().removeCrsChangeListener(this);
    }

    public void setSorter(String sorter) {
        this.sorter = sorter;
    }

    @Override
    public void crsChanged(CrsChangedEvent event) {
        if (this.mappingComponent.getHighlightingLayer().getAllNodes().contains(this.pMark) && this.lastVisualizedFeature != null) {
            this.visualizePosition(this.lastVisualizedFeature, this.pMark.getVisible());
        }
    }
}

