/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.tools.configuration.Configurable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class WFSFormFactory
implements Configurable {
    private static WFSFormFactory singletonInstance;
    private final Logger log = Logger.getLogger(this.getClass());
    private LinkedHashMap<String, AbstractWFSForm> forms = new LinkedHashMap();
    private Element configuration;
    private MappingComponent mappingComponent;
    private boolean problemDuringSorting = false;

    private WFSFormFactory(MappingComponent map) {
        this.mappingComponent = map;
    }

    public static WFSFormFactory getInstance(MappingComponent map) {
        if (singletonInstance == null) {
            singletonInstance = new WFSFormFactory(map);
        }
        return singletonInstance;
    }

    public static WFSFormFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new WFSFormFactory(null);
        }
        return singletonInstance;
    }

    public Element getConfiguration() {
        Element ret = new Element("cismapWFSFormsPreferences");
        return ret;
    }

    public void masterConfigure(Element parent) {
        this.forms.clear();
        try {
            this.configuration = (Element)((Element)parent.clone()).getChild("cismapWFSFormsPreferences").detach();
            List list = this.configuration.getChildren("wfsForm");
            for (Object o : list) {
                try {
                    Element e = (Element)o;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Try to create WFSForm: " + e.getContent()));
                    }
                    String className = e.getAttribute("className").getValue();
                    Class<?> formClass = Class.forName(className);
                    Constructor<?> constructor = formClass.getConstructor(new Class[0]);
                    AbstractWFSForm form = (AbstractWFSForm)constructor.newInstance(new Object[0]);
                    form.setClassName(className);
                    form.setId(e.getAttribute("id").getValue());
                    try {
                        form.setSorter(e.getAttribute("sorter").getValue());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    form.setTitle(e.getAttribute("title").getValue());
                    form.setMenuString(e.getAttribute("menu").getValue());
                    form.setIconPath(e.getAttribute("icon").getValue());
                    form.setIcon(new ImageIcon(this.getClass().getResource(e.getAttribute("icon").getValue())));
                    Vector<WFSFormQuery> queryVector = new Vector<WFSFormQuery>();
                    List queries = e.getChildren("wfsFormQuery");
                    for (Object oq : queries) {
                        Element q = (Element)oq;
                        WFSFormQuery query = new WFSFormQuery();
                        query.setComponentName(q.getAttribute("componentName").getValue());
                        query.setDisplayTextProperty(q.getAttribute("displayTextProperty").getValue());
                        query.setExtentProperty(q.getAttribute("extentProperty").getValue());
                        query.setFilename(q.getAttribute("queryFile").getValue());
                        query.setWfsQueryString(this.readFileFromClassPathAsString(query.getFilename()));
                        query.setId(q.getAttribute("id").getValue());
                        query.setIdProperty(q.getAttribute("idProperty").getValue());
                        query.setServerUrl(q.getAttribute("server").getValue());
                        query.setTitle(q.getAttribute("title").getValue());
                        query.setType(q.getAttribute("type").getValue());
                        try {
                            query.setPropertyPrefix(q.getAttribute("propertyPrefix").getValue());
                        }
                        catch (Exception skip) {
                            query.setPropertyPrefix(null);
                        }
                        try {
                            query.setPropertyNamespace(q.getAttribute("propertyNamespace").getValue());
                        }
                        catch (Exception skip) {
                            query.setPropertyNamespace(null);
                        }
                        try {
                            query.setPositionProperty(q.getAttribute("positionProperty").getValue());
                        }
                        catch (Exception skip) {
                            query.setPositionProperty(null);
                        }
                        if (q.getAttribute("queryPlaceholder") != null) {
                            query.setQueryPlaceholder(q.getAttribute("queryPlaceholder").getValue());
                        }
                        queryVector.add(query);
                    }
                    form.setQueries(queryVector);
                    this.forms.put(form.getId(), form);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("WFSForm " + form.getId() + " added"));
                }
                catch (Throwable t) {
                    this.log.error((Object)"Could not create WFSForm", t);
                }
            }
            LinkedHashMap<String, AbstractWFSForm> lhs = new LinkedHashMap<String, AbstractWFSForm>(this.forms.size());
            Vector<String> keylistSorted = new Vector<String>(this.forms.keySet());
            Collections.sort(keylistSorted, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    try {
                        String sortO1 = ((AbstractWFSForm)WFSFormFactory.this.forms.get(o1)).getSorter();
                        String sortO2 = ((AbstractWFSForm)WFSFormFactory.this.forms.get(o2)).getSorter();
                        if (sortO1 != null && sortO2 != null) {
                            return sortO1.compareTo(sortO2);
                        }
                        WFSFormFactory.this.problemDuringSorting = true;
                    }
                    catch (Exception e) {
                        WFSFormFactory.this.problemDuringSorting = true;
                    }
                    return o1.compareTo(o2);
                }
            });
            if (!this.problemDuringSorting) {
                for (String key : keylistSorted) {
                    lhs.put(key, this.forms.get(key));
                }
                this.forms = lhs;
            } else {
                this.log.warn((Object)"Error while sorting the WFSForms. The order of the config file will be retained.");
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Could not create WFSForm", t);
        }
    }

    public void configure(Element parent) {
    }

    public LinkedHashMap<String, AbstractWFSForm> getForms() {
        return this.forms;
    }

    private String readFileFromClassPathAsString(String filePath) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuffer fileData = new StringBuffer(1000);
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

