/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.commons.wfsforms;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormAdress;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class WFSFormPOI
extends AbstractWFSForm {
    private final Logger log = Logger.getLogger(this.getClass());
    private WFSFormFeature locationtype = null;
    private WFSFormFeature poi = null;
    private JComboBox cboLocationtypes;
    private JComboBox cboPois;
    private JCheckBox chkLockScale;
    private JCheckBox chkVisualize;
    private JButton cmdOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JProgressBar prbLocationtypes;
    private JProgressBar prbPois;

    public WFSFormPOI() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"new WFSFormPOI");
        }
        try {
            this.initComponents();
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboLocationtypes);
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboPois);
            this.prbLocationtypes.setPreferredSize(new Dimension(1, 5));
            this.prbPois.setPreferredSize(new Dimension(1, 5));
            this.listComponents.put("cboAllLocationtypes", this.cboLocationtypes);
            this.listComponents.put("cboAllLocationtypesProgress", this.prbLocationtypes);
            this.listComponents.put("cboPoisOfALocationtype", this.cboPois);
            this.listComponents.put("cboPoisOfALocationtypeProgress", this.prbPois);
            JTextField poiEditor = (JTextField)this.cboPois.getEditor().getEditorComponent();
            poiEditor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    WFSFormPOI.this.log.fatal((Object)WFSFormPOI.this.cboPois.getSelectedIndex());
                    WFSFormPOI.this.checkCboCorrectness(WFSFormPOI.this.cboPois);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    WFSFormPOI.this.checkCboCorrectness(WFSFormPOI.this.cboPois);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    WFSFormPOI.this.checkCboCorrectness(WFSFormPOI.this.cboPois);
                }
            });
        }
        catch (Exception e) {
            this.log.error((Object)"Could not Create WFForm", (Throwable)e);
        }
    }

    @Override
    public void garbageDuringAutoCompletion(JComboBox box) {
        this.poi = null;
    }

    private void initComponents() {
        this.cmdOk = new JButton();
        this.chkVisualize = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.chkLockScale = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cboPois = new JComboBox();
        this.prbPois = new JProgressBar();
        this.cboLocationtypes = new JComboBox();
        this.prbLocationtypes = new JProgressBar();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMinimumSize(new Dimension(373, 1));
        this.setLayout(new GridBagLayout());
        this.cmdOk.setMnemonic('P');
        this.cmdOk.setText(NbBundle.getMessage(WFSFormPOI.class, (String)"WFSFormPOI.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormPOI.this.cmdOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.cmdOk, gridBagConstraints);
        this.chkVisualize.setSelected(true);
        this.chkVisualize.setToolTipText(NbBundle.getMessage(WFSFormPOI.class, (String)"WFSFormPOI.chkVisualize.toolTipText"));
        this.chkVisualize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormPOI.this.chkVisualizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add((Component)this.chkVisualize, gridBagConstraints);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/markPoint.png")));
        this.jLabel1.setToolTipText(NbBundle.getMessage(WFSFormPOI.class, (String)"WFSFormPOI.jLabel1.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 7, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.chkLockScale.setSelected(true);
        this.chkLockScale.setToolTipText(NbBundle.getMessage(WFSFormPOI.class, (String)"WFSFormPOI.chkLockScale.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 14, 0, 0);
        this.add((Component)this.chkLockScale, gridBagConstraints);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this.jLabel2.setToolTipText(NbBundle.getMessage(WFSFormPOI.class, (String)"WFSFormPOI.jLabel2.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 7, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(1, 1));
        this.jPanel1.setPreferredSize(new Dimension(1, 1));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 9, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.cboPois.setEditable(true);
        this.cboPois.setEnabled(false);
        this.cboPois.setMaximumSize(new Dimension(180, 19));
        this.cboPois.setMinimumSize(new Dimension(180, 19));
        this.cboPois.setPreferredSize(new Dimension(180, 19));
        this.cboPois.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormPOI.this.cboPoisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 30.0;
        gridBagConstraints.insets = new Insets(2, 3, 0, 0);
        this.add((Component)this.cboPois, gridBagConstraints);
        this.prbPois.setBorderPainted(false);
        this.prbPois.setMaximumSize(new Dimension(100, 5));
        this.prbPois.setMinimumSize(new Dimension(100, 5));
        this.prbPois.setPreferredSize(new Dimension(100, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 10);
        this.add((Component)this.prbPois, gridBagConstraints);
        this.cboLocationtypes.setEnabled(false);
        this.cboLocationtypes.setMaximumSize(new Dimension(180, 19));
        this.cboLocationtypes.setMinimumSize(new Dimension(180, 19));
        this.cboLocationtypes.setPreferredSize(new Dimension(180, 19));
        this.cboLocationtypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormPOI.this.cboLocationtypesActionPerformed(evt);
            }
        });
        this.cboLocationtypes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                WFSFormPOI.this.cboLocationtypesKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 60.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.cboLocationtypes, gridBagConstraints);
        this.prbLocationtypes.setBorderPainted(false);
        this.prbLocationtypes.setMaximumSize(new Dimension(100, 5));
        this.prbLocationtypes.setMinimumSize(new Dimension(100, 5));
        this.prbLocationtypes.setPreferredSize(new Dimension(100, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.add((Component)this.prbLocationtypes, gridBagConstraints);
    }

    private void chkVisualizeActionPerformed(ActionEvent evt) {
        MappingComponent mc = this.getMappingComponent();
        if (mc == null) {
            mc = CismapBroker.getInstance().getMappingComponent();
        }
        if (this.poi != null) {
            this.visualizePosition(this.poi, this.chkVisualize.isSelected());
        }
    }

    private void cboLocationtypesActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"cboStreetsActionPerformed()");
        }
        if (this.cboLocationtypes.getSelectedItem() instanceof WFSFormFeature) {
            this.locationtype = (WFSFormFeature)this.cboLocationtypes.getSelectedItem();
            this.poi = null;
            this.requestRefresh("cboPoisOfALocationtype", (WFSFormFeature)this.cboLocationtypes.getSelectedItem());
        }
    }

    private void cboLocationtypesKeyTyped(KeyEvent evt) {
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        boolean history = true;
        MappingComponent mc = this.getMappingComponent();
        if (mc == null) {
            mc = CismapBroker.getInstance().getMappingComponent();
        }
        boolean scaling = !mc.isFixedMapScale() && !this.chkLockScale.isSelected();
        XBoundingBox bb = null;
        int animation = mc.getAnimationDuration();
        if (this.poi != null) {
            bb = scaling ? new XBoundingBox(this.poi.getJTSGeometry()) : new XBoundingBox(this.poi.getPosition().buffer(200.0));
        } else {
            return;
        }
        mc.gotoBoundingBox(bb, true, scaling, animation);
        this.chkVisualizeActionPerformed(null);
    }

    private void cboPoisActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"cboPoisActionPerformed()");
        }
        if (this.cboPois.getSelectedItem() instanceof WFSFormFeature) {
            this.poi = (WFSFormFeature)this.cboPois.getSelectedItem();
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WFSFormQuery allStreets = new WFSFormQuery();
        allStreets.setComponentName("cboAllStreets");
        allStreets.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");
        allStreets.setDisplayTextProperty("geographicIdentifier");
        allStreets.setExtentProperty("geographicExtent");
        allStreets.setFilename("/request_all_streets.xml");
        allStreets.setId("all_streets");
        allStreets.setIdProperty("identifier");
        allStreets.setTitle("Strassen");
        allStreets.setType("INITIAL");
        allStreets.setWfsQueryString(WFSFormPOI.readFileAsString(new File("C:\\request_alle_strassen_extent.xml")));
        WFSFormQuery numbers = new WFSFormQuery();
        numbers.setComponentName("cboNumbersOfAStreet");
        numbers.setServerUrl("http://s103bdc-a1/deegreewfs/wfs");
        numbers.setDisplayTextProperty("geographicIdentifier");
        numbers.setExtentProperty("geographicExtent");
        numbers.setFilename("/request_all_numbers.xml");
        numbers.setId("numbers");
        numbers.setIdProperty("identifier");
        numbers.setTitle("Nr");
        numbers.setType("FOLLOWUP");
        numbers.setQueryPlaceholder("@@strasse_id@@");
        numbers.setWfsQueryString(WFSFormPOI.readFileAsString(new File("C:\\request_hausnummern_from_strasse_extent.xml")));
        Vector<WFSFormQuery> v = new Vector<WFSFormQuery>();
        v.add(allStreets);
        v.add(numbers);
        final WFSFormAdress tester = new WFSFormAdress();
        tester.setQueries(v);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                f.getContentPane().setLayout(new BorderLayout());
                f.getContentPane().add((Component)tester, "Center");
                f.setVisible(true);
                f.setSize(365, 65);
            }
        });
    }

    private static String readFileAsString(File file) throws IOException {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }
}

