/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.commons.cismap.io;

import de.cismet.cismap.commons.util.DnDUtils;
import de.cismet.commons.cismap.io.AddGeometriesToMapEnterDataWizardPanel;
import de.cismet.commons.converter.FormatHint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.EventListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class AddGeometriesToMapEnterDataVisualPanel
extends JPanel {
    private static final transient Logger LOG = Logger.getLogger(AddGeometriesToMapEnterDataVisualPanel.class);
    private final transient AddGeometriesToMapEnterDataWizardPanel model;
    private final transient ChangeListener modelChangeL;
    private final transient ActionListener openFileL;
    private final transient JFileChooser fileChooser;
    private final transient JButton btnOpenFile = new DnDButton();
    private final transient JEditorPane edpCoordinates = new DnDEditorPane();
    private final transient JScrollPane jScrollPane1 = new JScrollPane();
    private final transient JLabel lblCoordinates = new JLabel();
    private final transient JLabel lblFile = new JLabel();
    private final transient JLabel lblSelectedConverter = new JLabel();
    private final transient JLabel lblSelectedConverterValue = new JLabel();
    private final transient JPanel pnlSelectedConverter = new JPanel();
    private final transient JSeparator sepSelectedConverter = new JSeparator();
    private final transient JTextField txtFile = new DnDTextField();
    private BindingGroup bindingGroup;

    public AddGeometriesToMapEnterDataVisualPanel(AddGeometriesToMapEnterDataWizardPanel model) {
        this.model = model;
        this.modelChangeL = new ModelChangeListener();
        this.openFileL = new OpenFileListener();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setAcceptAllFileFilterUsed(true);
        this.fileChooser.setMultiSelectionEnabled(false);
        this.initComponents();
        this.setName(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.<init>(AddGeomtriesToMapEnterDataWizardPanel).panelName"));
        this.model.addChangeListener(WeakListeners.change((ChangeListener)this.modelChangeL, (Object)((Object)model)));
        this.btnOpenFile.addActionListener((ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.openFileL, (Object)this.btnOpenFile));
    }

    public AddGeometriesToMapEnterDataWizardPanel getModel() {
        return this.model;
    }

    private void openFileChooser(File input) {
        if (input == null) {
            this.fileChooser.setSelectedFile(this.model.getInputFile());
        } else {
            this.fileChooser.setSelectedFile(input);
        }
        int answer = this.fileChooser.showOpenDialog(this);
        if (0 == answer) {
            File file = this.fileChooser.getSelectedFile();
            this.model.setInputFile(file);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.lblCoordinates.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblCoordinates.text"));
        this.lblCoordinates.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblCoordinates.toolTipText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblCoordinates, gridBagConstraints);
        this.edpCoordinates.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.edpCoordinates.toolTipText"));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${model.coordinateData}"), (Object)this.edpCoordinates, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jScrollPane1.setViewportView(this.edpCoordinates);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblFile.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblFile.text"));
        this.lblFile.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblFile.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.lblFile, gridBagConstraints);
        this.txtFile.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.txtFile.toolTipText"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${model.inputFile}"), (Object)this.txtFile, (Property)BeanProperty.create((String)"text"));
        binding.setConverter((Converter)new InputFileConverter());
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.txtFile, gridBagConstraints);
        this.btnOpenFile.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.btnOpenFile.text"));
        this.btnOpenFile.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.btnOpenFile.toolTipText"));
        this.btnOpenFile.setMaximumSize(new Dimension(50, 29));
        this.btnOpenFile.setMinimumSize(new Dimension(50, 29));
        this.btnOpenFile.setPreferredSize(new Dimension(50, 29));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnOpenFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.sepSelectedConverter, gridBagConstraints);
        this.pnlSelectedConverter.setOpaque(false);
        this.pnlSelectedConverter.setLayout(new GridBagLayout());
        this.lblSelectedConverterValue.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblSelectedConverterValue.text"));
        this.lblSelectedConverterValue.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblSelectedConverterValue.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSelectedConverter.add((Component)this.lblSelectedConverterValue, gridBagConstraints);
        this.lblSelectedConverter.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblSelectedConverter.text"));
        this.lblSelectedConverter.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblSelectedConverter.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlSelectedConverter.add((Component)this.lblSelectedConverter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlSelectedConverter, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private final class DnDTextField
    extends JTextField
    implements DropTargetListener {
        private final transient DropTarget dropTarget = new DropTarget(this, this);

        private DnDTextField() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(3);
                if (dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                    String uriList = (String)dtde.getTransferable().getTransferData(DnDUtils.URI_LIST_FLAVOR);
                    String[] uris = uriList.split(System.getProperty("line.separator"));
                    if (uris.length == 1) {
                        File file = new File(new URI(uris[0].replaceFirst("localhost", "")));
                        dtde.dropComplete(true);
                        AddGeometriesToMapEnterDataVisualPanel.this.model.setInputFile(file);
                    } else {
                        dtde.dropComplete(false);
                    }
                } else {
                    List data = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (data.size() == 1) {
                        File file = (File)data.get(0);
                        dtde.dropComplete(true);
                        AddGeometriesToMapEnterDataVisualPanel.this.model.setInputFile(file);
                    } else {
                        dtde.dropComplete(false);
                    }
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("reject drop: " + dtde), (Throwable)e);
                }
                dtde.dropComplete(false);
            }
        }
    }

    private final class DnDEditorPane
    extends JEditorPane
    implements DropTargetListener {
        private final transient DropTarget dropTarget = new DropTarget(this, this);

        private DnDEditorPane() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(3);
                if (dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                    String uriList = (String)dtde.getTransferable().getTransferData(DnDUtils.URI_LIST_FLAVOR);
                    String[] uris = uriList.split(System.getProperty("line.separator"));
                    if (uris.length == 1) {
                        File file = new File(new URI(uris[0].replaceFirst("localhost", "")));
                        dtde.dropComplete(true);
                        AddGeometriesToMapEnterDataVisualPanel.this.model.setInputFile(file);
                    } else {
                        dtde.dropComplete(false);
                    }
                } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List data = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (data.size() == 1) {
                        File file = (File)data.get(0);
                        dtde.dropComplete(true);
                        AddGeometriesToMapEnterDataVisualPanel.this.model.setInputFile(file);
                    } else {
                        dtde.dropComplete(false);
                    }
                } else {
                    String data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    dtde.dropComplete(true);
                    AddGeometriesToMapEnterDataVisualPanel.this.model.setInputFile(null);
                    AddGeometriesToMapEnterDataVisualPanel.this.model.setCoordinateData(data);
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("reject drop: " + dtde), (Throwable)e);
                }
                dtde.dropComplete(false);
            }
        }
    }

    private final class DnDButton
    extends JButton
    implements DropTargetListener {
        private final transient DropTarget dropTarget = new DropTarget(this, this);

        private DnDButton() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                dtde.acceptDrag(3);
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                File file;
                dtde.acceptDrop(3);
                if (dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                    String uriList = (String)dtde.getTransferable().getTransferData(DnDUtils.URI_LIST_FLAVOR);
                    String[] uris = uriList.split(System.getProperty("line.separator"));
                    if (uris.length == 1) {
                        file = new File(new URI(uris[0].replaceFirst("localhost", "")));
                        dtde.dropComplete(true);
                    } else {
                        file = null;
                        dtde.dropComplete(false);
                    }
                } else {
                    List data = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (data.size() == 1) {
                        file = (File)data.get(0);
                        dtde.dropComplete(true);
                    } else {
                        file = null;
                        dtde.dropComplete(false);
                    }
                }
                if (file != null) {
                    AddGeometriesToMapEnterDataVisualPanel.this.openFileChooser(file);
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("reject drop: " + dtde), (Throwable)e);
                }
                dtde.dropComplete(false);
            }
        }
    }

    private static final class InputFileConverter
    extends Converter<File, String> {
        private InputFileConverter() {
        }

        public String convertForward(File value) {
            if (value == null) {
                return null;
            }
            return value.getAbsolutePath();
        }

        public File convertReverse(String value) {
            if (value == null) {
                return null;
            }
            return new File(value);
        }
    }

    private final class ModelChangeListener
    implements ChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof AddGeometriesToMapEnterDataWizardPanel) {
                de.cismet.commons.converter.Converter conv;
                AddGeometriesToMapEnterDataVisualPanel.this.lblCoordinates.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblCoordinates.text", (Object)AddGeometriesToMapEnterDataVisualPanel.this.model.getCrsName()));
                String text = AddGeometriesToMapEnterDataVisualPanel.this.model.getCoordinateData();
                if (text == null || !text.equals(AddGeometriesToMapEnterDataVisualPanel.this.edpCoordinates.getText())) {
                    AddGeometriesToMapEnterDataVisualPanel.this.edpCoordinates.setText(text);
                }
                if ((conv = AddGeometriesToMapEnterDataVisualPanel.this.model.getSelectedConverter()) instanceof FormatHint) {
                    AddGeometriesToMapEnterDataVisualPanel.this.lblSelectedConverterValue.setText(((FormatHint)conv).getFormatDisplayName());
                } else if (conv == null) {
                    AddGeometriesToMapEnterDataVisualPanel.this.lblSelectedConverterValue.setText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblSelectedConverterValue.text"));
                } else {
                    AddGeometriesToMapEnterDataVisualPanel.this.lblSelectedConverterValue.setText(conv.toString());
                }
                AddGeometriesToMapEnterDataVisualPanel.this.lblSelectedConverterValue.setToolTipText(NbBundle.getMessage(AddGeometriesToMapEnterDataVisualPanel.class, (String)"AddGeometriesToMapEnterDataVisualPanel.lblSelectedConverterValue.toolTipText", (Object)AddGeometriesToMapEnterDataVisualPanel.this.model.getConverterPreselectionMode()));
            }
        }
    }

    private final class OpenFileListener
    implements ActionListener {
        private OpenFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddGeometriesToMapEnterDataVisualPanel.this.openFileChooser(null);
        }
    }
}

